/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.StopReplicaRequestData;
import org.apache.kafka.common.message.StopReplicaResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.StopReplicaRequest;
import org.apache.kafka.common.requests.StopReplicaResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StopReplicaRequestTest {
    @Test
    public void testUnsupportedVersion() {
        StopReplicaRequest.Builder builder = new StopReplicaRequest.Builder((short)(ApiKeys.STOP_REPLICA.latestVersion() + 1), 0, 0, 0L, false, Collections.emptyList());
        Assertions.assertThrows(UnsupportedVersionException.class, () -> ((StopReplicaRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        List<StopReplicaRequestData.StopReplicaTopicState> topicStates = this.topicStates(true);
        HashSet<StopReplicaResponseData.StopReplicaPartitionError> expectedPartitions = new HashSet<StopReplicaResponseData.StopReplicaPartitionError>();
        for (StopReplicaRequestData.StopReplicaTopicState topicState : topicStates) {
            for (StopReplicaRequestData.StopReplicaPartitionState partitionState : topicState.partitionStates()) {
                expectedPartitions.add(new StopReplicaResponseData.StopReplicaPartitionError().setTopicName(topicState.topicName()).setPartitionIndex(partitionState.partitionIndex()).setErrorCode(Errors.CLUSTER_AUTHORIZATION_FAILED.code()));
            }
        }
        Iterator<StopReplicaRequestData.StopReplicaTopicState> iterator = ApiKeys.STOP_REPLICA.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)((Object)iterator.next());
            StopReplicaRequest.Builder builder = new StopReplicaRequest.Builder(version, 0, 0, 0L, false, topicStates);
            StopReplicaRequest request = (StopReplicaRequest)builder.build();
            StopReplicaResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
            Assertions.assertEquals(expectedPartitions, new HashSet(response.partitions()));
        }
    }

    @Test
    public void testBuilderNormalizationWithAllDeletePartitionEqualToTrue() {
        this.testBuilderNormalization(true);
    }

    @Test
    public void testBuilderNormalizationWithAllDeletePartitionEqualToFalse() {
        this.testBuilderNormalization(false);
    }

    private void testBuilderNormalization(boolean deletePartitions) {
        List<StopReplicaRequestData.StopReplicaTopicState> topicStates = this.topicStates(deletePartitions);
        Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState> expectedPartitionStates = StopReplicaRequestTest.partitionStates(topicStates);
        Iterator iterator = ApiKeys.STOP_REPLICA.allVersions().iterator();
        while (iterator.hasNext()) {
            HashSet<TopicPartition> partitions;
            short version = (Short)iterator.next();
            StopReplicaRequest request = new StopReplicaRequest.Builder(version, 0, 1, 0L, deletePartitions, topicStates).build(version);
            StopReplicaRequestData data = request.data();
            if (version < 1) {
                partitions = new HashSet<TopicPartition>();
                for (StopReplicaRequestData.StopReplicaPartitionV0 partition : data.ungroupedPartitions()) {
                    partitions.add(new TopicPartition(partition.topicName(), partition.partitionIndex()));
                }
                Assertions.assertEquals(expectedPartitionStates.keySet(), partitions);
                Assertions.assertEquals((Object)deletePartitions, (Object)data.deletePartitions());
                continue;
            }
            if (version < 3) {
                partitions = new HashSet();
                for (StopReplicaRequestData.StopReplicaTopicV1 topic : data.topics()) {
                    for (Integer partition : topic.partitionIndexes()) {
                        partitions.add(new TopicPartition(topic.name(), partition.intValue()));
                    }
                }
                Assertions.assertEquals(expectedPartitionStates.keySet(), partitions);
                Assertions.assertEquals((Object)deletePartitions, (Object)data.deletePartitions());
                continue;
            }
            Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState> partitionStates = StopReplicaRequestTest.partitionStates(data.topicStates());
            Assertions.assertEquals(expectedPartitionStates, partitionStates);
            Assertions.assertFalse((boolean)data.deletePartitions());
        }
    }

    @Test
    public void testTopicStatesNormalization() {
        List<StopReplicaRequestData.StopReplicaTopicState> topicStates = this.topicStates(true);
        Iterator iterator = ApiKeys.STOP_REPLICA.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            StopReplicaRequest baseRequest = new StopReplicaRequest.Builder(version, 0, 1, 0L, true, topicStates).build(version);
            StopReplicaRequest request = StopReplicaRequest.parse((ByteBuffer)baseRequest.serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
            Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState> partitionStates = StopReplicaRequestTest.partitionStates(request.topicStates());
            Assertions.assertEquals((int)6, (int)partitionStates.size());
            for (StopReplicaRequestData.StopReplicaTopicState expectedTopicState : topicStates) {
                for (StopReplicaRequestData.StopReplicaPartitionState expectedPartitionState : expectedTopicState.partitionStates()) {
                    TopicPartition tp = new TopicPartition(expectedTopicState.topicName(), expectedPartitionState.partitionIndex());
                    StopReplicaRequestData.StopReplicaPartitionState partitionState = partitionStates.get(tp);
                    Assertions.assertEquals((int)expectedPartitionState.partitionIndex(), (int)partitionState.partitionIndex());
                    Assertions.assertTrue((boolean)partitionState.deletePartition());
                    if (version >= 3) {
                        Assertions.assertEquals((int)expectedPartitionState.leaderEpoch(), (int)partitionState.leaderEpoch());
                        continue;
                    }
                    Assertions.assertEquals((int)-1, (int)partitionState.leaderEpoch());
                }
            }
        }
    }

    @Test
    public void testPartitionStatesNormalization() {
        List<StopReplicaRequestData.StopReplicaTopicState> topicStates = this.topicStates(true);
        Iterator iterator = ApiKeys.STOP_REPLICA.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            StopReplicaRequest baseRequest = new StopReplicaRequest.Builder(version, 0, 1, 0L, true, topicStates).build(version);
            StopReplicaRequest request = StopReplicaRequest.parse((ByteBuffer)baseRequest.serialize(), (short)version, (MessageContext)MessageContext.IDENTITY);
            Map partitionStates = request.partitionStates();
            Assertions.assertEquals((int)6, (int)partitionStates.size());
            for (StopReplicaRequestData.StopReplicaTopicState expectedTopicState : topicStates) {
                for (StopReplicaRequestData.StopReplicaPartitionState expectedPartitionState : expectedTopicState.partitionStates()) {
                    TopicPartition tp = new TopicPartition(expectedTopicState.topicName(), expectedPartitionState.partitionIndex());
                    StopReplicaRequestData.StopReplicaPartitionState partitionState = (StopReplicaRequestData.StopReplicaPartitionState)partitionStates.get(tp);
                    Assertions.assertEquals((int)expectedPartitionState.partitionIndex(), (int)partitionState.partitionIndex());
                    Assertions.assertTrue((boolean)partitionState.deletePartition());
                    if (version >= 3) {
                        Assertions.assertEquals((int)expectedPartitionState.leaderEpoch(), (int)partitionState.leaderEpoch());
                        continue;
                    }
                    Assertions.assertEquals((int)-1, (int)partitionState.leaderEpoch());
                }
            }
        }
    }

    private List<StopReplicaRequestData.StopReplicaTopicState> topicStates(boolean deletePartition) {
        ArrayList<StopReplicaRequestData.StopReplicaTopicState> topicStates = new ArrayList<StopReplicaRequestData.StopReplicaTopicState>();
        StopReplicaRequestData.StopReplicaTopicState topic0 = new StopReplicaRequestData.StopReplicaTopicState().setTopicName("topic0");
        topic0.partitionStates().add(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(0).setLeaderEpoch(0).setDeletePartition(deletePartition));
        topic0.partitionStates().add(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(1).setLeaderEpoch(1).setDeletePartition(deletePartition));
        topicStates.add(topic0);
        StopReplicaRequestData.StopReplicaTopicState topic1 = new StopReplicaRequestData.StopReplicaTopicState().setTopicName("topic1");
        topic1.partitionStates().add(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(2).setLeaderEpoch(2).setDeletePartition(deletePartition));
        topic1.partitionStates().add(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(3).setLeaderEpoch(3).setDeletePartition(deletePartition));
        topicStates.add(topic1);
        StopReplicaRequestData.StopReplicaTopicState topic3 = new StopReplicaRequestData.StopReplicaTopicState().setTopicName("topic1");
        topic3.partitionStates().add(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(4).setLeaderEpoch(-2).setDeletePartition(deletePartition));
        topic3.partitionStates().add(new StopReplicaRequestData.StopReplicaPartitionState().setPartitionIndex(5).setLeaderEpoch(-2).setDeletePartition(deletePartition));
        topicStates.add(topic3);
        return topicStates;
    }

    public static Map<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState> partitionStates(Iterable<StopReplicaRequestData.StopReplicaTopicState> topicStates) {
        HashMap<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState> partitionStates = new HashMap<TopicPartition, StopReplicaRequestData.StopReplicaPartitionState>();
        for (StopReplicaRequestData.StopReplicaTopicState topicState : topicStates) {
            for (StopReplicaRequestData.StopReplicaPartitionState partitionState : topicState.partitionStates()) {
                partitionStates.put(new TopicPartition(topicState.topicName(), partitionState.partitionIndex()), partitionState);
            }
        }
        return partitionStates;
    }
}

