/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.serialization;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.IntegerDeserializer;
import org.apache.kafka.common.serialization.ListDeserializer;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ListDeserializerTest {
    private final ListDeserializer<?> listDeserializer = new ListDeserializer();
    private final Map<String, Object> props = new HashMap<String, Object>();
    private final String nonExistingClass = "non.existing.class";

    @Test
    public void testListKeyDeserializerNoArgConstructorsWithClassNames() {
        this.props.put("default.list.key.serde.type", ArrayList.class.getName());
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class.getName());
        this.listDeserializer.configure(this.props, true);
        Deserializer inner = this.listDeserializer.innerDeserializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner deserializer should be not null");
        Assertions.assertTrue((boolean)(inner instanceof StringDeserializer), (String)"Inner deserializer type should be StringDeserializer");
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsWithClassNames() {
        this.props.put("default.list.value.serde.type", ArrayList.class.getName());
        this.props.put("default.list.value.serde.inner", Serdes.IntegerSerde.class.getName());
        this.listDeserializer.configure(this.props, false);
        Deserializer inner = this.listDeserializer.innerDeserializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner deserializer should be not null");
        Assertions.assertTrue((boolean)(inner instanceof IntegerDeserializer), (String)"Inner deserializer type should be IntegerDeserializer");
    }

    @Test
    public void testListKeyDeserializerNoArgConstructorsWithClassObjects() {
        this.props.put("default.list.key.serde.type", ArrayList.class);
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class);
        this.listDeserializer.configure(this.props, true);
        Deserializer inner = this.listDeserializer.innerDeserializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner deserializer should be not null");
        Assertions.assertTrue((boolean)(inner instanceof StringDeserializer), (String)"Inner deserializer type should be StringDeserializer");
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsWithClassObjects() {
        this.props.put("default.list.value.serde.type", ArrayList.class);
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class);
        this.listDeserializer.configure(this.props, false);
        Deserializer inner = this.listDeserializer.innerDeserializer();
        Assertions.assertNotNull((Object)inner, (String)"Inner deserializer should be not null");
        Assertions.assertTrue((boolean)(inner instanceof StringDeserializer), (String)"Inner deserializer type should be StringDeserializer");
    }

    @Test
    public void testListKeyDeserializerNoArgConstructorsShouldThrowConfigExceptionDueMissingInnerClassProp() {
        this.props.put("default.list.key.serde.type", ArrayList.class);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Not able to determine the inner serde class because it was neither passed via the constructor nor set in the config.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsShouldThrowConfigExceptionDueMissingInnerClassProp() {
        this.props.put("default.list.value.serde.type", ArrayList.class);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Not able to determine the inner serde class because it was neither passed via the constructor nor set in the config.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeyDeserializerNoArgConstructorsShouldThrowConfigExceptionDueMissingTypeClassProp() {
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Not able to determine the list class because it was neither passed via the constructor nor set in the config.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsShouldThrowConfigExceptionDueMissingTypeClassProp() {
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Not able to determine the list class because it was neither passed via the constructor nor set in the config.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeyDeserializerNoArgConstructorsShouldThrowKafkaExceptionDueInvalidTypeClass() {
        this.props.put("default.list.key.serde.type", new FakeObject());
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class);
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Could not determine the list class instance using \"default.list.key.serde.type\" property.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsShouldThrowKafkaExceptionDueInvalidTypeClass() {
        this.props.put("default.list.value.serde.type", new FakeObject());
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class);
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listDeserializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Could not determine the list class instance using \"default.list.value.serde.type\" property.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeyDeserializerNoArgConstructorsShouldThrowKafkaExceptionDueInvalidInnerClass() {
        this.props.put("default.list.key.serde.type", ArrayList.class);
        this.props.put("default.list.key.serde.inner", new FakeObject());
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Could not determine the inner serde class instance using \"default.list.key.serde.inner\" property.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsShouldThrowKafkaExceptionDueInvalidInnerClass() {
        this.props.put("default.list.value.serde.type", ArrayList.class);
        this.props.put("default.list.value.serde.inner", new FakeObject());
        KafkaException exception = (KafkaException)Assertions.assertThrows(KafkaException.class, () -> this.listDeserializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Could not determine the inner serde class instance using \"default.list.value.serde.inner\" property.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeyDeserializerNoArgConstructorsShouldThrowConfigExceptionDueListClassNotFound() {
        this.props.put("default.list.key.serde.type", "non.existing.class");
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Invalid value non.existing.class for configuration default.list.key.serde.type: Deserializer's list class \"non.existing.class\" could not be found.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsShouldThrowConfigExceptionDueListClassNotFound() {
        this.props.put("default.list.value.serde.type", "non.existing.class");
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class);
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Invalid value non.existing.class for configuration default.list.value.serde.type: Deserializer's list class \"non.existing.class\" could not be found.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeyDeserializerNoArgConstructorsShouldThrowConfigExceptionDueInnerSerdeClassNotFound() {
        this.props.put("default.list.key.serde.type", ArrayList.class);
        this.props.put("default.list.key.serde.inner", "non.existing.class");
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"Invalid value non.existing.class for configuration default.list.key.serde.inner: Deserializer's inner serde class \"non.existing.class\" could not be found.", (Object)exception.getMessage());
    }

    @Test
    public void testListValueDeserializerNoArgConstructorsShouldThrowConfigExceptionDueInnerSerdeClassNotFound() {
        this.props.put("default.list.value.serde.type", ArrayList.class);
        this.props.put("default.list.value.serde.inner", "non.existing.class");
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> this.listDeserializer.configure(this.props, false));
        Assertions.assertEquals((Object)"Invalid value non.existing.class for configuration default.list.value.serde.inner: Deserializer's inner serde class \"non.existing.class\" could not be found.", (Object)exception.getMessage());
    }

    @Test
    public void testListKeyDeserializerShouldThrowConfigExceptionDueAlreadyInitialized() {
        this.props.put("default.list.key.serde.type", ArrayList.class);
        this.props.put("default.list.key.serde.inner", Serdes.StringSerde.class);
        ListDeserializer initializedListDeserializer = new ListDeserializer(ArrayList.class, Serdes.Integer().deserializer());
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> initializedListDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"List deserializer was already initialized using a non-default constructor", (Object)exception.getMessage());
    }

    @Test
    public void testListValueDeserializerShouldThrowConfigExceptionDueAlreadyInitialized() {
        this.props.put("default.list.value.serde.type", ArrayList.class);
        this.props.put("default.list.value.serde.inner", Serdes.StringSerde.class);
        ListDeserializer initializedListDeserializer = new ListDeserializer(ArrayList.class, Serdes.Integer().deserializer());
        ConfigException exception = (ConfigException)Assertions.assertThrows(ConfigException.class, () -> initializedListDeserializer.configure(this.props, true));
        Assertions.assertEquals((Object)"List deserializer was already initialized using a non-default constructor", (Object)exception.getMessage());
    }

    private static class FakeObject {
        private FakeObject() {
        }
    }
}

