/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.kafka.common.utils.LogContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.event.Level;
import org.slf4j.helpers.BasicMarkerFactory;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class LogContextTest {
    private static final Marker NO_MARKER = null;
    private final AtomicReference<Level> maxLogLevel = new AtomicReference();
    private final LogContext logContext = new LogContext("[Test] ", this.maxLogLevel);
    private final RuntimeException exception = new RuntimeException("test");
    private TestLogger baseLogger;
    private Logger logger;

    @Test
    public void testLocationIgnorantWithoutMaxLogLevel() throws Exception {
        this.baseLogger = new TestLogger();
        this.logger = this.logContext.loggerWithLogLevelOverride((Logger)this.baseLogger);
        this.verifyLogs();
    }

    @Test
    public void testLocationAwareWithoutMaxLogLevel() throws Exception {
        this.baseLogger = new LocationAwareTestLogger();
        this.logger = this.logContext.loggerWithLogLevelOverride((Logger)this.baseLogger);
        this.verifyLogs();
    }

    @Test
    public void testLocationIgnorantWithMaxLogLevel() throws Exception {
        this.baseLogger = new TestLogger();
        this.logger = this.logContext.loggerWithLogLevelOverride((Logger)this.baseLogger);
        this.maxLogLevel.set(Level.DEBUG);
        this.verifyLogs();
        this.baseLogger.enabledLevel = Level.INFO;
        this.verifyLogs();
        this.maxLogLevel.set(Level.ERROR);
        this.verifyLogs();
        this.baseLogger.enabledLevel = Level.TRACE;
        this.verifyLogs();
    }

    @Test
    public void testLocationAwareWithMaxLogLevel() throws Exception {
        this.baseLogger = new LocationAwareTestLogger();
        this.logger = this.logContext.loggerWithLogLevelOverride((Logger)this.baseLogger);
        this.maxLogLevel.set(Level.DEBUG);
        this.verifyLogs();
        this.baseLogger.enabledLevel = Level.INFO;
        this.verifyLogs();
        this.maxLogLevel.set(Level.ERROR);
        this.verifyLogs();
        this.baseLogger.enabledLevel = Level.TRACE;
        this.verifyLogs();
    }

    private void verifyLogs() throws Exception {
        for (Level level : Level.values()) {
            this.verifyLog(NO_MARKER, this.expectedLevel(level), level.name().toLowerCase(Locale.ROOT));
        }
        Marker marker = new BasicMarkerFactory().getMarker("test");
        for (Level level : Level.values()) {
            this.verifyLog(marker, this.expectedLevel(level), level.name().toLowerCase(Locale.ROOT));
        }
    }

    private Level expectedLevel(Level logLevel) {
        Level maxLevel = this.maxLogLevel.get();
        if (this.baseLogger.enabledLevel == null || this.baseLogger.enabledLevel.toInt() > logLevel.toInt()) {
            return null;
        }
        if (maxLevel != null && logLevel.toInt() > maxLevel.toInt()) {
            return maxLevel;
        }
        return logLevel;
    }

    private void verifyLog(Marker marker, Level expectedLevel, String methodName) throws Exception {
        Class<?> loggerClass = this.logger.getClass();
        LogEntry expectedEntry = new LogEntry(expectedLevel, marker, "[Test] test");
        if (marker == NO_MARKER) {
            loggerClass.getMethod(methodName, String.class).invoke((Object)this.logger, "test");
        } else {
            loggerClass.getMethod(methodName, Marker.class, String.class).invoke((Object)this.logger, marker, "test");
        }
        this.verifyLogEntry(expectedLevel, expectedEntry);
        expectedEntry = new LogEntry(expectedLevel, marker, "[Test] test {}", (Object)"arg");
        if (marker == NO_MARKER) {
            loggerClass.getMethod(methodName, String.class, Object.class).invoke((Object)this.logger, "test {}", "arg");
        } else {
            loggerClass.getMethod(methodName, Marker.class, String.class, Object.class).invoke((Object)this.logger, marker, "test {}", "arg");
        }
        this.verifyLogEntry(expectedLevel, expectedEntry);
        expectedEntry = new LogEntry(expectedLevel, marker, "[Test] test {} {}", (Object)"arg1", (Object)"arg2");
        if (marker == NO_MARKER) {
            loggerClass.getMethod(methodName, String.class, Object.class, Object.class).invoke((Object)this.logger, "test {} {}", "arg1", "arg2");
        } else {
            loggerClass.getMethod(methodName, Marker.class, String.class, Object.class, Object.class).invoke((Object)this.logger, marker, "test {} {}", "arg1", "arg2");
        }
        this.verifyLogEntry(expectedLevel, expectedEntry);
        expectedEntry = new LogEntry(expectedLevel, marker, "[Test] test {}, {} {}", 1, 2, 3);
        if (marker == NO_MARKER) {
            loggerClass.getMethod(methodName, String.class, Object[].class).invoke((Object)this.logger, "test {}, {} {}", new Object[]{1, 2, 3});
        } else {
            loggerClass.getMethod(methodName, Marker.class, String.class, Object[].class).invoke((Object)this.logger, marker, "test {}, {} {}", new Object[]{1, 2, 3});
        }
        this.verifyLogEntry(expectedLevel, expectedEntry);
        expectedEntry = new LogEntry(expectedLevel, marker, "[Test] test", this.exception);
        if (marker == NO_MARKER) {
            loggerClass.getMethod(methodName, String.class, Throwable.class).invoke((Object)this.logger, "test", this.exception);
        } else {
            loggerClass.getMethod(methodName, Marker.class, String.class, Throwable.class).invoke((Object)this.logger, marker, "test", this.exception);
        }
        this.verifyLogEntry(expectedLevel, expectedEntry);
    }

    private void verifyLogEntry(Level expectedLevel, LogEntry entry) {
        if (expectedLevel != null) {
            Assertions.assertEquals(Collections.singletonList(entry), this.baseLogger.logs);
        } else {
            Assertions.assertEquals(Collections.emptyList(), this.baseLogger.logs);
        }
        this.baseLogger.logs.clear();
    }

    private static class LocationAwareTestLogger
    extends TestLogger
    implements LocationAwareLogger {
        private LocationAwareTestLogger() {
        }

        public void log(Marker marker, String fqcn, int level, String message, Object[] argArray, Throwable t) {
            Level logLevel = Stream.of(Level.values()).filter(l -> l.toInt() == level).findFirst().orElse(Level.ERROR);
            this.logs.add(new LogEntry(logLevel, marker, new FormattingTuple(message, argArray, t)));
        }
    }

    private static class TestLogger
    implements Logger {
        final List<LogEntry> logs = new ArrayList<LogEntry>();
        Level enabledLevel = Level.TRACE;

        private TestLogger() {
        }

        public String getName() {
            return "test";
        }

        public boolean isTraceEnabled() {
            return this.enabledLevel.toInt() <= Level.TRACE.toInt();
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.enabledLevel.toInt() <= Level.TRACE.toInt();
        }

        public boolean isDebugEnabled() {
            return this.enabledLevel.toInt() <= Level.DEBUG.toInt();
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.enabledLevel.toInt() <= Level.DEBUG.toInt();
        }

        public boolean isInfoEnabled() {
            return this.enabledLevel.toInt() <= Level.INFO.toInt();
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.enabledLevel.toInt() <= Level.INFO.toInt();
        }

        public boolean isWarnEnabled() {
            return this.enabledLevel.toInt() <= Level.WARN.toInt();
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.enabledLevel.toInt() <= Level.WARN.toInt();
        }

        public boolean isErrorEnabled() {
            return this.enabledLevel.toInt() <= Level.ERROR.toInt();
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.enabledLevel.toInt() <= Level.ERROR.toInt();
        }

        public void trace(String msg) {
            this.logs.add(new LogEntry(Level.TRACE, NO_MARKER, msg));
        }

        public void trace(String format, Object arg) {
            this.logs.add(new LogEntry(Level.TRACE, NO_MARKER, format, arg));
        }

        public void trace(String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.TRACE, NO_MARKER, format, arg1, arg2));
        }

        public void trace(String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.TRACE, NO_MARKER, format, arguments));
        }

        public void trace(String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.TRACE, NO_MARKER, msg, t));
        }

        public void debug(String msg) {
            this.logs.add(new LogEntry(Level.DEBUG, NO_MARKER, msg));
        }

        public void debug(String format, Object arg) {
            this.logs.add(new LogEntry(Level.DEBUG, NO_MARKER, format, arg));
        }

        public void debug(String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.DEBUG, NO_MARKER, format, arg1, arg2));
        }

        public void debug(String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.DEBUG, NO_MARKER, format, arguments));
        }

        public void debug(String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.DEBUG, NO_MARKER, msg, t));
        }

        public void info(String msg) {
            this.logs.add(new LogEntry(Level.INFO, NO_MARKER, msg));
        }

        public void info(String format, Object arg) {
            this.logs.add(new LogEntry(Level.INFO, NO_MARKER, format, arg));
        }

        public void info(String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.INFO, NO_MARKER, format, arg1, arg2));
        }

        public void info(String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.INFO, NO_MARKER, format, arguments));
        }

        public void info(String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.INFO, NO_MARKER, msg, t));
        }

        public void warn(String msg) {
            this.logs.add(new LogEntry(Level.WARN, NO_MARKER, msg));
        }

        public void warn(String format, Object arg) {
            this.logs.add(new LogEntry(Level.WARN, NO_MARKER, format, arg));
        }

        public void warn(String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.WARN, NO_MARKER, format, arg1, arg2));
        }

        public void warn(String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.WARN, NO_MARKER, format, arguments));
        }

        public void warn(String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.WARN, NO_MARKER, msg, t));
        }

        public void error(String msg) {
            this.logs.add(new LogEntry(Level.ERROR, NO_MARKER, msg));
        }

        public void error(String format, Object arg) {
            this.logs.add(new LogEntry(Level.ERROR, NO_MARKER, format, arg));
        }

        public void error(String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.ERROR, NO_MARKER, format, arg1, arg2));
        }

        public void error(String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.ERROR, NO_MARKER, format, arguments));
        }

        public void error(String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.ERROR, NO_MARKER, msg, t));
        }

        public void trace(Marker marker, String msg) {
            this.logs.add(new LogEntry(Level.TRACE, marker, msg));
        }

        public void trace(Marker marker, String format, Object arg) {
            this.logs.add(new LogEntry(Level.TRACE, marker, format, arg));
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.TRACE, marker, format, arg1, arg2));
        }

        public void trace(Marker marker, String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.TRACE, marker, format, arguments));
        }

        public void trace(Marker marker, String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.TRACE, marker, msg, t));
        }

        public void debug(Marker marker, String msg) {
            this.logs.add(new LogEntry(Level.DEBUG, marker, msg));
        }

        public void debug(Marker marker, String format, Object arg) {
            this.logs.add(new LogEntry(Level.DEBUG, marker, format, arg));
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.DEBUG, marker, format, arg1, arg2));
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.DEBUG, marker, format, arguments));
        }

        public void debug(Marker marker, String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.DEBUG, marker, msg, t));
        }

        public void info(Marker marker, String msg) {
            this.logs.add(new LogEntry(Level.INFO, marker, msg));
        }

        public void info(Marker marker, String format, Object arg) {
            this.logs.add(new LogEntry(Level.INFO, marker, format, arg));
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.INFO, marker, format, arg1, arg2));
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.INFO, marker, format, arguments));
        }

        public void info(Marker marker, String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.INFO, marker, msg, t));
        }

        public void warn(Marker marker, String msg) {
            this.logs.add(new LogEntry(Level.WARN, marker, msg));
        }

        public void warn(Marker marker, String format, Object arg) {
            this.logs.add(new LogEntry(Level.WARN, marker, format, arg));
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.WARN, marker, format, arg1, arg2));
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.WARN, marker, format, arguments));
        }

        public void warn(Marker marker, String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.WARN, marker, msg, t));
        }

        public void error(Marker marker, String msg) {
            this.logs.add(new LogEntry(Level.ERROR, marker, msg));
        }

        public void error(Marker marker, String format, Object arg) {
            this.logs.add(new LogEntry(Level.ERROR, marker, format, arg));
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.logs.add(new LogEntry(Level.ERROR, marker, format, arg1, arg2));
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.logs.add(new LogEntry(Level.ERROR, marker, format, arguments));
        }

        public void error(Marker marker, String msg, Throwable t) {
            this.logs.add(new LogEntry(Level.ERROR, marker, msg, t));
        }
    }

    private static class LogEntry {
        private final Level level;
        private final Marker marker;
        private final FormattingTuple tuple;

        LogEntry(Level level, Marker marker, FormattingTuple tuple) {
            this.level = level;
            this.marker = marker;
            this.tuple = tuple;
        }

        LogEntry(Level level, Marker marker, String message) {
            this(level, marker, new FormattingTuple(message));
        }

        LogEntry(Level level, Marker marker, String format, Object arg) {
            this(level, marker, MessageFormatter.format((String)format, (Object)arg));
        }

        LogEntry(Level level, Marker marker, String format, Object arg1, Object arg2) {
            this(level, marker, MessageFormatter.format((String)format, (Object)arg1, (Object)arg2));
        }

        LogEntry(Level level, Marker marker, String format, Object ... args) {
            this(level, marker, MessageFormatter.arrayFormat((String)format, (Object[])args));
        }

        LogEntry(Level level, Marker marker, String message, Throwable exception) {
            this(level, marker, MessageFormatter.format((String)message, (Object)exception));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LogEntry)) {
                return false;
            }
            LogEntry logEntry = (LogEntry)o;
            return this.level == logEntry.level && Objects.equals(this.marker, logEntry.marker) && Objects.equals(this.tuple.getMessage(), logEntry.tuple.getMessage()) && Objects.equals(this.tuple.getThrowable(), logEntry.tuple.getThrowable());
        }

        public int hashCode() {
            return Objects.hash(this.level, this.marker, this.tuple);
        }

        public String toString() {
            return "LogEntry{level=" + this.level + ", marker=" + this.marker + ", message='" + this.tuple.getMessage() + '\'' + ", args=" + Arrays.toString(this.tuple.getArgArray()) + ", exception=" + this.tuple.getThrowable() + '}';
        }
    }
}

