/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.utils;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.function.Executable;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.verification.VerificationMode;

public class UtilsTest {
    @Test
    public void testMurmur2() {
        HashMap<byte[], Integer> cases = new HashMap<byte[], Integer>();
        cases.put("21".getBytes(), -973932308);
        cases.put("foobar".getBytes(), -790332482);
        cases.put("a-little-bit-long-string".getBytes(), -985981536);
        cases.put("a-little-bit-longer-string".getBytes(), -1486304829);
        cases.put("lkjh234lh9fiuh90y23oiuhsafujhadof229phr9h19h89h8".getBytes(), -58897971);
        cases.put(new byte[]{97, 98, 99}, 479470107);
        for (Map.Entry c : cases.entrySet()) {
            Assertions.assertEquals((int)((Integer)c.getValue()), (int)Utils.murmur2((byte[])((byte[])c.getKey())));
        }
    }

    @Test
    public void testGetHost() {
        Assertions.assertEquals((Object)"127.0.0.1", (Object)Utils.getHost((String)"127.0.0.1:8000"));
        Assertions.assertEquals((Object)"mydomain.com", (Object)Utils.getHost((String)"PLAINTEXT://mydomain.com:8080"));
        Assertions.assertEquals((Object)"MyDomain.com", (Object)Utils.getHost((String)"PLAINTEXT://MyDomain.com:8080"));
        Assertions.assertEquals((Object)"My_Domain.com", (Object)Utils.getHost((String)"PLAINTEXT://My_Domain.com:8080"));
        Assertions.assertEquals((Object)"::1", (Object)Utils.getHost((String)"[::1]:1234"));
        Assertions.assertEquals((Object)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Object)Utils.getHost((String)"PLAINTEXT://[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678"));
        Assertions.assertEquals((Object)"2001:DB8:85A3:8D3:1319:8A2E:370:7348", (Object)Utils.getHost((String)"PLAINTEXT://[2001:DB8:85A3:8D3:1319:8A2E:370:7348]:5678"));
        Assertions.assertEquals((Object)"fe80::b1da:69ca:57f7:63d8%3", (Object)Utils.getHost((String)"PLAINTEXT://[fe80::b1da:69ca:57f7:63d8%3]:5678"));
    }

    @Test
    public void testHostPattern() {
        Assertions.assertTrue((boolean)Utils.validHostPattern((String)"127.0.0.1"));
        Assertions.assertTrue((boolean)Utils.validHostPattern((String)"mydomain.com"));
        Assertions.assertTrue((boolean)Utils.validHostPattern((String)"MyDomain.com"));
        Assertions.assertTrue((boolean)Utils.validHostPattern((String)"My_Domain.com"));
        Assertions.assertTrue((boolean)Utils.validHostPattern((String)"::1"));
        Assertions.assertTrue((boolean)Utils.validHostPattern((String)"2001:db8:85a3:8d3:1319:8a2e:370"));
    }

    @Test
    public void testGetPort() {
        Assertions.assertEquals((int)8000, (int)Utils.getPort((String)"127.0.0.1:8000"));
        Assertions.assertEquals((int)8080, (int)Utils.getPort((String)"mydomain.com:8080"));
        Assertions.assertEquals((int)8080, (int)Utils.getPort((String)"MyDomain.com:8080"));
        Assertions.assertEquals((int)1234, (int)Utils.getPort((String)"[::1]:1234"));
        Assertions.assertEquals((int)5678, (int)Utils.getPort((String)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678"));
        Assertions.assertEquals((int)5678, (int)Utils.getPort((String)"[2001:DB8:85A3:8D3:1319:8A2E:370:7348]:5678"));
        Assertions.assertEquals((int)5678, (int)Utils.getPort((String)"[fe80::b1da:69ca:57f7:63d8%3]:5678"));
    }

    @Test
    public void testFormatAddress() {
        Assertions.assertEquals((Object)"127.0.0.1:8000", (Object)Utils.formatAddress((String)"127.0.0.1", (Integer)8000));
        Assertions.assertEquals((Object)"mydomain.com:8080", (Object)Utils.formatAddress((String)"mydomain.com", (Integer)8080));
        Assertions.assertEquals((Object)"[::1]:1234", (Object)Utils.formatAddress((String)"::1", (Integer)1234));
        Assertions.assertEquals((Object)"[2001:db8:85a3:8d3:1319:8a2e:370:7348]:5678", (Object)Utils.formatAddress((String)"2001:db8:85a3:8d3:1319:8a2e:370:7348", (Integer)5678));
    }

    @Test
    public void testFormatBytes() {
        Assertions.assertEquals((Object)"-1", (Object)Utils.formatBytes((long)-1L));
        Assertions.assertEquals((Object)"1023 B", (Object)Utils.formatBytes((long)1023L));
        Assertions.assertEquals((Object)"1 KB", (Object)Utils.formatBytes((long)1024L));
        Assertions.assertEquals((Object)"1024 KB", (Object)Utils.formatBytes((long)1048575L));
        Assertions.assertEquals((Object)"1 MB", (Object)Utils.formatBytes((long)0x100000L));
        Assertions.assertEquals((Object)"1.1 MB", (Object)Utils.formatBytes((long)0x119999L));
        Assertions.assertEquals((Object)"10 MB", (Object)Utils.formatBytes((long)0xA00000L));
    }

    @Test
    public void testJoin() {
        Assertions.assertEquals((Object)"", (Object)Utils.join(Collections.emptyList(), (String)","));
        Assertions.assertEquals((Object)"1", (Object)Utils.join(Arrays.asList("1"), (String)","));
        Assertions.assertEquals((Object)"1,2,3", (Object)Utils.join(Arrays.asList(1, 2, 3), (String)","));
    }

    @Test
    public void testAbs() {
        Assertions.assertEquals((int)0, (int)Utils.abs((int)Integer.MIN_VALUE));
        Assertions.assertEquals((int)10, (int)Utils.abs((int)-10));
        Assertions.assertEquals((int)10, (int)Utils.abs((int)10));
        Assertions.assertEquals((int)0, (int)Utils.abs((int)0));
        Assertions.assertEquals((int)1, (int)Utils.abs((int)-1));
    }

    @Test
    public void writeToBuffer() throws IOException {
        byte[] input = new byte[]{0, 1, 2, 3, 4, 5};
        ByteBuffer source = ByteBuffer.wrap(input);
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocate(input.length));
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocateDirect(input.length));
        Assertions.assertEquals((int)0, (int)source.position());
        source.position(2);
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocate(input.length));
        this.doTestWriteToByteBuffer(source, ByteBuffer.allocateDirect(input.length));
    }

    private void doTestWriteToByteBuffer(ByteBuffer source, ByteBuffer dest) throws IOException {
        int numBytes = source.remaining();
        int position = source.position();
        DataOutputStream out = new DataOutputStream((OutputStream)new ByteBufferOutputStream(dest));
        Utils.writeTo((DataOutput)out, (ByteBuffer)source, (int)source.remaining());
        dest.flip();
        Assertions.assertEquals((int)numBytes, (int)dest.remaining());
        Assertions.assertEquals((int)position, (int)source.position());
        Assertions.assertEquals((Object)source, (Object)dest);
    }

    @Test
    public void toArray() {
        byte[] input = new byte[]{0, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        Assertions.assertArrayEquals((byte[])input, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assertions.assertEquals((int)0, (int)buffer.position());
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])Utils.toArray((ByteBuffer)buffer, (int)1, (int)2));
        Assertions.assertEquals((int)0, (int)buffer.position());
        buffer.position(2);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assertions.assertEquals((int)2, (int)buffer.position());
    }

    @Test
    public void toArrayDirectByteBuffer() {
        byte[] input = new byte[]{0, 1, 2, 3, 4};
        ByteBuffer buffer = ByteBuffer.allocateDirect(5);
        buffer.put(input);
        buffer.rewind();
        Assertions.assertArrayEquals((byte[])input, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assertions.assertEquals((int)0, (int)buffer.position());
        Assertions.assertArrayEquals((byte[])new byte[]{1, 2}, (byte[])Utils.toArray((ByteBuffer)buffer, (int)1, (int)2));
        Assertions.assertEquals((int)0, (int)buffer.position());
        buffer.position(2);
        Assertions.assertArrayEquals((byte[])new byte[]{2, 3, 4}, (byte[])Utils.toArray((ByteBuffer)buffer));
        Assertions.assertEquals((int)2, (int)buffer.position());
    }

    @Test
    public void getNullableSizePrefixedArrayExact() {
        byte[] input = new byte[]{0, 0, 0, 2, 1, 0};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        byte[] array = Utils.getNullableSizePrefixedArray((ByteBuffer)buffer);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 0}, (byte[])array);
        Assertions.assertEquals((int)6, (int)buffer.position());
        Assertions.assertFalse((boolean)buffer.hasRemaining());
    }

    @Test
    public void getNullableSizePrefixedArrayExactEmpty() {
        byte[] input = new byte[]{0, 0, 0, 0};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        byte[] array = Utils.getNullableSizePrefixedArray((ByteBuffer)buffer);
        Assertions.assertArrayEquals((byte[])new byte[0], (byte[])array);
        Assertions.assertEquals((int)4, (int)buffer.position());
        Assertions.assertFalse((boolean)buffer.hasRemaining());
    }

    @Test
    public void getNullableSizePrefixedArrayRemainder() {
        byte[] input = new byte[]{0, 0, 0, 2, 1, 0, 9};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        byte[] array = Utils.getNullableSizePrefixedArray((ByteBuffer)buffer);
        Assertions.assertArrayEquals((byte[])new byte[]{1, 0}, (byte[])array);
        Assertions.assertEquals((int)6, (int)buffer.position());
        Assertions.assertTrue((boolean)buffer.hasRemaining());
    }

    @Test
    public void getNullableSizePrefixedArrayNull() {
        byte[] input = new byte[]{-1, -1, -1, -1};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        byte[] array = Utils.getNullableSizePrefixedArray((ByteBuffer)buffer);
        Assertions.assertNull((Object)array);
        Assertions.assertEquals((int)4, (int)buffer.position());
        Assertions.assertFalse((boolean)buffer.hasRemaining());
    }

    @Test
    public void getNullableSizePrefixedArrayInvalid() {
        byte[] input = new byte[]{-1, -1, -1, -2};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        Assertions.assertThrows(NegativeArraySizeException.class, () -> Utils.getNullableSizePrefixedArray((ByteBuffer)buffer));
    }

    @Test
    public void getNullableSizePrefixedArrayUnderflow() {
        byte[] input = new byte[]{127, -1, -1, -1};
        ByteBuffer buffer = ByteBuffer.wrap(input);
        Assertions.assertThrows(BufferUnderflowException.class, () -> Utils.getNullableSizePrefixedArray((ByteBuffer)buffer));
    }

    @Test
    public void utf8ByteArraySerde() {
        String utf8String = "A\u00ea\u00f1\u00fcC";
        byte[] utf8Bytes = utf8String.getBytes(StandardCharsets.UTF_8);
        Assertions.assertArrayEquals((byte[])utf8Bytes, (byte[])Utils.utf8((String)utf8String));
        Assertions.assertEquals((int)utf8Bytes.length, (int)Utils.utf8Length((CharSequence)utf8String));
        Assertions.assertEquals((Object)utf8String, (Object)Utils.utf8((byte[])utf8Bytes));
    }

    @Test
    public void utf8ByteBufferSerde() {
        this.doTestUtf8ByteBuffer(ByteBuffer.allocate(20));
        this.doTestUtf8ByteBuffer(ByteBuffer.allocateDirect(20));
    }

    private void doTestUtf8ByteBuffer(ByteBuffer utf8Buffer) {
        String utf8String = "A\u00ea\u00f1\u00fcC";
        byte[] utf8Bytes = utf8String.getBytes(StandardCharsets.UTF_8);
        utf8Buffer.position(4);
        utf8Buffer.put(utf8Bytes);
        utf8Buffer.position(4);
        Assertions.assertEquals((Object)utf8String, (Object)Utils.utf8((ByteBuffer)utf8Buffer, (int)utf8Bytes.length));
        Assertions.assertEquals((int)4, (int)utf8Buffer.position());
        utf8Buffer.position(0);
        Assertions.assertEquals((Object)utf8String, (Object)Utils.utf8((ByteBuffer)utf8Buffer, (int)4, (int)utf8Bytes.length));
        Assertions.assertEquals((int)0, (int)utf8Buffer.position());
    }

    private void subTest(ByteBuffer buffer) {
        Assertions.assertEquals((int)65, (int)Utils.readBytes((ByteBuffer)buffer, (int)0, (int)1)[0]);
        byte[] results = Utils.readBytes((ByteBuffer)buffer, (int)2, (int)3);
        Assertions.assertEquals((int)121, (int)results[0]);
        Assertions.assertEquals((int)32, (int)results[1]);
        Assertions.assertEquals((int)83, (int)results[2]);
        Assertions.assertEquals((int)3, (int)results.length);
        results = Utils.readBytes((ByteBuffer)buffer);
        Assertions.assertEquals((int)65, (int)results[0]);
        Assertions.assertEquals((int)116, (int)results[buffer.limit() - 1]);
        Assertions.assertEquals((int)buffer.limit(), (int)results.length);
    }

    @Test
    public void testReadBytes() {
        byte[] myvar = "Any String you want".getBytes();
        ByteBuffer buffer = ByteBuffer.allocate(myvar.length);
        buffer.put(myvar);
        buffer.rewind();
        this.subTest(buffer);
        buffer = ByteBuffer.wrap(myvar).asReadOnlyBuffer();
        this.subTest(buffer);
    }

    @Test
    public void testFileAsStringSimpleFile() throws IOException {
        File tempFile = TestUtils.tempFile();
        try {
            String testContent = "Test Content";
            Files.write(tempFile.toPath(), testContent.getBytes(), new OpenOption[0]);
            Assertions.assertEquals((Object)testContent, (Object)Utils.readFileAsString((String)tempFile.getPath()));
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Timeout(value=60L)
    @Test
    public void testFileAsStringNamedPipe() throws Exception {
        Random random = new Random();
        long n = random.nextLong();
        n = n == Long.MIN_VALUE ? 0L : Math.abs(n);
        String tmpDir = System.getProperty("java.io.tmpdir");
        String fifoName = "fifo-" + n + ".tmp";
        File fifo = new File(tmpDir, fifoName);
        Thread producerThread = null;
        try {
            Process mkFifoCommand = new ProcessBuilder("mkfifo", fifo.getCanonicalPath()).start();
            mkFifoCommand.waitFor();
            String testFileContent = "This is test";
            producerThread = new Thread(() -> {
                try {
                    Files.write(fifo.toPath(), "This is test".getBytes(), new OpenOption[0]);
                }
                catch (IOException e) {
                    Assertions.fail((String)("Error when producing to fifo : " + e.getMessage()));
                }
            }, "FIFO-Producer");
            producerThread.start();
            Assertions.assertEquals((Object)"This is test", (Object)Utils.readFileAsString((String)fifo.getCanonicalPath()));
        }
        finally {
            Files.deleteIfExists(fifo.toPath());
            if (producerThread != null) {
                producerThread.join(30000L);
                Assertions.assertFalse((boolean)producerThread.isAlive());
            }
        }
    }

    @Test
    public void testMin() {
        Assertions.assertEquals((long)1L, (long)Utils.min((long)1L, (long[])new long[0]));
        Assertions.assertEquals((long)1L, (long)Utils.min((long)1L, (long[])new long[]{2L, 3L}));
        Assertions.assertEquals((long)1L, (long)Utils.min((long)2L, (long[])new long[]{1L, 3L}));
        Assertions.assertEquals((long)1L, (long)Utils.min((long)2L, (long[])new long[]{3L, 1L}));
    }

    @Test
    public void testCloseAll() {
        Closeable[] closeablesWithoutException = TestCloseable.createCloseables(false, false, false);
        try {
            Utils.closeAll((Closeable[])closeablesWithoutException);
            TestCloseable.checkClosed((TestCloseable[])closeablesWithoutException);
        }
        catch (IOException e) {
            Assertions.fail((String)("Unexpected exception: " + e));
        }
        Closeable[] closeablesWithException = TestCloseable.createCloseables(true, true, true);
        try {
            Utils.closeAll((Closeable[])closeablesWithException);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (IOException e) {
            TestCloseable.checkClosed((TestCloseable[])closeablesWithException);
            TestCloseable.checkException(e, (TestCloseable[])closeablesWithException);
        }
        Closeable[] singleExceptionCloseables = TestCloseable.createCloseables(false, true, false);
        try {
            Utils.closeAll((Closeable[])singleExceptionCloseables);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (IOException e) {
            TestCloseable.checkClosed((TestCloseable[])singleExceptionCloseables);
            TestCloseable.checkException(e, new TestCloseable[]{singleExceptionCloseables[1]});
        }
        Closeable[] mixedCloseables = TestCloseable.createCloseables(false, true, false, true, true);
        try {
            Utils.closeAll((Closeable[])mixedCloseables);
            Assertions.fail((String)"Expected exception not thrown");
        }
        catch (IOException e) {
            TestCloseable.checkClosed((TestCloseable[])mixedCloseables);
            TestCloseable.checkException(e, new TestCloseable[]{mixedCloseables[1], mixedCloseables[3], mixedCloseables[4]});
        }
    }

    @Test
    public void testReadFullyOrFailWithRealFile() throws IOException {
        try (FileChannel channel = FileChannel.open(TestUtils.tempFile().toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
            String msg = "hello, world";
            channel.write(ByteBuffer.wrap(msg.getBytes()), 0L);
            channel.force(true);
            Assertions.assertEquals((long)channel.size(), (long)msg.length(), (String)"Message should be written to the file channel");
            ByteBuffer perfectBuffer = ByteBuffer.allocate(msg.length());
            ByteBuffer smallBuffer = ByteBuffer.allocate(5);
            ByteBuffer largeBuffer = ByteBuffer.allocate(msg.length() + 1);
            Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)perfectBuffer, (long)0L, (String)"perfect");
            Assertions.assertFalse((boolean)perfectBuffer.hasRemaining(), (String)"Buffer should be filled up");
            Assertions.assertEquals((Object)msg, (Object)new String(perfectBuffer.array()), (String)"Buffer should be populated correctly");
            Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)smallBuffer, (long)0L, (String)"small");
            Assertions.assertFalse((boolean)smallBuffer.hasRemaining(), (String)"Buffer should be filled");
            Assertions.assertEquals((Object)"hello", (Object)new String(smallBuffer.array()), (String)"Buffer should be populated correctly");
            smallBuffer.clear();
            Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)smallBuffer, (long)7L, (String)"small");
            Assertions.assertFalse((boolean)smallBuffer.hasRemaining(), (String)"Buffer should be filled");
            Assertions.assertEquals((Object)"world", (Object)new String(smallBuffer.array()), (String)"Buffer should be populated correctly");
            try {
                Utils.readFullyOrFail((FileChannel)channel, (ByteBuffer)largeBuffer, (long)0L, (String)"large");
                Assertions.fail((String)"Expected EOFException to be raised");
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testReadFullyOrFailWithPartialFileChannelReads() throws IOException {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        int bufferSize = 100;
        ByteBuffer buffer = ByteBuffer.allocate(100);
        String expectedBufferContent = this.fileChannelMockExpectReadWithRandomBytes(channelMock, 100);
        Utils.readFullyOrFail((FileChannel)channelMock, (ByteBuffer)buffer, (long)0L, (String)"test");
        Assertions.assertEquals((Object)expectedBufferContent, (Object)new String(buffer.array()), (String)"The buffer should be populated correctly");
        Assertions.assertFalse((boolean)buffer.hasRemaining(), (String)"The buffer should be filled");
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testReadFullyWithPartialFileChannelReads() throws IOException {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        int bufferSize = 100;
        String expectedBufferContent = this.fileChannelMockExpectReadWithRandomBytes(channelMock, 100);
        ByteBuffer buffer = ByteBuffer.allocate(100);
        Utils.readFully((FileChannel)channelMock, (ByteBuffer)buffer, (long)0L);
        Assertions.assertEquals((Object)expectedBufferContent, (Object)new String(buffer.array()), (String)"The buffer should be populated correctly.");
        Assertions.assertFalse((boolean)buffer.hasRemaining(), (String)"The buffer should be filled");
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
    }

    @Test
    public void testReadFullyIfEofIsReached() throws IOException {
        FileChannel channelMock = (FileChannel)Mockito.mock(FileChannel.class);
        int bufferSize = 100;
        String fileChannelContent = "abcdefghkl";
        ByteBuffer buffer = ByteBuffer.allocate(100);
        Mockito.when((Object)channelMock.read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong())).then(invocation -> {
            ByteBuffer bufferArg = (ByteBuffer)invocation.getArgument(0);
            bufferArg.put("abcdefghkl".getBytes());
            return -1;
        });
        Utils.readFully((FileChannel)channelMock, (ByteBuffer)buffer, (long)0L);
        Assertions.assertEquals((Object)"abcdefghkl", (Object)new String(buffer.array(), 0, buffer.position()));
        Assertions.assertEquals((int)"abcdefghkl".length(), (int)buffer.position());
        Assertions.assertTrue((boolean)buffer.hasRemaining());
        ((FileChannel)Mockito.verify((Object)channelMock, (VerificationMode)Mockito.atLeastOnce())).read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadProps() throws IOException {
        File tempFile = TestUtils.tempFile();
        try {
            String testContent = "a=1\nb=2\n#a comment\n\nc=3\nd=";
            Files.write(tempFile.toPath(), testContent.getBytes(), new OpenOption[0]);
            Properties props = Utils.loadProps((String)tempFile.getPath());
            Assertions.assertEquals((int)4, (int)props.size());
            Assertions.assertEquals((Object)"1", (Object)props.get("a"));
            Assertions.assertEquals((Object)"2", (Object)props.get("b"));
            Assertions.assertEquals((Object)"3", (Object)props.get("c"));
            Assertions.assertEquals((Object)"", (Object)props.get("d"));
            Properties restrictedProps = Utils.loadProps((String)tempFile.getPath(), Arrays.asList("b", "d", "e"));
            Assertions.assertEquals((int)2, (int)restrictedProps.size());
            Assertions.assertEquals((Object)"2", (Object)restrictedProps.get("b"));
            Assertions.assertEquals((Object)"", (Object)restrictedProps.get("d"));
        }
        finally {
            Files.deleteIfExists(tempFile.toPath());
        }
    }

    private String fileChannelMockExpectReadWithRandomBytes(FileChannel channelMock, int bufferSize) throws IOException {
        int bytesRead;
        int step = 20;
        Random random = new Random();
        OngoingStubbing when = Mockito.when((Object)channelMock.read((ByteBuffer)ArgumentMatchers.any(), ArgumentMatchers.anyLong()));
        StringBuilder expectedBufferContent = new StringBuilder();
        for (int remainingBytes = bufferSize; remainingBytes > 0; remainingBytes -= bytesRead) {
            bytesRead = remainingBytes < 20 ? remainingBytes : random.nextInt(20);
            String stringRead = IntStream.range(0, bytesRead).mapToObj(i -> "a").collect(Collectors.joining());
            expectedBufferContent.append(stringRead);
            when = when.then(invocation -> {
                ByteBuffer buffer = (ByteBuffer)invocation.getArgument(0);
                buffer.put(stringRead.getBytes());
                return bytesRead;
            });
        }
        return expectedBufferContent.toString();
    }

    @Timeout(value=120L)
    @Test
    public void testRecursiveDelete() throws IOException {
        Utils.delete(null);
        File tempFile = TestUtils.tempFile();
        Utils.delete((File)tempFile);
        Assertions.assertFalse((boolean)Files.exists(tempFile.toPath(), new LinkOption[0]));
        File tempDir = TestUtils.tempDirectory();
        File tempDir2 = TestUtils.tempDirectory(tempDir.toPath(), "a");
        TestUtils.tempDirectory(tempDir.toPath(), "b");
        TestUtils.tempDirectory(tempDir2.toPath(), "c");
        Utils.delete((File)tempDir);
        Assertions.assertFalse((boolean)Files.exists(tempDir.toPath(), new LinkOption[0]));
        Assertions.assertFalse((boolean)Files.exists(tempDir2.toPath(), new LinkOption[0]));
        Utils.delete((File)tempDir);
        Assertions.assertFalse((boolean)Files.exists(tempDir.toPath(), new LinkOption[0]));
    }

    @Test
    public void testIgnoreMissingSubFiles() throws IOException {
        File tempDir;
        boolean[] ignoreMissingSubFilesValues;
        for (boolean ignoreMissingSubFiles : ignoreMissingSubFilesValues = new boolean[]{false, true}) {
            tempDir = TestUtils.tempDirectory();
            File nonExistingTempFile = File.createTempFile("kafka", ".tmp", tempDir);
            nonExistingTempFile.delete();
            Utils.delete((File)tempDir, (boolean)ignoreMissingSubFiles);
            Assertions.assertFalse((boolean)Files.exists(tempDir.toPath(), new LinkOption[0]));
        }
        for (boolean ignoreMissingSubFiles : ignoreMissingSubFilesValues) {
            tempDir = TestUtils.tempDirectory();
            File existingTempFile = File.createTempFile("kafka", ".tmp", tempDir);
            Utils.delete((File)existingTempFile, (boolean)ignoreMissingSubFiles);
            Assertions.assertFalse((boolean)Files.exists(existingTempFile.toPath(), new LinkOption[0]));
        }
    }

    @Test
    public void testConvertTo32BitField() {
        HashSet bytes = Utils.mkSet((Object[])new Byte[]{(byte)0, (byte)1, (byte)5, (byte)10, (byte)31});
        int bitField = Utils.to32BitField((Set)bytes);
        Assertions.assertEquals((Object)bytes, (Object)Utils.from32BitField((int)bitField));
        bytes = new HashSet();
        bitField = Utils.to32BitField(bytes);
        Assertions.assertEquals(bytes, (Object)Utils.from32BitField((int)bitField));
        Assertions.assertThrows(IllegalArgumentException.class, () -> Utils.to32BitField((Set)Utils.mkSet((Object[])new Byte[]{(byte)0, (byte)11, (byte)32})));
    }

    @Test
    public void testUnion() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set anotherSet = Utils.mkSet((Object[])new String[]{"c", "d", "e"});
        Set union = Utils.union(TreeSet::new, (Set[])new Set[]{oneSet, anotherSet});
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"a", "b", "c", "d", "e"}), (Object)union);
        Assertions.assertEquals(TreeSet.class, union.getClass());
    }

    @Test
    public void testUnionOfOne() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set union = Utils.union(TreeSet::new, (Set[])new Set[]{oneSet});
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"a", "b", "c"}), (Object)union);
        Assertions.assertEquals(TreeSet.class, union.getClass());
    }

    @Test
    public void testUnionOfMany() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set twoSet = Utils.mkSet((Object[])new String[]{"c", "d", "e"});
        Set threeSet = Utils.mkSet((Object[])new String[]{"b", "c", "d"});
        Set fourSet = Utils.mkSet((Object[])new String[]{"x", "y", "z"});
        Set union = Utils.union(TreeSet::new, (Set[])new Set[]{oneSet, twoSet, threeSet, fourSet});
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"a", "b", "c", "d", "e", "x", "y", "z"}), (Object)union);
        Assertions.assertEquals(TreeSet.class, union.getClass());
    }

    @Test
    public void testUnionOfNone() {
        Set union = Utils.union(TreeSet::new, (Set[])new Set[0]);
        Assertions.assertEquals(Collections.emptySet(), (Object)union);
        Assertions.assertEquals(TreeSet.class, union.getClass());
    }

    @Test
    public void testIntersection() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set anotherSet = Utils.mkSet((Object[])new String[]{"c", "d", "e"});
        Set intersection = Utils.intersection(TreeSet::new, (Set)oneSet, (Set[])new Set[]{anotherSet});
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"c"}), (Object)intersection);
        Assertions.assertEquals(TreeSet.class, intersection.getClass());
    }

    @Test
    public void testIntersectionOfOne() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set intersection = Utils.intersection(TreeSet::new, (Set)oneSet, (Set[])new Set[0]);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"a", "b", "c"}), (Object)intersection);
        Assertions.assertEquals(TreeSet.class, intersection.getClass());
    }

    @Test
    public void testIntersectionOfMany() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set twoSet = Utils.mkSet((Object[])new String[]{"c", "d", "e"});
        Set threeSet = Utils.mkSet((Object[])new String[]{"b", "c", "d"});
        Set intersection = Utils.intersection(TreeSet::new, (Set)oneSet, (Set[])new Set[]{twoSet, threeSet});
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"c"}), (Object)intersection);
        Assertions.assertEquals(TreeSet.class, intersection.getClass());
    }

    @Test
    public void testDisjointIntersectionOfMany() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set twoSet = Utils.mkSet((Object[])new String[]{"c", "d", "e"});
        Set threeSet = Utils.mkSet((Object[])new String[]{"b", "c", "d"});
        Set fourSet = Utils.mkSet((Object[])new String[]{"x", "y", "z"});
        Set intersection = Utils.intersection(TreeSet::new, (Set)oneSet, (Set[])new Set[]{twoSet, threeSet, fourSet});
        Assertions.assertEquals(Collections.emptySet(), (Object)intersection);
        Assertions.assertEquals(TreeSet.class, intersection.getClass());
    }

    @Test
    public void testDiff() {
        Set oneSet = Utils.mkSet((Object[])new String[]{"a", "b", "c"});
        Set anotherSet = Utils.mkSet((Object[])new String[]{"c", "d", "e"});
        Set diff = Utils.diff(TreeSet::new, (Set)oneSet, (Set)anotherSet);
        Assertions.assertEquals((Object)Utils.mkSet((Object[])new String[]{"a", "b"}), (Object)diff);
        Assertions.assertEquals(TreeSet.class, diff.getClass());
    }

    @Test
    public void testPropsToMap() {
        Assertions.assertThrows(ConfigException.class, () -> {
            Properties props = new Properties();
            props.put((Object)1, (Object)2);
            Utils.propsToMap((Properties)props);
        });
        UtilsTest.assertValue(false);
        UtilsTest.assertValue(1);
        UtilsTest.assertValue("string");
        UtilsTest.assertValue(1.1);
        UtilsTest.assertValue(Collections.emptySet());
        UtilsTest.assertValue(Collections.emptyList());
        UtilsTest.assertValue(Collections.emptyMap());
    }

    private static void assertValue(Object value) {
        Properties props = new Properties();
        props.put("key", value);
        Assertions.assertEquals(Utils.propsToMap((Properties)props).get("key"), (Object)value);
    }

    @Test
    public void testCloseAllQuietly() {
        AtomicReference exception = new AtomicReference();
        String msg = "you should fail";
        AtomicInteger count = new AtomicInteger(0);
        AutoCloseable c0 = () -> {
            throw new RuntimeException(msg);
        };
        AutoCloseable c1 = count::incrementAndGet;
        Utils.closeAllQuietly(exception, (String)"test", (AutoCloseable[])((AutoCloseable[])Stream.of(c0, c1).toArray(AutoCloseable[]::new)));
        Assertions.assertEquals((Object)msg, (Object)((Throwable)exception.get()).getMessage());
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    public void shouldAcceptValidDateFormats() throws ParseException {
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSX"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXX"));
        this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
    }

    @Test
    public void shouldThrowOnInvalidDateFormatOrNullTimestamp() {
        Assertions.assertTrue((boolean)((IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> Utils.getDateTime(null))).getMessage().contains("Error parsing timestamp with null value"));
        this.checkExceptionForGetDateTimeMethod(() -> this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.X")));
        Assertions.assertTrue((boolean)((ParseException)Assertions.assertThrows(ParseException.class, () -> this.invokeGetDateTimeMethod(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss")))).getMessage().contains("It does not contain a 'T' according to ISO8601 format"));
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss").appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).toFormatter();
        LocalDateTime timestampWithNanoSeconds = LocalDateTime.of(2020, 11, 9, 12, 34, 56, 123456789);
        LocalDateTime timestampWithMicroSeconds = timestampWithNanoSeconds.truncatedTo(ChronoUnit.MICROS);
        LocalDateTime timestampWithSeconds = timestampWithNanoSeconds.truncatedTo(ChronoUnit.SECONDS);
        this.checkExceptionForGetDateTimeMethod(() -> Utils.getDateTime((String)formatter.format(timestampWithNanoSeconds)));
        this.checkExceptionForGetDateTimeMethod(() -> Utils.getDateTime((String)formatter.format(timestampWithMicroSeconds)));
        this.checkExceptionForGetDateTimeMethod(() -> Utils.getDateTime((String)formatter.format(timestampWithSeconds)));
    }

    private void checkExceptionForGetDateTimeMethod(Executable executable) {
        Assertions.assertTrue((boolean)((ParseException)Assertions.assertThrows(ParseException.class, (Executable)executable)).getMessage().contains("Unparseable date"));
    }

    private void invokeGetDateTimeMethod(SimpleDateFormat format) throws ParseException {
        Date checkpoint = new Date();
        String formattedCheckpoint = format.format(checkpoint);
        Utils.getDateTime((String)formattedCheckpoint);
    }

    @Test
    void testIsBlank() {
        Assertions.assertTrue((boolean)Utils.isBlank(null));
        Assertions.assertTrue((boolean)Utils.isBlank((String)""));
        Assertions.assertTrue((boolean)Utils.isBlank((String)" "));
        Assertions.assertFalse((boolean)Utils.isBlank((String)"bob"));
        Assertions.assertFalse((boolean)Utils.isBlank((String)" bob "));
    }

    @Test
    public void testCharacterArrayEquality() {
        this.assertCharacterArraysAreNotEqual(null, "abc");
        this.assertCharacterArraysAreNotEqual(null, "");
        this.assertCharacterArraysAreNotEqual("abc", null);
        this.assertCharacterArraysAreNotEqual("", null);
        this.assertCharacterArraysAreNotEqual("", "abc");
        this.assertCharacterArraysAreNotEqual("abc", "abC");
        this.assertCharacterArraysAreNotEqual("abc", "abcd");
        this.assertCharacterArraysAreNotEqual("abc", "abcdefg");
        this.assertCharacterArraysAreNotEqual("abcdefg", "abc");
        this.assertCharacterArraysAreEqual("abc", "abc");
        this.assertCharacterArraysAreEqual("a", "a");
        this.assertCharacterArraysAreEqual("", "");
        this.assertCharacterArraysAreEqual("", "");
        this.assertCharacterArraysAreEqual(null, null);
    }

    private void assertCharacterArraysAreNotEqual(String a, String b) {
        char[] second;
        char[] first = a != null ? a.toCharArray() : null;
        char[] cArray = second = b != null ? b.toCharArray() : null;
        if (a == null) {
            Assertions.assertNotNull((Object)b);
        } else {
            Assertions.assertFalse((boolean)a.equals(b));
        }
        Assertions.assertFalse((boolean)Utils.isEqualConstantTime((char[])first, (char[])second));
        Assertions.assertFalse((boolean)Utils.isEqualConstantTime((char[])second, (char[])first));
    }

    private void assertCharacterArraysAreEqual(String a, String b) {
        char[] second;
        char[] first = a != null ? a.toCharArray() : null;
        char[] cArray = second = b != null ? b.toCharArray() : null;
        if (a == null) {
            Assertions.assertNull((Object)b);
        } else {
            Assertions.assertTrue((boolean)a.equals(b));
        }
        Assertions.assertTrue((boolean)Utils.isEqualConstantTime((char[])first, (char[])second));
        Assertions.assertTrue((boolean)Utils.isEqualConstantTime((char[])second, (char[])first));
    }

    private static class TestCloseable
    implements Closeable {
        private final int id;
        private final IOException closeException;
        private boolean closed;

        TestCloseable(int id, boolean exceptionOnClose) {
            this.id = id;
            this.closeException = exceptionOnClose ? new IOException("Test close exception " + id) : null;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            if (this.closeException != null) {
                throw this.closeException;
            }
        }

        static TestCloseable[] createCloseables(boolean ... exceptionOnClose) {
            TestCloseable[] closeables = new TestCloseable[exceptionOnClose.length];
            for (int i = 0; i < closeables.length; ++i) {
                closeables[i] = new TestCloseable(i, exceptionOnClose[i]);
            }
            return closeables;
        }

        static void checkClosed(TestCloseable ... closeables) {
            for (TestCloseable closeable : closeables) {
                Assertions.assertTrue((boolean)closeable.closed, (String)("Close not invoked for " + closeable.id));
            }
        }

        static void checkException(IOException e, TestCloseable ... closeablesWithException) {
            Assertions.assertEquals((Object)closeablesWithException[0].closeException, (Object)e);
            Throwable[] suppressed = e.getSuppressed();
            Assertions.assertEquals((int)(closeablesWithException.length - 1), (int)suppressed.length);
            for (int i = 1; i < closeablesWithException.length; ++i) {
                Assertions.assertEquals((Object)closeablesWithException[i].closeException, (Object)suppressed[i - 1]);
            }
        }
    }
}

