/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.interceptor;

import java.net.InetAddress;
import java.util.Optional;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.RequestHeaderData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.server.interceptor.DefaultBrokerInterceptor;
import org.apache.kafka.server.link.ClusterLinkRequestContext;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultBrokerInterceptorTest {
    private Metrics metrics;
    private DefaultBrokerInterceptor interceptor;

    @BeforeEach
    public void setUp() {
        this.metrics = new Metrics();
        this.interceptor = new DefaultBrokerInterceptor();
    }

    @AfterEach
    public void tearDown() {
        this.metrics.close();
    }

    @Test
    public void testRequestContext() {
        RequestHeaderData headerData = new RequestHeaderData().setClientId("clientId").setCorrelationId(1).setRequestApiKey(ApiKeys.METADATA.id).setRequestApiVersion(ApiKeys.METADATA.latestVersion());
        RequestContext context = this.requestContext(headerData);
        Assertions.assertEquals(RequestContext.class, context.getClass());
    }

    @Test
    public void testLinkRequestContext() {
        Uuid linkId = Uuid.randomUuid();
        RequestHeaderData headerData = new RequestHeaderData().setClusterLinkId(linkId).setClientId("clientId").setCorrelationId(1).setRequestApiKey(ApiKeys.METADATA.id).setRequestApiVersion(ApiKeys.METADATA.latestVersion());
        RequestContext context = this.requestContext(headerData);
        Assertions.assertEquals(ClusterLinkRequestContext.class, context.getClass());
        headerData = new RequestHeaderData().setClientId("clientId").setCorrelationId(1).setRequestApiKey(ApiKeys.METADATA.id).setRequestApiVersion(ApiKeys.METADATA.latestVersion());
        context = this.requestContext(headerData);
        Assertions.assertEquals(ClusterLinkRequestContext.class, context.getClass());
    }

    private RequestContext requestContext(RequestHeaderData headerData) {
        return this.interceptor.newContext(new RequestHeader(headerData, 2), "0", InetAddress.getLoopbackAddress(), new KafkaPrincipal("User", "user"), ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT), SecurityProtocol.PLAINTEXT, null, this.metrics, null, false, Optional.empty(), null);
    }
}

