/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.scram.ScramCredential;
import org.apache.kafka.common.security.scram.ScramCredentialCallback;
import org.apache.kafka.common.security.scram.internals.ScramCredentialUtils;
import org.apache.kafka.common.security.scram.internals.ScramFormatter;
import org.apache.kafka.common.security.scram.internals.ScramMechanism;
import org.apache.kafka.common.utils.Utils;

public class FileBasedScramCallbackHandler
implements AuthenticateCallbackHandler {
    public static final String SCRAM_FILE_PROP = "scram.credential.file";
    private static final String SEPARATOR = ":";
    private volatile String saslMechanism;
    private volatile String scramFile;

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        this.saslMechanism = saslMechanism;
        this.scramFile = (String)configs.get(SCRAM_FILE_PROP);
    }

    public void handle(Callback[] callbacks) throws IOException {
        String name = null;
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                name = ((NameCallback)callback).getDefaultName();
                continue;
            }
            if (callback instanceof ScramCredentialCallback) {
                String credential = Utils.loadProps((String)this.scramFile).getProperty(name + SEPARATOR + this.saslMechanism);
                if (credential == null) continue;
                ((ScramCredentialCallback)callback).scramCredential(ScramCredentialUtils.credentialFromString((String)credential));
                continue;
            }
            throw new IllegalStateException("Unexpected callback " + callback);
        }
    }

    public void close() {
    }

    public static void addScramCredentials(String scramCredentialFile, String userName, String password) throws Exception {
        Properties allCredentials = Utils.loadProps((String)scramCredentialFile);
        for (ScramMechanism mechanism : ScramMechanism.values()) {
            ScramCredential credential = new ScramFormatter(mechanism).generateCredential(password, 4096);
            String credentialString = ScramCredentialUtils.credentialToString((ScramCredential)credential);
            allCredentials.setProperty(userName + SEPARATOR + mechanism.mechanismName(), credentialString);
        }
        try (FileOutputStream out = new FileOutputStream(scramCredentialFile);){
            allCredentials.store(out, "");
        }
    }
}

