/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.test;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.common.utils.CopyOnWriteMap;
import org.apache.kafka.common.utils.Time;

public class Microbenchmarks {
    public static void main(String[] args) throws Exception {
        final int iters = Integer.parseInt(args[0]);
        double x = 0.0;
        long start = System.nanoTime();
        for (int i = 0; i < iters; ++i) {
            x += Math.sqrt(x);
        }
        System.out.println(x);
        System.out.println("sqrt: " + (double)(System.nanoTime() - start) / (double)iters);
        Microbenchmarks.systemMillis(iters);
        Microbenchmarks.systemNanos(iters);
        long total = 0L;
        start = System.nanoTime();
        total += Microbenchmarks.systemMillis(iters);
        System.out.println("System.currentTimeMillis(): " + (System.nanoTime() - start) / (long)iters);
        start = System.nanoTime();
        System.out.println("System.nanoTime(): " + (System.nanoTime() - start) / (long)iters);
        System.out.println(total += Microbenchmarks.systemNanos(iters));
        int n = 0;
        Random random = new Random();
        start = System.nanoTime();
        for (int i = 0; i < iters; ++i) {
            n += random.nextInt();
        }
        System.out.println(n);
        System.out.println("random: " + (System.nanoTime() - start) / (long)iters);
        float[] floats = new float[1024];
        for (int i = 0; i < floats.length; ++i) {
            floats[i] = random.nextFloat();
        }
        Arrays.sort(floats);
        int loc = 0;
        start = System.nanoTime();
        for (int i = 0; i < iters; ++i) {
            loc += Arrays.binarySearch(floats, floats[i % floats.length]);
        }
        System.out.println(loc);
        System.out.println("binary search: " + (System.nanoTime() - start) / (long)iters);
        final Time time = Time.SYSTEM;
        final AtomicBoolean done = new AtomicBoolean(false);
        final Object lock = new Object();
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                time.sleep(1L);
                int counter = 0;
                long start = time.nanoseconds();
                for (int i = 0; i < iters; ++i) {
                    Object object = lock;
                    synchronized (object) {
                        ++counter;
                        continue;
                    }
                }
                System.out.println("synchronized: " + (time.nanoseconds() - start) / (long)iters);
                System.out.println(counter);
                done.set(true);
            }
        };
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int counter = 0;
                while (!done.get()) {
                    time.sleep(1L);
                    Object object = lock;
                    synchronized (object) {
                        ++counter;
                    }
                }
                System.out.println("Counter: " + counter);
            }
        };
        t1.start();
        t2.start();
        t1.join();
        t2.join();
        System.out.println("Testing locks");
        done.set(false);
        final ReentrantLock lock2 = new ReentrantLock();
        Thread t3 = new Thread(){

            @Override
            public void run() {
                time.sleep(1L);
                int counter = 0;
                long start = time.nanoseconds();
                for (int i = 0; i < iters; ++i) {
                    lock2.lock();
                    ++counter;
                    lock2.unlock();
                }
                System.out.println("lock: " + (time.nanoseconds() - start) / (long)iters);
                System.out.println(counter);
                done.set(true);
            }
        };
        Thread t4 = new Thread(){

            @Override
            public void run() {
                int counter = 0;
                while (!done.get()) {
                    time.sleep(1L);
                    lock2.lock();
                    ++counter;
                    lock2.unlock();
                }
                System.out.println("Counter: " + counter);
            }
        };
        t3.start();
        t4.start();
        t3.join();
        t4.join();
        HashMap<String, Integer> values = new HashMap<String, Integer>();
        for (int i = 0; i < 100; ++i) {
            values.put(Integer.toString(i), i);
        }
        System.out.println("HashMap:");
        Microbenchmarks.benchMap(2, 1000000, values);
        System.out.println("ConcurentHashMap:");
        Microbenchmarks.benchMap(2, 1000000, new ConcurrentHashMap<String, Integer>(values));
        System.out.println("CopyOnWriteMap:");
        Microbenchmarks.benchMap(2, 1000000, (Map<String, Integer>)new CopyOnWriteMap(values));
    }

    private static void benchMap(int numThreads, final int iters, final Map<String, Integer> map) throws Exception {
        final ArrayList<String> keys = new ArrayList<String>(map.keySet());
        final ArrayList<5> threads = new ArrayList<5>();
        for (int i = 0; i < numThreads; ++i) {
            threads.add(new Thread(){

                @Override
                public void run() {
                    long start = System.nanoTime();
                    for (int j = 0; j < iters; ++j) {
                        map.get(keys.get(j % threads.size()));
                    }
                    System.out.println("Map access time: " + (double)(System.nanoTime() - start) / (double)iters);
                }
            });
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    private static long systemMillis(int iters) {
        long total = 0L;
        for (int i = 0; i < iters; ++i) {
            total += System.currentTimeMillis();
        }
        return total;
    }

    private static long systemNanos(int iters) {
        long total = 0L;
        for (int i = 0; i < iters; ++i) {
            total += System.currentTimeMillis();
        }
        return total;
    }
}

