/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class SnapshotHeaderRecord
implements ApiMessage {
    short version;
    long lastContainedLogTimestamp;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("version", Type.INT16, "The version of the snapshot header record"), new Field("last_contained_log_timestamp", Type.INT64, "The append time of the last record from the log contained in this snapshot"), Field.TaggedFieldsSection.of(new Object[0]));
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public SnapshotHeaderRecord(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public SnapshotHeaderRecord(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public SnapshotHeaderRecord() {
        this.version = 0;
        this.lastContainedLogTimestamp = 0L;
    }

    @Override
    public short apiKey() {
        return -1;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 0;
    }

    @Override
    public void read(Readable _readable, short _version, MessageContext _context) {
        this.version = _readable.readShort();
        this.lastContainedLogTimestamp = _readable.readLong();
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.version);
        _writable.writeLong(this.lastContainedLogTimestamp);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(8);
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SnapshotHeaderRecord)) {
            return false;
        }
        SnapshotHeaderRecord other = (SnapshotHeaderRecord)obj;
        if (this.version != other.version) {
            return false;
        }
        if (this.lastContainedLogTimestamp != other.lastContainedLogTimestamp) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.version;
        hashCode = 31 * hashCode + ((int)(this.lastContainedLogTimestamp >> 32) ^ (int)this.lastContainedLogTimestamp);
        return hashCode;
    }

    @Override
    public SnapshotHeaderRecord duplicate() {
        SnapshotHeaderRecord _duplicate = new SnapshotHeaderRecord();
        _duplicate.version = this.version;
        _duplicate.lastContainedLogTimestamp = this.lastContainedLogTimestamp;
        return _duplicate;
    }

    public String toString() {
        return "SnapshotHeaderRecord(version=" + this.version + ", lastContainedLogTimestamp=" + this.lastContainedLogTimestamp + ")";
    }

    public short version() {
        return this.version;
    }

    public long lastContainedLogTimestamp() {
        return this.lastContainedLogTimestamp;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public SnapshotHeaderRecord setVersion(short v) {
        this.version = v;
        return this;
    }

    public SnapshotHeaderRecord setLastContainedLogTimestamp(long v) {
        this.lastContainedLogTimestamp = v;
        return this;
    }
}

