/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.Collections;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.kafka.common.network.NoOpProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocol;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolV1Engine;
import org.apache.kafka.common.network.ProxyProtocolV2Engine;

public class ProxyProtocolEngineFactory {
    private ProxyProtocol proxyProtocol;
    private final Supplier<ProxyProtocolEngine> proxyProtocolEngineSupplier;
    private final Map<String, Object> configs;

    public ProxyProtocolEngineFactory(ProxyProtocol proxyProtocol) {
        this(proxyProtocol, Collections.emptyMap());
    }

    public ProxyProtocolEngineFactory(ProxyProtocol proxyProtocol, Map<String, Object> configs) {
        this.proxyProtocol = proxyProtocol;
        this.proxyProtocolEngineSupplier = this::createFromVersion;
        this.configs = configs;
    }

    ProxyProtocolEngineFactory(Supplier<ProxyProtocolEngine> proxyProtocolEngineSupplier) {
        this.proxyProtocolEngineSupplier = proxyProtocolEngineSupplier;
        this.configs = Collections.emptyMap();
    }

    ProxyProtocolEngine createProxyProtocolEngine() {
        return this.proxyProtocolEngineSupplier.get();
    }

    private ProxyProtocolEngine createFromVersion() {
        ProxyProtocolEngine engine;
        switch (this.proxyProtocol) {
            case V1: {
                engine = new ProxyProtocolV1Engine();
                break;
            }
            case V2: {
                engine = new ProxyProtocolV2Engine();
                break;
            }
            case NONE: {
                engine = new NoOpProxyProtocolEngine();
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized PROXY protocol version " + (Object)((Object)this.proxyProtocol));
            }
        }
        engine.configure(this.configs);
        return engine;
    }
}

