/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.Tlv;

public class ProxyProtocolV1Engine
implements ProxyProtocolEngine {
    private static final int MAX_LENGTH = 108;
    private static final String INVALID_PROTOCOL_HEADER = "Invalid Proxy Protocol Header.";
    private static final byte[] PROXY = "PROXY".getBytes(StandardCharsets.US_ASCII);
    private int byteCount;
    private InetAddress sourceAddress;
    private int sourcePort = -1;
    private final StringBuilder stringBuilder = new StringBuilder();
    private boolean carriageReturnSeen = false;
    private boolean proxyHeaderDetected = false;
    private boolean proxyHeaderParsed = false;
    private boolean proxyProtocolFallbackEnabled = false;

    private IOException invalidProtocolHeaderException() {
        return new IOException("Invalid Proxy Protocol Header. Protocol Header:" + this.stringBuilder);
    }

    private void decodeProxyProtocol() throws IOException {
        if (this.proxyHeaderParsed) {
            return;
        }
        String[] tokens = this.stringBuilder.toString().split(" ");
        if (tokens.length < 1 || !Arrays.equals(tokens[0].getBytes(StandardCharsets.US_ASCII), PROXY)) {
            throw this.invalidProtocolHeaderException();
        }
        switch (tokens[1]) {
            case "TCP4": {
                if (tokens.length == 6) {
                    this.sourceAddress = Inet4Address.getByName(tokens[2]);
                    break;
                }
                throw this.invalidProtocolHeaderException();
            }
            case "TCP6": {
                if (tokens.length == 6) {
                    this.sourceAddress = Inet6Address.getByName(tokens[2]);
                    break;
                }
                throw this.invalidProtocolHeaderException();
            }
            case "UNKNOWN": {
                break;
            }
            default: {
                throw this.invalidProtocolHeaderException();
            }
        }
        if (this.sourceAddress != null) {
            try {
                this.sourcePort = Integer.parseInt(tokens[4]);
            }
            catch (NumberFormatException e) {
                throw this.invalidProtocolHeaderException();
            }
        }
        this.proxyHeaderParsed = true;
    }

    @Override
    public void processHeaders(ByteBuffer buf) throws IOException {
        if (!this.proxyHeaderDetected) {
            if (buf.remaining() < PROXY.length) {
                return;
            }
            for (byte proxyByte : PROXY) {
                byte bufferByte = buf.get();
                if (bufferByte != proxyByte) {
                    if (this.proxyProtocolFallbackEnabled) {
                        buf.position(0);
                        this.proxyHeaderParsed = true;
                        return;
                    }
                    throw new IOException(INVALID_PROTOCOL_HEADER);
                }
                this.stringBuilder.append((char)bufferByte);
            }
            this.proxyHeaderDetected = true;
        }
        while (buf.hasRemaining()) {
            char c = (char)buf.get();
            if (this.carriageReturnSeen) {
                if (c == '\n') {
                    this.decodeProxyProtocol();
                    break;
                }
                throw new IOException(INVALID_PROTOCOL_HEADER);
            }
            if (c == '\r') {
                this.carriageReturnSeen = true;
            } else {
                this.stringBuilder.append(c);
            }
            if (this.byteCount++ != 108) continue;
            throw new IOException(INVALID_PROTOCOL_HEADER);
        }
    }

    @Override
    public boolean hasClientInformation() {
        return this.sourceAddress != null;
    }

    @Override
    public InetAddress clientAddress() {
        return this.sourceAddress;
    }

    @Override
    public int clientPort() {
        return this.sourcePort;
    }

    @Override
    public boolean ready() {
        return this.proxyHeaderParsed;
    }

    @Override
    public Tlv getTlv(int type) {
        return null;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        Map<String, ?> configMap = Collections.unmodifiableMap(configs);
        this.proxyProtocolFallbackEnabled = configMap.getOrDefault("confluent.proxy.protocol.fallback.enabled", ConfluentConfigs.PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT);
    }
}

