/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.record;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Objects;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.record.AbstractLegacyRecordBatch;
import org.apache.kafka.common.record.AbstractRecordBatch;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.DefaultRecordBatch;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.LegacyRecord;
import org.apache.kafka.common.record.LogInputStream;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.CloseableIterator;
import org.apache.kafka.common.utils.Utils;

public class FileLogInputStream
implements LogInputStream<FileChannelRecordBatch> {
    private static final int MIN_HEADER_READ_REQUIRED = 18;
    private static final int MAX_HEADER_READ_ATTEMPTED = 61;
    private int position;
    private final int end;
    private final FileRecords fileRecords;

    FileLogInputStream(FileRecords records, int start, int end) {
        this.fileRecords = records;
        this.position = start;
        this.end = end;
    }

    @Override
    public FileChannelRecordBatch nextBatch() throws IOException {
        FileChannelRecordBatch batch;
        FileChannel channel = this.fileRecords.channel();
        if (this.position >= this.end - 18) {
            return null;
        }
        ByteBuffer logHeaderBuffer = ByteBuffer.allocate(61);
        Utils.readFully(channel, logHeaderBuffer, this.position);
        logHeaderBuffer.flip();
        if (logHeaderBuffer.remaining() < 18) {
            return null;
        }
        long offset = logHeaderBuffer.getLong(0);
        int size = logHeaderBuffer.getInt(8);
        if (size < 0) {
            throw new CorruptRecordException(String.format("Invalid batch size %s found in file %s", size, this.fileRecords.file()));
        }
        if (this.end - this.position < 12 + size) {
            return null;
        }
        byte magic = logHeaderBuffer.get(16);
        if (LegacyRecord.isCompatibleMagic(magic)) {
            int headerSize = 12 + LegacyRecord.headerSize(magic);
            if (logHeaderBuffer.remaining() < headerSize) {
                return null;
            }
            logHeaderBuffer.limit(headerSize);
            batch = new AbstractLegacyRecordBatch.LegacyFileChannelRecordBatch(offset, magic, this.fileRecords, this.position, size, logHeaderBuffer);
        } else if (magic >= 2) {
            if (logHeaderBuffer.remaining() < 61) {
                return null;
            }
            batch = new DefaultRecordBatch.DefaultFileChannelRecordBatch(offset, magic, this.fileRecords, this.position, size, logHeaderBuffer);
        } else {
            throw new CorruptRecordException(String.format("Invalid magic %s found in file %s", magic, this.fileRecords.file()));
        }
        this.position += batch.sizeInBytes();
        return batch;
    }

    public static abstract class FileChannelRecordBatch
    extends AbstractRecordBatch {
        protected final long offset;
        protected final byte magic;
        protected final FileRecords fileRecords;
        protected final int position;
        protected final int batchSize;
        private RecordBatch fullBatch;
        private RecordBatch batchHeader;

        FileChannelRecordBatch(long offset, byte magic, FileRecords fileRecords, int position, int batchSize, RecordBatch batchHeader) {
            this.offset = offset;
            this.magic = magic;
            this.fileRecords = fileRecords;
            this.position = position;
            this.batchSize = batchSize;
            this.batchHeader = batchHeader;
        }

        @Override
        public CompressionType compressionType() {
            return this.availableBatchHeader().compressionType();
        }

        @Override
        public TimestampType timestampType() {
            return this.availableBatchHeader().timestampType();
        }

        @Override
        public long checksum() {
            return this.availableBatchHeader().checksum();
        }

        @Override
        public long maxTimestamp() {
            return this.availableBatchHeader().maxTimestamp();
        }

        public int position() {
            return this.position;
        }

        @Override
        public byte magic() {
            return this.magic;
        }

        @Override
        public Iterator<Record> iterator() {
            return this.loadFullBatch().iterator();
        }

        @Override
        public CloseableIterator<Record> streamingIterator(BufferSupplier bufferSupplier) {
            return this.loadFullBatch().streamingIterator(bufferSupplier);
        }

        @Override
        public boolean isValid() {
            return this.loadFullBatch().isValid();
        }

        @Override
        public void ensureValid() {
            this.loadFullBatch().ensureValid();
        }

        @Override
        public int sizeInBytes() {
            return 12 + this.batchSize;
        }

        @Override
        public void writeTo(ByteBuffer buffer) {
            FileChannel channel = this.fileRecords.channel();
            try {
                int limit = buffer.limit();
                buffer.limit(buffer.position() + this.sizeInBytes());
                Utils.readFully(channel, buffer, this.position);
                buffer.limit(limit);
            }
            catch (IOException e) {
                throw new KafkaException("Failed to read record batch at position " + this.position + " from " + this.fileRecords, e);
            }
        }

        protected abstract RecordBatch toMemoryRecordBatch(ByteBuffer var1);

        protected abstract int headerSize();

        protected RecordBatch loadFullBatch() {
            if (this.fullBatch == null) {
                this.batchHeader = null;
                this.fullBatch = this.loadBatchWithSize(this.sizeInBytes(), "full record batch");
            }
            return this.fullBatch;
        }

        protected RecordBatch availableBatchHeader() {
            if (this.fullBatch != null) {
                return this.fullBatch;
            }
            return this.batchHeader;
        }

        private RecordBatch loadBatchWithSize(int size, String description) {
            FileChannel channel = this.fileRecords.channel();
            try {
                ByteBuffer buffer = ByteBuffer.allocate(size);
                Utils.readFullyOrFail(channel, buffer, this.position, description);
                buffer.rewind();
                return this.toMemoryRecordBatch(buffer);
            }
            catch (IOException e) {
                throw new KafkaException("Failed to load record batch at position " + this.position + " from " + this.fileRecords, e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileChannelRecordBatch that = (FileChannelRecordBatch)o;
            FileChannel channel = this.fileRecords == null ? null : this.fileRecords.channel();
            FileChannel thatChannel = that.fileRecords == null ? null : that.fileRecords.channel();
            return this.offset == that.offset && this.position == that.position && this.batchSize == that.batchSize && Objects.equals(channel, thatChannel);
        }

        public int hashCode() {
            FileChannel channel = this.fileRecords == null ? null : this.fileRecords.channel();
            int result = Long.hashCode(this.offset);
            result = 31 * result + (channel != null ? channel.hashCode() : 0);
            result = 31 * result + this.position;
            result = 31 * result + this.batchSize;
            return result;
        }

        public String toString() {
            return "FileChannelRecordBatch(magic: " + this.magic + ", offset: " + this.offset + ", size: " + this.batchSize + ")";
        }
    }
}

