/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.ClusterLinkListing;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.ListClusterLinksResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class ListClusterLinksResponse
extends AbstractResponse {
    private final ListClusterLinksResponseData data;

    public ListClusterLinksResponse(ListClusterLinksResponseData data) {
        super(ApiKeys.LIST_CLUSTER_LINKS);
        this.data = data;
    }

    public ListClusterLinksResponse(int throttleTimeMs, Throwable e) {
        super(ApiKeys.LIST_CLUSTER_LINKS);
        this.data = new ListClusterLinksResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(e).code()).setErrorMessage(e.getMessage());
    }

    public void complete(KafkaFutureImpl<Collection<ClusterLinkListing>> result) {
        Errors error = Errors.forCode(this.data.errorCode());
        if (error != Errors.NONE) {
            result.completeExceptionally(error.exception(this.data.errorMessage()));
            return;
        }
        ArrayList<ClusterLinkListing> clusterLinks = new ArrayList<ClusterLinkListing>(this.data.entries().size());
        for (ListClusterLinksResponseData.EntryData entryData : this.data.entries()) {
            clusterLinks.add(new ClusterLinkListing(entryData.linkName(), entryData.linkId(), entryData.remoteClusterId(), entryData.localClusterId(), Optional.ofNullable(entryData.topics()), entryData.available()));
        }
        result.complete(clusterLinks);
    }

    @Override
    public ListClusterLinksResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    public static ListClusterLinksResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ListClusterLinksResponse(new ListClusterLinksResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

