/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import org.apache.kafka.clients.consumer.internals.Utils;
import org.apache.kafka.common.TopicPartition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TopicPartitionComparatorTest {
    private static final TopicPartition TP1 = new TopicPartition("t1", 0);
    private static final TopicPartition TP1_COPY = new TopicPartition("t1", 0);
    private static final TopicPartition TP2 = new TopicPartition("t1", 1);
    private static final TopicPartition TP3 = new TopicPartition("t11", 1);
    private final Utils.TopicPartitionComparator comparator = new Utils.TopicPartitionComparator();

    @Test
    public void shouldBeEqual() {
        Assertions.assertEquals((int)0, (int)this.comparator.compare(TP1, TP1_COPY));
    }

    @Test
    public void shouldBeSmallerSameTopic() {
        Assertions.assertTrue((this.comparator.compare(TP1, TP2) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeLargerSameTopic() {
        Assertions.assertTrue((this.comparator.compare(TP2, TP1) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeSmallerSamePartitionNumber() {
        Assertions.assertTrue((this.comparator.compare(TP1, TP3) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void shouldBeLargerSamePartitionNumber() {
        Assertions.assertTrue((this.comparator.compare(TP3, TP1) > 0 ? 1 : 0) != 0);
    }
}

