/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class AlterPartitionReassignmentsRequestData
implements ApiMessage {
    int timeoutMs;
    List<ReassignableTopic> topics;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("timeout_ms", (Type)Type.INT32, "The time in ms to wait for the request to complete."), new Field("topics", (Type)new CompactArrayOf((Type)ReassignableTopic.SCHEMA_0), "The topics to reassign."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public AlterPartitionReassignmentsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterPartitionReassignmentsRequestData() {
        this.timeoutMs = 60000;
        this.topics = new ArrayList<ReassignableTopic>(0);
    }

    public short apiKey() {
        return 45;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.timeoutMs = _readable.readInt();
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field topics was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<ReassignableTopic> newCollection = new ArrayList<ReassignableTopic>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new ReassignableTopic(_readable, _version, _context));
        }
        this.topics = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.timeoutMs);
        _writable.writeUnsignedVarint(this.topics.size() + 1);
        for (ReassignableTopic topicsElement : this.topics) {
            topicsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1)));
        for (ReassignableTopic topicsElement : this.topics) {
            topicsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterPartitionReassignmentsRequestData)) {
            return false;
        }
        AlterPartitionReassignmentsRequestData other = (AlterPartitionReassignmentsRequestData)obj;
        if (this.timeoutMs != other.timeoutMs) {
            return false;
        }
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.timeoutMs;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        return hashCode;
    }

    public AlterPartitionReassignmentsRequestData duplicate() {
        AlterPartitionReassignmentsRequestData _duplicate = new AlterPartitionReassignmentsRequestData();
        _duplicate.timeoutMs = this.timeoutMs;
        ArrayList<ReassignableTopic> newTopics = new ArrayList<ReassignableTopic>(this.topics.size());
        for (ReassignableTopic _element : this.topics) {
            newTopics.add(_element.duplicate());
        }
        _duplicate.topics = newTopics;
        return _duplicate;
    }

    public String toString() {
        return "AlterPartitionReassignmentsRequestData(timeoutMs=" + this.timeoutMs + ", topics=" + MessageUtil.deepToString(this.topics.iterator()) + ")";
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public List<ReassignableTopic> topics() {
        return this.topics;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterPartitionReassignmentsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    public AlterPartitionReassignmentsRequestData setTopics(List<ReassignableTopic> v) {
        this.topics = v;
        return this;
    }

    public static class ReassignablePartition
    implements Message {
        int partitionIndex;
        List<Integer> replicas;
        List<Integer> observers;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("replicas", (Type)CompactArrayOf.nullable((Type)Type.INT32), "The replicas to place the partitions on, or null to cancel a pending reassignment for this partition."), Field.TaggedFieldsSection.of((Object[])new Object[]{10000, new Field("observers", (Type)new CompactArrayOf((Type)Type.INT32), "The brokers in Replicas that are observers in a partition.")})});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ReassignablePartition(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ReassignablePartition() {
            this.partitionIndex = 0;
            this.replicas = null;
            this.observers = new ArrayList<Integer>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReassignablePartition");
            }
            this.partitionIndex = _readable.readInt();
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                this.replicas = null;
            } else {
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
                for (int i = 0; i < arrayLength; ++i) {
                    newCollection.add(_readable.readInt());
                }
                this.replicas = newCollection;
            }
            this.observers = new ArrayList<Integer>(0);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            block4: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        int arrayLength2 = _readable.readUnsignedVarint() - 1;
                        if (arrayLength2 < 0) {
                            throw new RuntimeException("non-nullable field observers was serialized as null");
                        }
                        if (arrayLength2 > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength2);
                        for (int i = 0; i < arrayLength2; ++i) {
                            newCollection.add(_readable.readInt());
                        }
                        this.observers = newCollection;
                        continue block4;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            if (this.replicas == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _writable.writeUnsignedVarint(this.replicas.size() + 1);
                for (Integer replicasElement : this.replicas) {
                    _writable.writeInt(replicasElement.intValue());
                }
            }
            if (!this.observers.isEmpty()) {
                ++_numTaggedFields;
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.observers.isEmpty()) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.observers).intValue());
                _writable.writeUnsignedVarint(this.observers.size() + 1);
                for (Integer observersElement : this.observers) {
                    _writable.writeInt(observersElement.intValue());
                }
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReassignablePartition");
            }
            _size.addBytes(4);
            if (this.replicas == null) {
                _size.addBytes(1);
            } else {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.replicas.size() + 1)));
                _size.addBytes(this.replicas.size() * 4);
            }
            if (!this.observers.isEmpty()) {
                ++_numTaggedFields;
                _size.addBytes(2);
                int _sizeBeforeArray = _size.totalSize();
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.observers.size() + 1)));
                _size.addBytes(this.observers.size() * 4);
                int _arraySize = _size.totalSize() - _sizeBeforeArray;
                _cache.setArraySizeInBytes(this.observers, Integer.valueOf(_arraySize));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_arraySize));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReassignablePartition)) {
                return false;
            }
            ReassignablePartition other = (ReassignablePartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.replicas == null ? other.replicas != null : !this.replicas.equals(other.replicas)) {
                return false;
            }
            if (this.observers == null ? other.observers != null : !this.observers.equals(other.observers)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + (this.replicas == null ? 0 : this.replicas.hashCode());
            hashCode = 31 * hashCode + (this.observers == null ? 0 : this.observers.hashCode());
            return hashCode;
        }

        public ReassignablePartition duplicate() {
            ReassignablePartition _duplicate = new ReassignablePartition();
            _duplicate.partitionIndex = this.partitionIndex;
            if (this.replicas == null) {
                _duplicate.replicas = null;
            } else {
                ArrayList<Integer> newReplicas = new ArrayList<Integer>(this.replicas.size());
                for (Integer _element : this.replicas) {
                    newReplicas.add(_element);
                }
                _duplicate.replicas = newReplicas;
            }
            ArrayList<Integer> newObservers = new ArrayList<Integer>(this.observers.size());
            for (Integer _element : this.observers) {
                newObservers.add(_element);
            }
            _duplicate.observers = newObservers;
            return _duplicate;
        }

        public String toString() {
            return "ReassignablePartition(partitionIndex=" + this.partitionIndex + ", replicas=" + (this.replicas == null ? "null" : MessageUtil.deepToString(this.replicas.iterator())) + ", observers=" + MessageUtil.deepToString(this.observers.iterator()) + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public List<Integer> replicas() {
            return this.replicas;
        }

        public List<Integer> observers() {
            return this.observers;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReassignablePartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public ReassignablePartition setReplicas(List<Integer> v) {
            this.replicas = v;
            return this;
        }

        public ReassignablePartition setObservers(List<Integer> v) {
            this.observers = v;
            return this;
        }
    }

    public static class ReassignableTopic
    implements Message {
        String name;
        List<ReassignablePartition> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("partitions", (Type)new CompactArrayOf((Type)ReassignablePartition.SCHEMA_0), "The partitions to reassign."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public ReassignableTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ReassignableTopic() {
            this.name = "";
            this.partitions = new ArrayList<ReassignablePartition>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 0;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReassignableTopic");
            }
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<ReassignablePartition> newCollection = new ArrayList<ReassignablePartition>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReassignablePartition(_readable, _version, _context));
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
            _writable.writeUnsignedVarint(this.partitions.size() + 1);
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                ReassignablePartition partitionsElement = (ReassignablePartition)_stringBytes.next();
                partitionsElement.write(_writable, _cache, _version, _context);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 0) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReassignableTopic");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            for (ReassignablePartition partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReassignableTopic)) {
                return false;
            }
            ReassignableTopic other = (ReassignableTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public ReassignableTopic duplicate() {
            ReassignableTopic _duplicate = new ReassignableTopic();
            _duplicate.name = this.name;
            ArrayList<ReassignablePartition> newPartitions = new ArrayList<ReassignablePartition>(this.partitions.size());
            for (ReassignablePartition _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "ReassignableTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<ReassignablePartition> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReassignableTopic setName(String v) {
            this.name = v;
            return this;
        }

        public ReassignableTopic setPartitions(List<ReassignablePartition> v) {
            this.partitions = v;
            return this;
        }
    }
}

