/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class AlterReplicaLogDirsRequestData
implements ApiMessage {
    AlterReplicaLogDirCollection dirs;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public AlterReplicaLogDirsRequestData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public AlterReplicaLogDirsRequestData() {
        this.dirs = new AlterReplicaLogDirCollection(0);
    }

    public short apiKey() {
        return 34;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        AlterReplicaLogDirCollection newCollection;
        int arrayLength;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field dirs was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new AlterReplicaLogDirCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AlterReplicaLogDir(_readable, _version, _context));
            }
            this.dirs = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field dirs was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new AlterReplicaLogDirCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new AlterReplicaLogDir(_readable, _version, _context));
            }
            this.dirs = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Iterator iterator;
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.dirs.size() + 1);
            iterator = this.dirs.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDir dirsElement = (AlterReplicaLogDir)iterator.next();
                dirsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.dirs.size());
            iterator = this.dirs.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDir dirsElement = (AlterReplicaLogDir)iterator.next();
                dirsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.dirs.size() + 1)));
        } else {
            _size.addBytes(4);
        }
        Iterator<RawTaggedField> iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir dirsElement = (AlterReplicaLogDir)iterator.next();
            dirsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AlterReplicaLogDirsRequestData)) {
            return false;
        }
        AlterReplicaLogDirsRequestData other = (AlterReplicaLogDirsRequestData)obj;
        if (this.dirs == null ? other.dirs != null : !this.dirs.equals((Object)other.dirs)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.dirs == null ? 0 : this.dirs.hashCode());
        return hashCode;
    }

    public AlterReplicaLogDirsRequestData duplicate() {
        AlterReplicaLogDirsRequestData _duplicate = new AlterReplicaLogDirsRequestData();
        AlterReplicaLogDirCollection newDirs = new AlterReplicaLogDirCollection(this.dirs.size());
        Iterator iterator = this.dirs.iterator();
        while (iterator.hasNext()) {
            AlterReplicaLogDir _element = (AlterReplicaLogDir)iterator.next();
            newDirs.add(_element.duplicate());
        }
        _duplicate.dirs = newDirs;
        return _duplicate;
    }

    public String toString() {
        return "AlterReplicaLogDirsRequestData(dirs=" + MessageUtil.deepToString((Iterator)this.dirs.iterator()) + ")";
    }

    public AlterReplicaLogDirCollection dirs() {
        return this.dirs;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public AlterReplicaLogDirsRequestData setDirs(AlterReplicaLogDirCollection v) {
        this.dirs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("dirs", (Type)new ArrayOf((Type)AlterReplicaLogDir.SCHEMA_0), "The alterations to make for each directory.")});
        SCHEMA_2 = new Schema(new Field[]{new Field("dirs", (Type)new CompactArrayOf((Type)AlterReplicaLogDir.SCHEMA_2), "The alterations to make for each directory."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    }

    public static class AlterReplicaLogDirCollection
    extends ImplicitLinkedHashMultiCollection<AlterReplicaLogDir> {
        public AlterReplicaLogDirCollection() {
        }

        public AlterReplicaLogDirCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirCollection(Iterator<AlterReplicaLogDir> iterator) {
            super(iterator);
        }

        public AlterReplicaLogDir find(String path) {
            AlterReplicaLogDir _key = new AlterReplicaLogDir();
            _key.setPath(path);
            return (AlterReplicaLogDir)this.find(_key);
        }

        public List<AlterReplicaLogDir> findAll(String path) {
            AlterReplicaLogDir _key = new AlterReplicaLogDir();
            _key.setPath(path);
            return this.findAll(_key);
        }

        public AlterReplicaLogDirCollection duplicate() {
            AlterReplicaLogDirCollection _duplicate = new AlterReplicaLogDirCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDir _element = (AlterReplicaLogDir)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AlterReplicaLogDirTopicCollection
    extends ImplicitLinkedHashMultiCollection<AlterReplicaLogDirTopic> {
        public AlterReplicaLogDirTopicCollection() {
        }

        public AlterReplicaLogDirTopicCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public AlterReplicaLogDirTopicCollection(Iterator<AlterReplicaLogDirTopic> iterator) {
            super(iterator);
        }

        public AlterReplicaLogDirTopic find(String name) {
            AlterReplicaLogDirTopic _key = new AlterReplicaLogDirTopic();
            _key.setName(name);
            return (AlterReplicaLogDirTopic)this.find(_key);
        }

        public List<AlterReplicaLogDirTopic> findAll(String name) {
            AlterReplicaLogDirTopic _key = new AlterReplicaLogDirTopic();
            _key.setName(name);
            return this.findAll(_key);
        }

        public AlterReplicaLogDirTopicCollection duplicate() {
            AlterReplicaLogDirTopicCollection _duplicate = new AlterReplicaLogDirTopicCollection(this.size());
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic _element = (AlterReplicaLogDirTopic)iterator.next();
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class AlterReplicaLogDirTopic
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        List<Integer> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public AlterReplicaLogDirTopic(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public AlterReplicaLogDirTopic() {
            this.name = "";
            this.partitions = new ArrayList<Integer>(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterReplicaLogDirTopic");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            int arrayLength = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field partitions was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            ArrayList<Integer> newCollection = new ArrayList<Integer>(arrayLength);
            for (int i = 0; i < arrayLength; ++i) {
                newCollection.add(_readable.readInt());
            }
            this.partitions = newCollection;
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.name);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
            } else {
                _writable.writeInt(this.partitions.size());
            }
            _stringBytes = this.partitions.iterator();
            while (_stringBytes.hasNext()) {
                Integer partitionsElement = (Integer)_stringBytes.next();
                _writable.writeInt(partitionsElement.intValue());
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterReplicaLogDirTopic");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.name, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            _size.addBytes(this.partitions.size() * 4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirTopic)) {
                return false;
            }
            AlterReplicaLogDirTopic other = (AlterReplicaLogDirTopic)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDirTopic)) {
                return false;
            }
            AlterReplicaLogDirTopic other = (AlterReplicaLogDirTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        public AlterReplicaLogDirTopic duplicate() {
            AlterReplicaLogDirTopic _duplicate = new AlterReplicaLogDirTopic();
            _duplicate.name = this.name;
            ArrayList<Integer> newPartitions = new ArrayList<Integer>(this.partitions.size());
            for (Integer _element : this.partitions) {
                newPartitions.add(_element);
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "AlterReplicaLogDirTopic(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<Integer> partitions() {
            return this.partitions;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterReplicaLogDirTopic setName(String v) {
            this.name = v;
            return this;
        }

        public AlterReplicaLogDirTopic setPartitions(List<Integer> v) {
            this.partitions = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)Type.INT32), "The partition indexes.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("name", (Type)Type.COMPACT_STRING, "The topic name."), new Field("partitions", (Type)new CompactArrayOf((Type)Type.INT32), "The partition indexes."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class AlterReplicaLogDir
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String path;
        AlterReplicaLogDirTopicCollection topics;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public AlterReplicaLogDir(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public AlterReplicaLogDir() {
            this.path = "";
            this.topics = new AlterReplicaLogDirTopicCollection(0);
            this.prev = -2;
            this.next = -2;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            AlterReplicaLogDirTopicCollection newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AlterReplicaLogDir");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field path was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field path had invalid length " + length);
            }
            this.path = _readable.readString(length);
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AlterReplicaLogDirTopicCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AlterReplicaLogDirTopic(_readable, _version, _context));
                }
                this.topics = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field topics was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new AlterReplicaLogDirTopicCollection(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new AlterReplicaLogDirTopic(_readable, _version, _context));
                }
                this.topics = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.path);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.topics.size() + 1);
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    AlterReplicaLogDirTopic topicsElement = (AlterReplicaLogDirTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.topics.size());
                _stringBytes = this.topics.iterator();
                while (_stringBytes.hasNext()) {
                    AlterReplicaLogDirTopic topicsElement = (AlterReplicaLogDirTopic)_stringBytes.next();
                    topicsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AlterReplicaLogDir");
            }
            byte[] _stringBytes = this.path.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'path' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.path, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.topics.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            Iterator<RawTaggedField> iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic topicsElement = (AlterReplicaLogDirTopic)iterator.next();
                topicsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof AlterReplicaLogDir)) {
                return false;
            }
            AlterReplicaLogDir other = (AlterReplicaLogDir)obj;
            return !(this.path == null ? other.path != null : !this.path.equals(other.path));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AlterReplicaLogDir)) {
                return false;
            }
            AlterReplicaLogDir other = (AlterReplicaLogDir)obj;
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            if (this.topics == null ? other.topics != null : !this.topics.equals((Object)other.topics)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.path == null ? 0 : this.path.hashCode());
            return hashCode;
        }

        public AlterReplicaLogDir duplicate() {
            AlterReplicaLogDir _duplicate = new AlterReplicaLogDir();
            _duplicate.path = this.path;
            AlterReplicaLogDirTopicCollection newTopics = new AlterReplicaLogDirTopicCollection(this.topics.size());
            Iterator iterator = this.topics.iterator();
            while (iterator.hasNext()) {
                AlterReplicaLogDirTopic _element = (AlterReplicaLogDirTopic)iterator.next();
                newTopics.add(_element.duplicate());
            }
            _duplicate.topics = newTopics;
            return _duplicate;
        }

        public String toString() {
            return "AlterReplicaLogDir(path=" + (this.path == null ? "null" : "'" + this.path.toString() + "'") + ", topics=" + MessageUtil.deepToString((Iterator)this.topics.iterator()) + ")";
        }

        public String path() {
            return this.path;
        }

        public AlterReplicaLogDirTopicCollection topics() {
            return this.topics;
        }

        public int next() {
            return this.next;
        }

        public int prev() {
            return this.prev;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AlterReplicaLogDir setPath(String v) {
            this.path = v;
            return this;
        }

        public AlterReplicaLogDir setTopics(AlterReplicaLogDirTopicCollection v) {
            this.topics = v;
            return this;
        }

        public void setNext(int v) {
            this.next = v;
        }

        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("path", (Type)Type.STRING, "The absolute directory path."), new Field("topics", (Type)new ArrayOf((Type)AlterReplicaLogDirTopic.SCHEMA_0), "The topics to add to the directory.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("path", (Type)Type.COMPACT_STRING, "The absolute directory path."), new Field("topics", (Type)new CompactArrayOf((Type)AlterReplicaLogDirTopic.SCHEMA_2), "The topics to add to the directory."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

