/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class DescribeEvenClusterLoadStatusResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    String errorMessage;
    EvenClusterLoadStatusResponse evenClusterLoadStatus;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code for the api request."), new Field("error_message", (Type)Type.NULLABLE_STRING, "The message describing the error occured based on the error code, or null if there was no error."), new Field("even_cluster_load_status", (Type)EvenClusterLoadStatusResponse.SCHEMA_0, "Even cluster load status.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The error code for the api request."), new Field("error_message", (Type)Type.NULLABLE_STRING, "The message describing the error occured based on the error code, or null if there was no error."), new Field("even_cluster_load_status", (Type)EvenClusterLoadStatusResponse.SCHEMA_1, "Even cluster load status.")});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 1;

    public DescribeEvenClusterLoadStatusResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public DescribeEvenClusterLoadStatusResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.errorMessage = "";
        this.evenClusterLoadStatus = new EvenClusterLoadStatusResponse();
    }

    public short apiKey() {
        return 10012;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _readable.readShort();
        short length = _readable.readShort();
        if (length < 0) {
            this.errorMessage = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field errorMessage had invalid length " + length);
            }
            this.errorMessage = _readable.readString((int)length);
        }
        this.evenClusterLoadStatus = new EvenClusterLoadStatusResponse(_readable, _version, _context);
        this._unknownTaggedFields = null;
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        _writable.writeShort(this.errorCode);
        if (this.errorMessage == null) {
            _writable.writeShort((short)-1);
        } else {
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
            _writable.writeShort((short)_stringBytes.length);
            _writable.writeByteArray(_stringBytes);
        }
        this.evenClusterLoadStatus.write(_writable, _cache, _version, _context);
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        if ((_numTaggedFields += _rawWriter.numFields()) > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        _size.addBytes(2);
        if (this.errorMessage == null) {
            _size.addBytes(2);
        } else {
            byte[] _stringBytes = this.errorMessage.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'errorMessage' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
            _size.addBytes(_stringBytes.length + 2);
        }
        int _sizeBeforeStruct = _size.totalSize();
        this.evenClusterLoadStatus.addSize(_size, _cache, _version, _context);
        int n = _size.totalSize() - _sizeBeforeStruct;
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DescribeEvenClusterLoadStatusResponseData)) {
            return false;
        }
        DescribeEvenClusterLoadStatusResponseData other = (DescribeEvenClusterLoadStatusResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
            return false;
        }
        if (this.evenClusterLoadStatus == null ? other.evenClusterLoadStatus != null : !this.evenClusterLoadStatus.equals(other.evenClusterLoadStatus)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
        hashCode = 31 * hashCode + (this.evenClusterLoadStatus == null ? 0 : this.evenClusterLoadStatus.hashCode());
        return hashCode;
    }

    public DescribeEvenClusterLoadStatusResponseData duplicate() {
        DescribeEvenClusterLoadStatusResponseData _duplicate = new DescribeEvenClusterLoadStatusResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
        _duplicate.evenClusterLoadStatus = this.evenClusterLoadStatus.duplicate();
        return _duplicate;
    }

    public String toString() {
        return "DescribeEvenClusterLoadStatusResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", evenClusterLoadStatus=" + this.evenClusterLoadStatus.toString() + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public String errorMessage() {
        return this.errorMessage;
    }

    public EvenClusterLoadStatusResponse evenClusterLoadStatus() {
        return this.evenClusterLoadStatus;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public DescribeEvenClusterLoadStatusResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public DescribeEvenClusterLoadStatusResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public DescribeEvenClusterLoadStatusResponseData setErrorMessage(String v) {
        this.errorMessage = v;
        return this;
    }

    public DescribeEvenClusterLoadStatusResponseData setEvenClusterLoadStatus(EvenClusterLoadStatusResponse v) {
        this.evenClusterLoadStatus = v;
        return this;
    }

    public static class EvenClusterLoadStatusResponse
    implements Message {
        String healUnevenLoadTrigger;
        String currentStatus;
        String previousStatus;
        long currentStatusLastUpdateTimeMs;
        long previousStatusLastUpdateTimeMs;
        short evenClusterLoadErrorCode;
        String evenClusterLoadErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("current_status", (Type)Type.STRING, "The status of the current even cluster load."), new Field("previous_status", (Type)Type.NULLABLE_STRING, "The status of the previous even cluster load."), new Field("current_status_last_update_time_ms", (Type)Type.INT64, "The timestamp denoting when the current status was last updated, in milliseconds since the unix epoch"), new Field("previous_status_last_update_time_ms", (Type)Type.INT64, "The timestamp denoting when the previous status was last updated, in milliseconds since the unix epoch"), new Field("even_cluster_load_error_code", (Type)Type.INT16, "The error code for the even cluster load error."), new Field("even_cluster_load_error_message", (Type)Type.NULLABLE_STRING, "The error message describes the error in case the current status has failed, else corresponds to the previous status if its failed, or null if there was no failure in both the statuses.")});
        public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("heal_uneven_load_trigger", (Type)Type.STRING, "Denotes what causes the Confluent DataBalancer to start rebalance operations."), new Field("current_status", (Type)Type.NULLABLE_STRING, "The status of the current even cluster load."), new Field("previous_status", (Type)Type.NULLABLE_STRING, "The status of the previous even cluster load."), new Field("current_status_last_update_time_ms", (Type)Type.INT64, "The timestamp denoting when the current status was last updated, in milliseconds since the unix epoch"), new Field("previous_status_last_update_time_ms", (Type)Type.INT64, "The timestamp denoting when the previous status was last updated, in milliseconds since the unix epoch"), new Field("even_cluster_load_error_code", (Type)Type.INT16, "The error code for the even cluster load error."), new Field("even_cluster_load_error_message", (Type)Type.NULLABLE_STRING, "The error message describes the error in case the current status has failed, else corresponds to the previous status if its failed, or null if there was no failure in both the statuses.")});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 1;

        public EvenClusterLoadStatusResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EvenClusterLoadStatusResponse() {
            this.healUnevenLoadTrigger = "";
            this.currentStatus = "";
            this.previousStatus = null;
            this.currentStatusLastUpdateTimeMs = 0L;
            this.previousStatusLastUpdateTimeMs = 0L;
            this.evenClusterLoadErrorCode = 0;
            this.evenClusterLoadErrorMessage = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void read(Readable _readable, short _version, MessageContext _context) {
            short length;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EvenClusterLoadStatusResponse");
            }
            if (_version >= 1) {
                length = _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field healUnevenLoadTrigger was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field healUnevenLoadTrigger had invalid length " + length);
                }
                this.healUnevenLoadTrigger = _readable.readString((int)length);
            } else {
                this.healUnevenLoadTrigger = "";
            }
            length = _readable.readShort();
            if (length < 0) {
                if (_version < 1) throw new RuntimeException("non-nullable field currentStatus was serialized as null");
                this.currentStatus = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field currentStatus had invalid length " + length);
                }
                this.currentStatus = _readable.readString((int)length);
            }
            length = _readable.readShort();
            if (length < 0) {
                this.previousStatus = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field previousStatus had invalid length " + length);
                }
                this.previousStatus = _readable.readString((int)length);
            }
            this.currentStatusLastUpdateTimeMs = _readable.readLong();
            this.previousStatusLastUpdateTimeMs = _readable.readLong();
            this.evenClusterLoadErrorCode = _readable.readShort();
            length = _readable.readShort();
            if (length < 0) {
                this.evenClusterLoadErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field evenClusterLoadErrorMessage had invalid length " + length);
                }
                this.evenClusterLoadErrorMessage = _readable.readString((int)length);
            }
            this._unknownTaggedFields = null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version >= 1) {
                _stringBytes = _cache.getSerializedValue((Object)this.healUnevenLoadTrigger);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            } else if (!this.healUnevenLoadTrigger.equals("")) {
                throw new UnsupportedVersionException("Attempted to write a non-default healUnevenLoadTrigger at version " + _version);
            }
            if (this.currentStatus == null) {
                if (_version < 1) throw new NullPointerException();
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.currentStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            if (this.previousStatus == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.previousStatus);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            _writable.writeLong(this.currentStatusLastUpdateTimeMs);
            _writable.writeLong(this.previousStatusLastUpdateTimeMs);
            _writable.writeShort(this.evenClusterLoadErrorCode);
            if (this.evenClusterLoadErrorMessage == null) {
                _writable.writeShort((short)-1);
            } else {
                _stringBytes = _cache.getSerializedValue((Object)this.evenClusterLoadErrorMessage);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            if ((_numTaggedFields += _rawWriter.numFields()) <= 0) return;
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            byte[] _stringBytes;
            int _numTaggedFields = 0;
            if (_version > 1) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EvenClusterLoadStatusResponse");
            }
            if (_version >= 1) {
                _stringBytes = this.healUnevenLoadTrigger.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'healUnevenLoadTrigger' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.healUnevenLoadTrigger, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this.currentStatus == null) {
                _size.addBytes(2);
            } else {
                _stringBytes = this.currentStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'currentStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.currentStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this.previousStatus == null) {
                _size.addBytes(2);
            } else {
                _stringBytes = this.previousStatus.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'previousStatus' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.previousStatus, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            _size.addBytes(8);
            _size.addBytes(8);
            _size.addBytes(2);
            if (this.evenClusterLoadErrorMessage == null) {
                _size.addBytes(2);
            } else {
                _stringBytes = this.evenClusterLoadErrorMessage.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'evenClusterLoadErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.evenClusterLoadErrorMessage, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EvenClusterLoadStatusResponse)) {
                return false;
            }
            EvenClusterLoadStatusResponse other = (EvenClusterLoadStatusResponse)obj;
            if (this.healUnevenLoadTrigger == null ? other.healUnevenLoadTrigger != null : !this.healUnevenLoadTrigger.equals(other.healUnevenLoadTrigger)) {
                return false;
            }
            if (this.currentStatus == null ? other.currentStatus != null : !this.currentStatus.equals(other.currentStatus)) {
                return false;
            }
            if (this.previousStatus == null ? other.previousStatus != null : !this.previousStatus.equals(other.previousStatus)) {
                return false;
            }
            if (this.currentStatusLastUpdateTimeMs != other.currentStatusLastUpdateTimeMs) {
                return false;
            }
            if (this.previousStatusLastUpdateTimeMs != other.previousStatusLastUpdateTimeMs) {
                return false;
            }
            if (this.evenClusterLoadErrorCode != other.evenClusterLoadErrorCode) {
                return false;
            }
            if (this.evenClusterLoadErrorMessage == null ? other.evenClusterLoadErrorMessage != null : !this.evenClusterLoadErrorMessage.equals(other.evenClusterLoadErrorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.healUnevenLoadTrigger == null ? 0 : this.healUnevenLoadTrigger.hashCode());
            hashCode = 31 * hashCode + (this.currentStatus == null ? 0 : this.currentStatus.hashCode());
            hashCode = 31 * hashCode + (this.previousStatus == null ? 0 : this.previousStatus.hashCode());
            hashCode = 31 * hashCode + ((int)(this.currentStatusLastUpdateTimeMs >> 32) ^ (int)this.currentStatusLastUpdateTimeMs);
            hashCode = 31 * hashCode + ((int)(this.previousStatusLastUpdateTimeMs >> 32) ^ (int)this.previousStatusLastUpdateTimeMs);
            hashCode = 31 * hashCode + this.evenClusterLoadErrorCode;
            hashCode = 31 * hashCode + (this.evenClusterLoadErrorMessage == null ? 0 : this.evenClusterLoadErrorMessage.hashCode());
            return hashCode;
        }

        public EvenClusterLoadStatusResponse duplicate() {
            EvenClusterLoadStatusResponse _duplicate = new EvenClusterLoadStatusResponse();
            _duplicate.healUnevenLoadTrigger = this.healUnevenLoadTrigger;
            _duplicate.currentStatus = this.currentStatus == null ? null : this.currentStatus;
            _duplicate.previousStatus = this.previousStatus == null ? null : this.previousStatus;
            _duplicate.currentStatusLastUpdateTimeMs = this.currentStatusLastUpdateTimeMs;
            _duplicate.previousStatusLastUpdateTimeMs = this.previousStatusLastUpdateTimeMs;
            _duplicate.evenClusterLoadErrorCode = this.evenClusterLoadErrorCode;
            _duplicate.evenClusterLoadErrorMessage = this.evenClusterLoadErrorMessage == null ? null : this.evenClusterLoadErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "EvenClusterLoadStatusResponse(healUnevenLoadTrigger=" + (this.healUnevenLoadTrigger == null ? "null" : "'" + this.healUnevenLoadTrigger.toString() + "'") + ", currentStatus=" + (this.currentStatus == null ? "null" : "'" + this.currentStatus.toString() + "'") + ", previousStatus=" + (this.previousStatus == null ? "null" : "'" + this.previousStatus.toString() + "'") + ", currentStatusLastUpdateTimeMs=" + this.currentStatusLastUpdateTimeMs + ", previousStatusLastUpdateTimeMs=" + this.previousStatusLastUpdateTimeMs + ", evenClusterLoadErrorCode=" + this.evenClusterLoadErrorCode + ", evenClusterLoadErrorMessage=" + (this.evenClusterLoadErrorMessage == null ? "null" : "'" + this.evenClusterLoadErrorMessage.toString() + "'") + ")";
        }

        public String healUnevenLoadTrigger() {
            return this.healUnevenLoadTrigger;
        }

        public String currentStatus() {
            return this.currentStatus;
        }

        public String previousStatus() {
            return this.previousStatus;
        }

        public long currentStatusLastUpdateTimeMs() {
            return this.currentStatusLastUpdateTimeMs;
        }

        public long previousStatusLastUpdateTimeMs() {
            return this.previousStatusLastUpdateTimeMs;
        }

        public short evenClusterLoadErrorCode() {
            return this.evenClusterLoadErrorCode;
        }

        public String evenClusterLoadErrorMessage() {
            return this.evenClusterLoadErrorMessage;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EvenClusterLoadStatusResponse setHealUnevenLoadTrigger(String v) {
            this.healUnevenLoadTrigger = v;
            return this;
        }

        public EvenClusterLoadStatusResponse setCurrentStatus(String v) {
            this.currentStatus = v;
            return this;
        }

        public EvenClusterLoadStatusResponse setPreviousStatus(String v) {
            this.previousStatus = v;
            return this;
        }

        public EvenClusterLoadStatusResponse setCurrentStatusLastUpdateTimeMs(long v) {
            this.currentStatusLastUpdateTimeMs = v;
            return this;
        }

        public EvenClusterLoadStatusResponse setPreviousStatusLastUpdateTimeMs(long v) {
            this.previousStatusLastUpdateTimeMs = v;
            return this;
        }

        public EvenClusterLoadStatusResponse setEvenClusterLoadErrorCode(short v) {
            this.evenClusterLoadErrorCode = v;
            return this;
        }

        public EvenClusterLoadStatusResponse setEvenClusterLoadErrorMessage(String v) {
            this.evenClusterLoadErrorMessage = v;
            return this;
        }
    }
}

