/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class ElectLeadersResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    List<ReplicaElectionResult> replicaElectionResults;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("replica_election_results", (Type)new ArrayOf((Type)ReplicaElectionResult.SCHEMA_0), "The election results, or an empty array if the requester did not have permission and the request asks for all partitions.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top level response error code."), new Field("replica_election_results", (Type)new ArrayOf((Type)ReplicaElectionResult.SCHEMA_0), "The election results, or an empty array if the requester did not have permission and the request asks for all partitions.")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top level response error code."), new Field("replica_election_results", (Type)new CompactArrayOf((Type)ReplicaElectionResult.SCHEMA_2), "The election results, or an empty array if the requester did not have permission and the request asks for all partitions."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public ElectLeadersResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ElectLeadersResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.replicaElectionResults = new ArrayList<ReplicaElectionResult>(0);
    }

    public short apiKey() {
        return 43;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<ReplicaElectionResult> newCollection;
        int arrayLength;
        this.throttleTimeMs = _readable.readInt();
        this.errorCode = _version >= 1 ? _readable.readShort() : (short)0;
        if (_version >= 2) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicaElectionResults was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReplicaElectionResult(_readable, _version, _context));
            }
            this.replicaElectionResults = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field replicaElectionResults was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<ReplicaElectionResult>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new ReplicaElectionResult(_readable, _version, _context));
            }
            this.replicaElectionResults = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeInt(this.throttleTimeMs);
        if (_version >= 1) {
            _writable.writeShort(this.errorCode);
        } else if (this.errorCode != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default errorCode at version " + _version);
        }
        if (_version >= 2) {
            _writable.writeUnsignedVarint(this.replicaElectionResults.size() + 1);
            for (ReplicaElectionResult replicaElectionResultsElement : this.replicaElectionResults) {
                replicaElectionResultsElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.replicaElectionResults.size());
            for (ReplicaElectionResult replicaElectionResultsElement : this.replicaElectionResults) {
                replicaElectionResultsElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(4);
        if (_version >= 1) {
            _size.addBytes(2);
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.replicaElectionResults.size() + 1)));
        } else {
            _size.addBytes(4);
        }
        for (ReplicaElectionResult replicaElectionResultsElement : this.replicaElectionResults) {
            replicaElectionResultsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ElectLeadersResponseData)) {
            return false;
        }
        ElectLeadersResponseData other = (ElectLeadersResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.replicaElectionResults == null ? other.replicaElectionResults != null : !this.replicaElectionResults.equals(other.replicaElectionResults)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + (this.replicaElectionResults == null ? 0 : this.replicaElectionResults.hashCode());
        return hashCode;
    }

    public ElectLeadersResponseData duplicate() {
        ElectLeadersResponseData _duplicate = new ElectLeadersResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        ArrayList<ReplicaElectionResult> newReplicaElectionResults = new ArrayList<ReplicaElectionResult>(this.replicaElectionResults.size());
        for (ReplicaElectionResult _element : this.replicaElectionResults) {
            newReplicaElectionResults.add(_element.duplicate());
        }
        _duplicate.replicaElectionResults = newReplicaElectionResults;
        return _duplicate;
    }

    public String toString() {
        return "ElectLeadersResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", replicaElectionResults=" + MessageUtil.deepToString(this.replicaElectionResults.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public List<ReplicaElectionResult> replicaElectionResults() {
        return this.replicaElectionResults;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ElectLeadersResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ElectLeadersResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public ElectLeadersResponseData setReplicaElectionResults(List<ReplicaElectionResult> v) {
        this.replicaElectionResults = v;
        return this;
    }

    public static class PartitionResult
    implements Message {
        int partitionId;
        short errorCode;
        String errorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public PartitionResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionResult() {
            this.partitionId = 0;
            this.errorCode = 0;
            this.errorMessage = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionResult");
            }
            this.partitionId = _readable.readInt();
            this.errorCode = _readable.readShort();
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.errorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field errorMessage had invalid length " + length);
                }
                this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionId);
            _writable.writeShort(this.errorCode);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                byte[] _stringBytes = _cache.getSerializedValue((Object)this.errorMessage);
                if (_version >= 2) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionResult");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            if (this.errorMessage == null) {
                if (_version >= 2) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'errorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.errorMessage, _stringBytes);
                if (_version >= 2) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionResult)) {
                return false;
            }
            PartitionResult other = (PartitionResult)obj;
            if (this.partitionId != other.partitionId) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionId;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            return hashCode;
        }

        public PartitionResult duplicate() {
            PartitionResult _duplicate = new PartitionResult();
            _duplicate.partitionId = this.partitionId;
            _duplicate.errorCode = this.errorCode;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            return _duplicate;
        }

        public String toString() {
            return "PartitionResult(partitionId=" + this.partitionId + ", errorCode=" + this.errorCode + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ")";
        }

        public int partitionId() {
            return this.partitionId;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionResult setPartitionId(int v) {
            this.partitionId = v;
            return this;
        }

        public PartitionResult setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionResult setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id"), new Field("error_code", (Type)Type.INT16, "The result error, or zero if there was no error."), new Field("error_message", (Type)Type.NULLABLE_STRING, "The result message, or null if there was no error.")});
            SCHEMA_2 = new Schema(new Field[]{new Field("partition_id", (Type)Type.INT32, "The partition id"), new Field("error_code", (Type)Type.INT16, "The result error, or zero if there was no error."), new Field("error_message", (Type)Type.COMPACT_NULLABLE_STRING, "The result message, or null if there was no error."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }

    public static class ReplicaElectionResult
    implements Message {
        String topic;
        List<PartitionResult> partitionResult;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 2;

        public ReplicaElectionResult(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public ReplicaElectionResult() {
            this.topic = "";
            this.partitionResult = new ArrayList<PartitionResult>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 2;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<PartitionResult> newCollection;
            int arrayLength;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of ReplicaElectionResult");
            }
            int length = _version >= 2 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field topic was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field topic had invalid length " + length);
            }
            this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            if (_version >= 2) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionResult was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionResult(_readable, _version, _context));
                }
                this.partitionResult = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionResult was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<PartitionResult>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionResult(_readable, _version, _context));
                }
                this.partitionResult = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 2) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue((Object)this.topic);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 2) {
                _writable.writeUnsignedVarint(this.partitionResult.size() + 1);
                _stringBytes = this.partitionResult.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionResult partitionResultElement = (PartitionResult)_stringBytes.next();
                    partitionResultElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitionResult.size());
                _stringBytes = this.partitionResult.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionResult partitionResultElement = (PartitionResult)_stringBytes.next();
                    partitionResultElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 2) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 2) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of ReplicaElectionResult");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'topic' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
            if (_version >= 2) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitionResult.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            for (PartitionResult partitionResultElement : this.partitionResult) {
                partitionResultElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 2) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ReplicaElectionResult)) {
                return false;
            }
            ReplicaElectionResult other = (ReplicaElectionResult)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (this.partitionResult == null ? other.partitionResult != null : !this.partitionResult.equals(other.partitionResult)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + (this.partitionResult == null ? 0 : this.partitionResult.hashCode());
            return hashCode;
        }

        public ReplicaElectionResult duplicate() {
            ReplicaElectionResult _duplicate = new ReplicaElectionResult();
            _duplicate.topic = this.topic;
            ArrayList<PartitionResult> newPartitionResult = new ArrayList<PartitionResult>(this.partitionResult.size());
            for (PartitionResult _element : this.partitionResult) {
                newPartitionResult.add(_element.duplicate());
            }
            _duplicate.partitionResult = newPartitionResult;
            return _duplicate;
        }

        public String toString() {
            return "ReplicaElectionResult(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", partitionResult=" + MessageUtil.deepToString(this.partitionResult.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public List<PartitionResult> partitionResult() {
            return this.partitionResult;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public ReplicaElectionResult setTopic(String v) {
            this.topic = v;
            return this;
        }

        public ReplicaElectionResult setPartitionResult(List<PartitionResult> v) {
            this.partitionResult = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The topic name"), new Field("partition_result", (Type)new ArrayOf((Type)PartitionResult.SCHEMA_0), "The results for each partition")});
            SCHEMA_2 = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, "The topic name"), new Field("partition_result", (Type)new CompactArrayOf((Type)PartitionResult.SCHEMA_2), "The results for each partition"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
        }
    }
}

