/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.record.BaseRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.utils.ByteUtils;

public class FetchResponseData
implements ApiMessage {
    int throttleTimeMs;
    short errorCode;
    int sessionId;
    List<FetchableTopicResponse> responses;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("responses", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_0), "The response topics.")});
    public static final Schema SCHEMA_1;
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema SCHEMA_11;
    public static final Schema SCHEMA_12;
    public static final Schema SCHEMA_13;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 13;

    public FetchResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public FetchResponseData() {
        this.throttleTimeMs = 0;
        this.errorCode = 0;
        this.sessionId = 0;
        this.responses = new ArrayList<FetchableTopicResponse>(0);
    }

    public short apiKey() {
        return 1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 13;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        ArrayList<FetchableTopicResponse> newCollection;
        int arrayLength;
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.errorCode = _version >= 7 ? _readable.readShort() : (short)0;
        this.sessionId = _version >= 7 ? _readable.readInt() : 0;
        if (_version >= 12) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new FetchableTopicResponse(_readable, _version, _context));
            }
            this.responses = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new ArrayList<FetchableTopicResponse>(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new FetchableTopicResponse(_readable, _version, _context));
            }
            this.responses = newCollection;
        }
        this._unknownTaggedFields = null;
        if (_version >= 12) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 7) {
            _writable.writeShort(this.errorCode);
        }
        if (_version >= 7) {
            _writable.writeInt(this.sessionId);
        } else if (this.sessionId != 0) {
            throw new UnsupportedVersionException("Attempted to write a non-default sessionId at version " + _version);
        }
        if (_version >= 12) {
            _writable.writeUnsignedVarint(this.responses.size() + 1);
            for (FetchableTopicResponse responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.responses.size());
            for (FetchableTopicResponse responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version, _context);
            }
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 12) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 1) {
            _size.addBytes(4);
        }
        if (_version >= 7) {
            _size.addBytes(2);
        }
        if (_version >= 7) {
            _size.addBytes(4);
        }
        if (_version >= 12) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.responses.size() + 1)));
        } else {
            _size.addBytes(4);
        }
        for (FetchableTopicResponse responsesElement : this.responses) {
            responsesElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 12) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof FetchResponseData)) {
            return false;
        }
        FetchResponseData other = (FetchResponseData)obj;
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.sessionId != other.sessionId) {
            return false;
        }
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + this.errorCode;
        hashCode = 31 * hashCode + this.sessionId;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        return hashCode;
    }

    public FetchResponseData duplicate() {
        FetchResponseData _duplicate = new FetchResponseData();
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        _duplicate.errorCode = this.errorCode;
        _duplicate.sessionId = this.sessionId;
        ArrayList<FetchableTopicResponse> newResponses = new ArrayList<FetchableTopicResponse>(this.responses.size());
        for (FetchableTopicResponse _element : this.responses) {
            newResponses.add(_element.duplicate());
        }
        _duplicate.responses = newResponses;
        return _duplicate;
    }

    public String toString() {
        return "FetchResponseData(throttleTimeMs=" + this.throttleTimeMs + ", errorCode=" + this.errorCode + ", sessionId=" + this.sessionId + ", responses=" + MessageUtil.deepToString(this.responses.iterator()) + ")";
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public short errorCode() {
        return this.errorCode;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public List<FetchableTopicResponse> responses() {
        return this.responses;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public FetchResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public FetchResponseData setErrorCode(short v) {
        this.errorCode = v;
        return this;
    }

    public FetchResponseData setSessionId(int v) {
        this.sessionId = v;
        return this;
    }

    public FetchResponseData setResponses(List<FetchableTopicResponse> v) {
        this.responses = v;
        return this;
    }

    static {
        SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_0), "The response topics.")}));
        SCHEMA_4 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_4), "The response topics.")});
        SCHEMA_6 = SCHEMA_5 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("responses", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_5), "The response topics.")});
        SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top level response error code."), new Field("session_id", (Type)Type.INT32, "The fetch session ID, or 0 if this is not part of a fetch session."), new Field("responses", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_5), "The response topics.")})));
        SCHEMA_11 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top level response error code."), new Field("session_id", (Type)Type.INT32, "The fetch session ID, or 0 if this is not part of a fetch session."), new Field("responses", (Type)new ArrayOf((Type)FetchableTopicResponse.SCHEMA_11), "The response topics.")});
        SCHEMA_12 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top level response error code."), new Field("session_id", (Type)Type.INT32, "The fetch session ID, or 0 if this is not part of a fetch session."), new Field("responses", (Type)new CompactArrayOf((Type)FetchableTopicResponse.SCHEMA_12), "The response topics."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMA_13 = new Schema(new Field[]{new Field("throttle_time_ms", (Type)Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), new Field("error_code", (Type)Type.INT16, "The top level response error code."), new Field("session_id", (Type)Type.INT32, "The fetch session ID, or 0 if this is not part of a fetch session."), new Field("responses", (Type)new CompactArrayOf((Type)FetchableTopicResponse.SCHEMA_13), "The response topics."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12, SCHEMA_13};
    }

    public static class AbortedTransaction
    implements Message {
        long producerId;
        long firstOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema SCHEMA_13;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 4;
        public static final short HIGHEST_SUPPORTED_VERSION = 13;

        public AbortedTransaction(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public AbortedTransaction() {
            this.producerId = 0L;
            this.firstOffset = 0L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 13;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of AbortedTransaction");
            }
            this.producerId = _readable.readLong();
            this.firstOffset = _readable.readLong();
            this._unknownTaggedFields = null;
            if (_version >= 12) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 4) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of AbortedTransaction");
            }
            int _numTaggedFields = 0;
            _writable.writeLong(this.producerId);
            _writable.writeLong(this.firstOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 12) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of AbortedTransaction");
            }
            _size.addBytes(8);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AbortedTransaction)) {
                return false;
            }
            AbortedTransaction other = (AbortedTransaction)obj;
            if (this.producerId != other.producerId) {
                return false;
            }
            if (this.firstOffset != other.firstOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.producerId >> 32) ^ (int)this.producerId);
            hashCode = 31 * hashCode + ((int)(this.firstOffset >> 32) ^ (int)this.firstOffset);
            return hashCode;
        }

        public AbortedTransaction duplicate() {
            AbortedTransaction _duplicate = new AbortedTransaction();
            _duplicate.producerId = this.producerId;
            _duplicate.firstOffset = this.firstOffset;
            return _duplicate;
        }

        public String toString() {
            return "AbortedTransaction(producerId=" + this.producerId + ", firstOffset=" + this.firstOffset + ")";
        }

        public long producerId() {
            return this.producerId;
        }

        public long firstOffset() {
            return this.firstOffset;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public AbortedTransaction setProducerId(long v) {
            this.producerId = v;
            return this;
        }

        public AbortedTransaction setFirstOffset(long v) {
            this.firstOffset = v;
            return this;
        }

        static {
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = (SCHEMA_4 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "The producer id associated with the aborted transaction."), new Field("first_offset", (Type)Type.INT64, "The first offset in the aborted transaction.")})))))));
            SCHEMA_13 = SCHEMA_12 = new Schema(new Field[]{new Field("producer_id", (Type)Type.INT64, "The producer id associated with the aborted transaction."), new Field("first_offset", (Type)Type.INT64, "The first offset in the aborted transaction."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{null, null, null, null, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12, SCHEMA_13};
        }
    }

    public static class SnapshotId
    implements Message {
        long endOffset;
        int epoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_12;
        public static final Schema SCHEMA_13;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 12;
        public static final short HIGHEST_SUPPORTED_VERSION = 13;

        public SnapshotId(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public SnapshotId() {
            this.endOffset = -1L;
            this.epoch = -1;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 13;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of SnapshotId");
            }
            this.endOffset = _readable.readLong();
            this.epoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of SnapshotId");
            }
            int _numTaggedFields = 0;
            _writable.writeLong(this.endOffset);
            _writable.writeInt(this.epoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of SnapshotId");
            }
            _size.addBytes(8);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SnapshotId)) {
                return false;
            }
            SnapshotId other = (SnapshotId)obj;
            if (this.endOffset != other.endOffset) {
                return false;
            }
            if (this.epoch != other.epoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            hashCode = 31 * hashCode + this.epoch;
            return hashCode;
        }

        public SnapshotId duplicate() {
            SnapshotId _duplicate = new SnapshotId();
            _duplicate.endOffset = this.endOffset;
            _duplicate.epoch = this.epoch;
            return _duplicate;
        }

        public String toString() {
            return "SnapshotId(endOffset=" + this.endOffset + ", epoch=" + this.epoch + ")";
        }

        public long endOffset() {
            return this.endOffset;
        }

        public int epoch() {
            return this.epoch;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public SnapshotId setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        public SnapshotId setEpoch(int v) {
            this.epoch = v;
            return this;
        }

        static {
            SCHEMA_13 = SCHEMA_12 = new Schema(new Field[]{new Field("end_offset", (Type)Type.INT64, ""), new Field("epoch", (Type)Type.INT32, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, null, null, null, null, SCHEMA_12, SCHEMA_13};
        }
    }

    public static class LeaderIdAndEpoch
    implements Message {
        int leaderId;
        int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_12;
        public static final Schema SCHEMA_13;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 12;
        public static final short HIGHEST_SUPPORTED_VERSION = 13;

        public LeaderIdAndEpoch(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public LeaderIdAndEpoch() {
            this.leaderId = -1;
            this.leaderEpoch = -1;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 13;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderIdAndEpoch");
            }
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderIdAndEpoch");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.leaderId);
            _writable.writeInt(this.leaderEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderIdAndEpoch");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderIdAndEpoch)) {
                return false;
            }
            LeaderIdAndEpoch other = (LeaderIdAndEpoch)obj;
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        public LeaderIdAndEpoch duplicate() {
            LeaderIdAndEpoch _duplicate = new LeaderIdAndEpoch();
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            return _duplicate;
        }

        public String toString() {
            return "LeaderIdAndEpoch(leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderIdAndEpoch setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public LeaderIdAndEpoch setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        static {
            SCHEMA_13 = SCHEMA_12 = new Schema(new Field[]{new Field("leader_id", (Type)Type.INT32, "The ID of the current leader or -1 if the leader is unknown."), new Field("leader_epoch", (Type)Type.INT32, "The latest known leader epoch"), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, null, null, null, null, SCHEMA_12, SCHEMA_13};
        }
    }

    public static class EpochEndOffset
    implements Message {
        int epoch;
        long endOffset;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_12;
        public static final Schema SCHEMA_13;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 12;
        public static final short HIGHEST_SUPPORTED_VERSION = 13;

        public EpochEndOffset(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public EpochEndOffset() {
            this.epoch = -1;
            this.endOffset = -1L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 13;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of EpochEndOffset");
            }
            this.epoch = _readable.readInt();
            this.endOffset = _readable.readLong();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 12) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of EpochEndOffset");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.epoch);
            _writable.writeLong(this.endOffset);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of EpochEndOffset");
            }
            _size.addBytes(4);
            _size.addBytes(8);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EpochEndOffset)) {
                return false;
            }
            EpochEndOffset other = (EpochEndOffset)obj;
            if (this.epoch != other.epoch) {
                return false;
            }
            if (this.endOffset != other.endOffset) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.epoch;
            hashCode = 31 * hashCode + ((int)(this.endOffset >> 32) ^ (int)this.endOffset);
            return hashCode;
        }

        public EpochEndOffset duplicate() {
            EpochEndOffset _duplicate = new EpochEndOffset();
            _duplicate.epoch = this.epoch;
            _duplicate.endOffset = this.endOffset;
            return _duplicate;
        }

        public String toString() {
            return "EpochEndOffset(epoch=" + this.epoch + ", endOffset=" + this.endOffset + ")";
        }

        public int epoch() {
            return this.epoch;
        }

        public long endOffset() {
            return this.endOffset;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public EpochEndOffset setEpoch(int v) {
            this.epoch = v;
            return this;
        }

        public EpochEndOffset setEndOffset(long v) {
            this.endOffset = v;
            return this;
        }

        static {
            SCHEMA_13 = SCHEMA_12 = new Schema(new Field[]{new Field("epoch", (Type)Type.INT32, ""), new Field("end_offset", (Type)Type.INT64, ""), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, null, null, null, null, SCHEMA_12, SCHEMA_13};
        }
    }

    public static class PartitionData
    implements Message {
        int partitionIndex;
        short errorCode;
        long highWatermark;
        long lastStableOffset;
        long logStartOffset;
        EpochEndOffset divergingEpoch;
        LeaderIdAndEpoch currentLeader;
        SnapshotId snapshotId;
        List<AbortedTransaction> abortedTransactions;
        int preferredReadReplica;
        BaseRecords records;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema SCHEMA_13;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 13;

        public PartitionData(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionData() {
            this.partitionIndex = 0;
            this.errorCode = 0;
            this.highWatermark = 0L;
            this.lastStableOffset = -1L;
            this.logStartOffset = -1L;
            this.divergingEpoch = new EpochEndOffset();
            this.currentLeader = new LeaderIdAndEpoch();
            this.snapshotId = new SnapshotId();
            this.abortedTransactions = new ArrayList<AbortedTransaction>(0);
            this.preferredReadReplica = -1;
            this.records = null;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 13;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionData");
            }
            this.partitionIndex = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.highWatermark = _readable.readLong();
            this.lastStableOffset = _version >= 4 ? _readable.readLong() : -1L;
            this.logStartOffset = _version >= 5 ? _readable.readLong() : -1L;
            this.divergingEpoch = new EpochEndOffset();
            this.currentLeader = new LeaderIdAndEpoch();
            this.snapshotId = new SnapshotId();
            if (_version >= 4) {
                int i;
                ArrayList<AbortedTransaction> newCollection;
                int arrayLength;
                if (_version >= 12) {
                    arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        this.abortedTransactions = null;
                    } else {
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection = new ArrayList(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add(new AbortedTransaction(_readable, _version, _context));
                        }
                        this.abortedTransactions = newCollection;
                    }
                } else {
                    arrayLength = _readable.readInt();
                    if (arrayLength < 0) {
                        this.abortedTransactions = null;
                    } else {
                        if (arrayLength > _readable.remaining()) {
                            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                        }
                        newCollection = new ArrayList<AbortedTransaction>(arrayLength);
                        for (i = 0; i < arrayLength; ++i) {
                            newCollection.add(new AbortedTransaction(_readable, _version, _context));
                        }
                        this.abortedTransactions = newCollection;
                    }
                }
            } else {
                this.abortedTransactions = new ArrayList<AbortedTransaction>(0);
            }
            this.preferredReadReplica = _version >= 11 ? _readable.readInt() : -1;
            int length = _version >= 12 ? _readable.readUnsignedVarint() - 1 : _readable.readInt();
            this.records = length < 0 ? null : _readable.readRecords(length);
            this._unknownTaggedFields = null;
            if (_version >= 12) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block7: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 0: {
                            this.divergingEpoch = new EpochEndOffset(_readable, _version, _context);
                            continue block7;
                        }
                        case 1: {
                            this.currentLeader = new LeaderIdAndEpoch(_readable, _version, _context);
                            continue block7;
                        }
                        case 2: {
                            this.snapshotId = new SnapshotId(_readable, _version, _context);
                            continue block7;
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.partitionIndex);
            _writable.writeShort(this.errorCode);
            _writable.writeLong(this.highWatermark);
            if (_version >= 4) {
                _writable.writeLong(this.lastStableOffset);
            }
            if (_version >= 5) {
                _writable.writeLong(this.logStartOffset);
            }
            if (_version >= 12) {
                if (!this.divergingEpoch.equals(new EpochEndOffset())) {
                    ++_numTaggedFields;
                }
            } else if (!this.divergingEpoch.equals(new EpochEndOffset())) {
                throw new UnsupportedVersionException("Attempted to write a non-default divergingEpoch at version " + _version);
            }
            if (_version >= 12) {
                if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                    ++_numTaggedFields;
                }
            } else if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                throw new UnsupportedVersionException("Attempted to write a non-default currentLeader at version " + _version);
            }
            if (_version >= 12) {
                if (!this.snapshotId.equals(new SnapshotId())) {
                    ++_numTaggedFields;
                }
            } else if (!this.snapshotId.equals(new SnapshotId())) {
                throw new UnsupportedVersionException("Attempted to write a non-default snapshotId at version " + _version);
            }
            if (_version >= 4) {
                if (_version >= 12) {
                    if (this.abortedTransactions == null) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeUnsignedVarint(this.abortedTransactions.size() + 1);
                        for (AbortedTransaction abortedTransactionsElement : this.abortedTransactions) {
                            abortedTransactionsElement.write(_writable, _cache, _version, _context);
                        }
                    }
                } else if (this.abortedTransactions == null) {
                    _writable.writeInt(-1);
                } else {
                    _writable.writeInt(this.abortedTransactions.size());
                    for (AbortedTransaction abortedTransactionsElement : this.abortedTransactions) {
                        abortedTransactionsElement.write(_writable, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 11) {
                _writable.writeInt(this.preferredReadReplica);
            } else if (this.preferredReadReplica != -1) {
                throw new UnsupportedVersionException("Attempted to write a non-default preferredReadReplica at version " + _version);
            }
            if (this.records == null) {
                if (_version >= 12) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeInt(-1);
                }
            } else {
                if (_version >= 12) {
                    _writable.writeUnsignedVarint(this.records.sizeInBytes() + 1);
                } else {
                    _writable.writeInt(this.records.sizeInBytes());
                }
                _writable.writeRecords(this.records);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 12) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                if (!this.divergingEpoch.equals(new EpochEndOffset())) {
                    _writable.writeUnsignedVarint(0);
                    _writable.writeUnsignedVarint(this.divergingEpoch.size(_cache, _version, _context));
                    this.divergingEpoch.write(_writable, _cache, _version, _context);
                }
                if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                    _writable.writeUnsignedVarint(1);
                    _writable.writeUnsignedVarint(this.currentLeader.size(_cache, _version, _context));
                    this.currentLeader.write(_writable, _cache, _version, _context);
                }
                if (!this.snapshotId.equals(new SnapshotId())) {
                    _writable.writeUnsignedVarint(2);
                    _writable.writeUnsignedVarint(this.snapshotId.size(_cache, _version, _context));
                    this.snapshotId.write(_writable, _cache, _version, _context);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _structSize;
            int _sizeBeforeStruct;
            int _numTaggedFields = 0;
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionData");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            _size.addBytes(8);
            if (_version >= 4) {
                _size.addBytes(8);
            }
            if (_version >= 5) {
                _size.addBytes(8);
            }
            if (_version >= 12 && !this.divergingEpoch.equals(new EpochEndOffset())) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _sizeBeforeStruct = _size.totalSize();
                this.divergingEpoch.addSize(_size, _cache, _version, _context);
                _structSize = _size.totalSize() - _sizeBeforeStruct;
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_structSize));
            }
            if (_version >= 12 && !this.currentLeader.equals(new LeaderIdAndEpoch())) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _sizeBeforeStruct = _size.totalSize();
                this.currentLeader.addSize(_size, _cache, _version, _context);
                _structSize = _size.totalSize() - _sizeBeforeStruct;
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_structSize));
            }
            if (_version >= 12 && !this.snapshotId.equals(new SnapshotId())) {
                ++_numTaggedFields;
                _size.addBytes(1);
                _sizeBeforeStruct = _size.totalSize();
                this.snapshotId.addSize(_size, _cache, _version, _context);
                _structSize = _size.totalSize() - _sizeBeforeStruct;
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_structSize));
            }
            if (_version >= 4) {
                if (this.abortedTransactions == null) {
                    if (_version >= 12) {
                        _size.addBytes(1);
                    } else {
                        _size.addBytes(4);
                    }
                } else {
                    if (_version >= 12) {
                        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.abortedTransactions.size() + 1)));
                    } else {
                        _size.addBytes(4);
                    }
                    for (AbortedTransaction abortedTransactionsElement : this.abortedTransactions) {
                        abortedTransactionsElement.addSize(_size, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 11) {
                _size.addBytes(4);
            }
            if (this.records == null) {
                if (_version >= 12) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(4);
                }
            } else {
                _size.addZeroCopyBytes(this.records.sizeInBytes());
                if (_version >= 12) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.records.sizeInBytes() + 1)));
                } else {
                    _size.addBytes(4);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionData)) {
                return false;
            }
            PartitionData other = (PartitionData)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.highWatermark != other.highWatermark) {
                return false;
            }
            if (this.lastStableOffset != other.lastStableOffset) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.divergingEpoch == null ? other.divergingEpoch != null : !this.divergingEpoch.equals(other.divergingEpoch)) {
                return false;
            }
            if (this.currentLeader == null ? other.currentLeader != null : !this.currentLeader.equals(other.currentLeader)) {
                return false;
            }
            if (this.snapshotId == null ? other.snapshotId != null : !this.snapshotId.equals(other.snapshotId)) {
                return false;
            }
            if (this.abortedTransactions == null ? other.abortedTransactions != null : !this.abortedTransactions.equals(other.abortedTransactions)) {
                return false;
            }
            if (this.preferredReadReplica != other.preferredReadReplica) {
                return false;
            }
            if (!Objects.equals(this.records, other.records)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.highWatermark >> 32) ^ (int)this.highWatermark);
            hashCode = 31 * hashCode + ((int)(this.lastStableOffset >> 32) ^ (int)this.lastStableOffset);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + (this.divergingEpoch == null ? 0 : this.divergingEpoch.hashCode());
            hashCode = 31 * hashCode + (this.currentLeader == null ? 0 : this.currentLeader.hashCode());
            hashCode = 31 * hashCode + (this.snapshotId == null ? 0 : this.snapshotId.hashCode());
            hashCode = 31 * hashCode + (this.abortedTransactions == null ? 0 : this.abortedTransactions.hashCode());
            hashCode = 31 * hashCode + this.preferredReadReplica;
            hashCode = 31 * hashCode + Objects.hashCode(this.records);
            return hashCode;
        }

        public PartitionData duplicate() {
            PartitionData _duplicate = new PartitionData();
            _duplicate.partitionIndex = this.partitionIndex;
            _duplicate.errorCode = this.errorCode;
            _duplicate.highWatermark = this.highWatermark;
            _duplicate.lastStableOffset = this.lastStableOffset;
            _duplicate.logStartOffset = this.logStartOffset;
            _duplicate.divergingEpoch = this.divergingEpoch.duplicate();
            _duplicate.currentLeader = this.currentLeader.duplicate();
            _duplicate.snapshotId = this.snapshotId.duplicate();
            if (this.abortedTransactions == null) {
                _duplicate.abortedTransactions = null;
            } else {
                ArrayList<AbortedTransaction> newAbortedTransactions = new ArrayList<AbortedTransaction>(this.abortedTransactions.size());
                for (AbortedTransaction _element : this.abortedTransactions) {
                    newAbortedTransactions.add(_element.duplicate());
                }
                _duplicate.abortedTransactions = newAbortedTransactions;
            }
            _duplicate.preferredReadReplica = this.preferredReadReplica;
            _duplicate.records = this.records == null ? null : MemoryRecords.readableRecords((ByteBuffer)((MemoryRecords)this.records).buffer().duplicate());
            return _duplicate;
        }

        public String toString() {
            return "PartitionData(partitionIndex=" + this.partitionIndex + ", errorCode=" + this.errorCode + ", highWatermark=" + this.highWatermark + ", lastStableOffset=" + this.lastStableOffset + ", logStartOffset=" + this.logStartOffset + ", divergingEpoch=" + this.divergingEpoch.toString() + ", currentLeader=" + this.currentLeader.toString() + ", snapshotId=" + this.snapshotId.toString() + ", abortedTransactions=" + (this.abortedTransactions == null ? "null" : MessageUtil.deepToString(this.abortedTransactions.iterator())) + ", preferredReadReplica=" + this.preferredReadReplica + ", records=" + this.records + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long highWatermark() {
            return this.highWatermark;
        }

        public long lastStableOffset() {
            return this.lastStableOffset;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public EpochEndOffset divergingEpoch() {
            return this.divergingEpoch;
        }

        public LeaderIdAndEpoch currentLeader() {
            return this.currentLeader;
        }

        public SnapshotId snapshotId() {
            return this.snapshotId;
        }

        public List<AbortedTransaction> abortedTransactions() {
            return this.abortedTransactions;
        }

        public int preferredReadReplica() {
            return this.preferredReadReplica;
        }

        public BaseRecords records() {
            return this.records;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionData setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public PartitionData setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionData setHighWatermark(long v) {
            this.highWatermark = v;
            return this;
        }

        public PartitionData setLastStableOffset(long v) {
            this.lastStableOffset = v;
            return this;
        }

        public PartitionData setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public PartitionData setDivergingEpoch(EpochEndOffset v) {
            this.divergingEpoch = v;
            return this;
        }

        public PartitionData setCurrentLeader(LeaderIdAndEpoch v) {
            this.currentLeader = v;
            return this;
        }

        public PartitionData setSnapshotId(SnapshotId v) {
            this.snapshotId = v;
            return this;
        }

        public PartitionData setAbortedTransactions(List<AbortedTransaction> v) {
            this.abortedTransactions = v;
            return this;
        }

        public PartitionData setPreferredReadReplica(int v) {
            this.preferredReadReplica = v;
            return this;
        }

        public PartitionData setRecords(BaseRecords v) {
            this.records = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("records", (Type)Type.RECORDS, "The record data.")})));
            SCHEMA_4 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("last_stable_offset", (Type)Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("aborted_transactions", (Type)ArrayOf.nullable((Type)AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("records", (Type)Type.RECORDS, "The record data.")});
            SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("last_stable_offset", (Type)Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("log_start_offset", (Type)Type.INT64, "The current log start offset."), new Field("aborted_transactions", (Type)ArrayOf.nullable((Type)AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("records", (Type)Type.RECORDS, "The record data.")})))));
            SCHEMA_11 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("last_stable_offset", (Type)Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("log_start_offset", (Type)Type.INT64, "The current log start offset."), new Field("aborted_transactions", (Type)ArrayOf.nullable((Type)AbortedTransaction.SCHEMA_4), "The aborted transactions."), new Field("preferred_read_replica", (Type)Type.INT32, "The preferred read replica for the consumer to use on its next fetch request"), new Field("records", (Type)Type.RECORDS, "The record data.")});
            SCHEMA_13 = SCHEMA_12 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("error_code", (Type)Type.INT16, "The error code, or 0 if there was no fetch error."), new Field("high_watermark", (Type)Type.INT64, "The current high water mark."), new Field("last_stable_offset", (Type)Type.INT64, "The last stable offset (or LSO) of the partition. This is the last offset such that the state of all transactional records prior to this offset have been decided (ABORTED or COMMITTED)"), new Field("log_start_offset", (Type)Type.INT64, "The current log start offset."), new Field("aborted_transactions", (Type)CompactArrayOf.nullable((Type)AbortedTransaction.SCHEMA_12), "The aborted transactions."), new Field("preferred_read_replica", (Type)Type.INT32, "The preferred read replica for the consumer to use on its next fetch request"), new Field("records", (Type)Type.COMPACT_RECORDS, "The record data."), Field.TaggedFieldsSection.of((Object[])new Object[]{0, new Field("diverging_epoch", (Type)EpochEndOffset.SCHEMA_12, "In case divergence is detected based on the `LastFetchedEpoch` and `FetchOffset` in the request, this field indicates the largest epoch and its end offset such that subsequent records are known to diverge"), 1, new Field("current_leader", (Type)LeaderIdAndEpoch.SCHEMA_12, ""), 2, new Field("snapshot_id", (Type)SnapshotId.SCHEMA_12, "In the case of fetching an offset less than the LogStartOffset, this is the end offset and epoch that should be used in the FetchSnapshot request.")})});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12, SCHEMA_13};
        }
    }

    public static class FetchableTopicResponse
    implements Message {
        String topic;
        Uuid topicId;
        List<PartitionData> partitions;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema SCHEMA_12;
        public static final Schema SCHEMA_13;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 13;

        public FetchableTopicResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public FetchableTopicResponse() {
            this.topic = "";
            this.topicId = Uuid.ZERO_UUID;
            this.partitions = new ArrayList<PartitionData>(0);
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 13;
        }

        public void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<PartitionData> newCollection;
            int arrayLength;
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of FetchableTopicResponse");
            }
            if (_version <= 12) {
                int length = _version >= 12 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
                if (length < 0) {
                    throw new RuntimeException("non-nullable field topic was serialized as null");
                }
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field topic had invalid length " + length);
                }
                this.topic = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            } else {
                this.topic = "";
            }
            this.topicId = _version >= 13 ? _readable.readUuid() : Uuid.ZERO_UUID;
            if (_version >= 12) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionData(_readable, _version, _context));
                }
                this.partitions = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitions was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<PartitionData>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionData(_readable, _version, _context));
                }
                this.partitions = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 12) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            Object _stringBytes;
            int _numTaggedFields = 0;
            if (_version <= 12) {
                _stringBytes = _cache.getSerializedValue((Object)this.topic);
                if (_version >= 12) {
                    _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
                } else {
                    _writable.writeShort((short)((byte[])_stringBytes).length);
                }
                _writable.writeByteArray((byte[])_stringBytes);
            }
            if (_version >= 13) {
                _writable.writeUuid(this.topicId);
            }
            if (_version >= 12) {
                _writable.writeUnsignedVarint(this.partitions.size() + 1);
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitions.size());
                _stringBytes = this.partitions.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionData partitionsElement = (PartitionData)_stringBytes.next();
                    partitionsElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 12) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 13) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of FetchableTopicResponse");
            }
            if (_version <= 12) {
                byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.topic).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'topic' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.topic, _stringBytes);
                if (_version >= 12) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (_version >= 13) {
                _size.addBytes(16);
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.partitions.size() + 1)));
            } else {
                _size.addBytes(4);
            }
            for (PartitionData partitionsElement : this.partitions) {
                partitionsElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 12) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FetchableTopicResponse)) {
                return false;
            }
            FetchableTopicResponse other = (FetchableTopicResponse)obj;
            if (this.topic == null ? other.topic != null : !this.topic.equals(other.topic)) {
                return false;
            }
            if (!this.topicId.equals((Object)other.topicId)) {
                return false;
            }
            if (this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.topic == null ? 0 : this.topic.hashCode());
            hashCode = 31 * hashCode + this.topicId.hashCode();
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public FetchableTopicResponse duplicate() {
            FetchableTopicResponse _duplicate = new FetchableTopicResponse();
            _duplicate.topic = this.topic;
            _duplicate.topicId = this.topicId;
            ArrayList<PartitionData> newPartitions = new ArrayList<PartitionData>(this.partitions.size());
            for (PartitionData _element : this.partitions) {
                newPartitions.add(_element.duplicate());
            }
            _duplicate.partitions = newPartitions;
            return _duplicate;
        }

        public String toString() {
            return "FetchableTopicResponse(topic=" + (this.topic == null ? "null" : "'" + this.topic.toString() + "'") + ", topicId=" + this.topicId.toString() + ", partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String topic() {
            return this.topic;
        }

        public Uuid topicId() {
            return this.topicId;
        }

        public List<PartitionData> partitions() {
            return this.partitions;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public FetchableTopicResponse setTopic(String v) {
            this.topic = v;
            return this;
        }

        public FetchableTopicResponse setTopicId(Uuid v) {
            this.topicId = v;
            return this;
        }

        public FetchableTopicResponse setPartitions(List<PartitionData> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_3 = SCHEMA_2 = (SCHEMA_1 = (SCHEMA_0 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)PartitionData.SCHEMA_0), "The topic partitions.")})));
            SCHEMA_4 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)PartitionData.SCHEMA_4), "The topic partitions.")});
            SCHEMA_10 = SCHEMA_9 = (SCHEMA_8 = (SCHEMA_7 = (SCHEMA_6 = (SCHEMA_5 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)PartitionData.SCHEMA_5), "The topic partitions.")})))));
            SCHEMA_11 = new Schema(new Field[]{new Field("topic", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)PartitionData.SCHEMA_11), "The topic partitions.")});
            SCHEMA_12 = new Schema(new Field[]{new Field("topic", (Type)Type.COMPACT_STRING, "The topic name."), new Field("partitions", (Type)new CompactArrayOf((Type)PartitionData.SCHEMA_12), "The topic partitions."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMA_13 = new Schema(new Field[]{new Field("topic_id", (Type)Type.UUID, "The unique topic ID"), new Field("partitions", (Type)new CompactArrayOf((Type)PartitionData.SCHEMA_12), "The topic partitions."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11, SCHEMA_12, SCHEMA_13};
        }
    }
}

