/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class RequestHeaderData
implements ApiMessage {
    short requestApiKey;
    short requestApiVersion;
    int correlationId;
    String clientId;
    Uuid clusterLinkId;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("request_api_key", (Type)Type.INT16, "The API key of this request."), new Field("request_api_version", (Type)Type.INT16, "The API version of this request."), new Field("correlation_id", (Type)Type.INT32, "The correlation ID of this request.")});
    public static final Schema SCHEMA_1 = new Schema(new Field[]{new Field("request_api_key", (Type)Type.INT16, "The API key of this request."), new Field("request_api_version", (Type)Type.INT16, "The API version of this request."), new Field("correlation_id", (Type)Type.INT32, "The correlation ID of this request."), new Field("client_id", (Type)Type.NULLABLE_STRING, "The client ID string.")});
    public static final Schema SCHEMA_2 = new Schema(new Field[]{new Field("request_api_key", (Type)Type.INT16, "The API key of this request."), new Field("request_api_version", (Type)Type.INT16, "The API version of this request."), new Field("correlation_id", (Type)Type.INT32, "The correlation ID of this request."), new Field("client_id", (Type)Type.NULLABLE_STRING, "The client ID string."), Field.TaggedFieldsSection.of((Object[])new Object[]{10000, new Field("cluster_link_id", (Type)Type.UUID, "Cluster link ID if this request was sent on a cluster link.")})});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 2;

    public RequestHeaderData(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public RequestHeaderData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public RequestHeaderData() {
        this.requestApiKey = 0;
        this.requestApiVersion = 0;
        this.correlationId = 0;
        this.clientId = "";
        this.clusterLinkId = Uuid.ZERO_UUID;
    }

    public short apiKey() {
        return -1;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 2;
    }

    public void read(Readable _readable, short _version, MessageContext _context) {
        this.requestApiKey = _readable.readShort();
        this.requestApiVersion = _readable.readShort();
        this.correlationId = _readable.readInt();
        if (_version >= 1) {
            short length = _readable.readShort();
            if (length < 0) {
                this.clientId = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field clientId had invalid length " + length);
                }
                this.clientId = _readable.readString((int)length);
            }
        } else {
            this.clientId = "";
        }
        this.clusterLinkId = Uuid.ZERO_UUID;
        this._unknownTaggedFields = null;
        if (_version >= 2) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block3: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 10000: {
                        this.clusterLinkId = _readable.readUuid();
                        continue block3;
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _writable.writeShort(this.requestApiKey);
        _writable.writeShort(this.requestApiVersion);
        _writable.writeInt(this.correlationId);
        if (_version >= 1) {
            if (this.clientId == null) {
                _writable.writeShort((short)-1);
            } else {
                byte[] _stringBytes = _cache.getSerializedValue((Object)this.clientId);
                _writable.writeShort((short)_stringBytes.length);
                _writable.writeByteArray(_stringBytes);
            }
        }
        if (_version >= 2 && !this.clusterLinkId.equals((Object)Uuid.ZERO_UUID)) {
            ++_numTaggedFields;
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 2) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            _rawWriter.writeRawTags(_writable, 10000);
            if (!this.clusterLinkId.equals((Object)Uuid.ZERO_UUID)) {
                _writable.writeUnsignedVarint(10000);
                _writable.writeUnsignedVarint(16);
                _writable.writeUuid(this.clusterLinkId);
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        _size.addBytes(2);
        _size.addBytes(2);
        _size.addBytes(4);
        if (_version >= 1) {
            if (this.clientId == null) {
                _size.addBytes(2);
            } else {
                byte[] _stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'clientId' field is too long to be serialized");
                }
                _cache.cacheSerializedValue((Object)this.clientId, _stringBytes);
                _size.addBytes(_stringBytes.length + 2);
            }
        }
        if (_version >= 2 && !this.clusterLinkId.equals((Object)Uuid.ZERO_UUID)) {
            ++_numTaggedFields;
            _size.addBytes(2);
            _size.addBytes(1);
            _size.addBytes(16);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 2) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RequestHeaderData)) {
            return false;
        }
        RequestHeaderData other = (RequestHeaderData)obj;
        if (this.requestApiKey != other.requestApiKey) {
            return false;
        }
        if (this.requestApiVersion != other.requestApiVersion) {
            return false;
        }
        if (this.correlationId != other.correlationId) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (!this.clusterLinkId.equals((Object)other.clusterLinkId)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + this.requestApiKey;
        hashCode = 31 * hashCode + this.requestApiVersion;
        hashCode = 31 * hashCode + this.correlationId;
        hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
        hashCode = 31 * hashCode + this.clusterLinkId.hashCode();
        return hashCode;
    }

    public RequestHeaderData duplicate() {
        RequestHeaderData _duplicate = new RequestHeaderData();
        _duplicate.requestApiKey = this.requestApiKey;
        _duplicate.requestApiVersion = this.requestApiVersion;
        _duplicate.correlationId = this.correlationId;
        _duplicate.clientId = this.clientId == null ? null : this.clientId;
        _duplicate.clusterLinkId = this.clusterLinkId;
        return _duplicate;
    }

    public String toString() {
        return "RequestHeaderData(requestApiKey=" + this.requestApiKey + ", requestApiVersion=" + this.requestApiVersion + ", correlationId=" + this.correlationId + ", clientId=" + (this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clusterLinkId=" + this.clusterLinkId.toString() + ")";
    }

    public short requestApiKey() {
        return this.requestApiKey;
    }

    public short requestApiVersion() {
        return this.requestApiVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public String clientId() {
        return this.clientId;
    }

    public Uuid clusterLinkId() {
        return this.clusterLinkId;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public RequestHeaderData setRequestApiKey(short v) {
        this.requestApiKey = v;
        return this;
    }

    public RequestHeaderData setRequestApiVersion(short v) {
        this.requestApiVersion = v;
        return this;
    }

    public RequestHeaderData setCorrelationId(int v) {
        this.correlationId = v;
        return this;
    }

    public RequestHeaderData setClientId(String v) {
        this.clientId = v;
        return this;
    }

    public RequestHeaderData setClusterLinkId(Uuid v) {
        this.clusterLinkId = v;
        return this;
    }
}

