/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.internals;

import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.internals.GaugeSuite;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaugeSuiteTest {
    private static final Logger log = LoggerFactory.getLogger(GaugeSuiteTest.class);

    private static GaugeSuite<String, Integer> createGaugeMap() {
        MetricConfig config = new MetricConfig();
        Metrics metrics = new Metrics(config);
        GaugeSuite suite = new GaugeSuite(log, "mySuite", metrics, name -> new MetricName(name, "group", "myMetric", Collections.emptyMap()));
        return suite;
    }

    @Test
    public void testCreateAndClose() {
        GaugeSuite<String, Integer> suite = GaugeSuiteTest.createGaugeMap();
        suite.close();
        suite.close();
        suite.metrics().close();
    }

    @Test
    public void testCreateMetrics() {
        GaugeSuite<String, Integer> suite = GaugeSuiteTest.createGaugeMap();
        suite.update((Object)"foo", (Object)10);
        Map values = suite.values();
        Assertions.assertEquals((Integer)10, (Integer)((Integer)values.get("foo")));
        Assertions.assertEquals((Integer)10, (Integer)this.metricValue(suite.metrics(), "foo"));
        Assertions.assertEquals((int)1, (int)values.size());
        suite.update((Object)"foo", (Object)5);
        suite.update((Object)"bar", (Object)6);
        suite.update((Object)"baz", (Object)7);
        suite.update((Object)"quux", (Object)8);
        values = suite.values();
        Assertions.assertEquals((Integer)5, (Integer)((Integer)values.get("foo")));
        Assertions.assertEquals((Integer)6, (Integer)((Integer)values.get("bar")));
        Assertions.assertEquals((Integer)7, (Integer)((Integer)values.get("baz")));
        Assertions.assertEquals((Integer)8, (Integer)((Integer)values.get("quux")));
        Assertions.assertEquals((Integer)5, (Integer)this.metricValue(suite.metrics(), "foo"));
        Assertions.assertEquals((Integer)6, (Integer)this.metricValue(suite.metrics(), "bar"));
        Assertions.assertEquals((Integer)7, (Integer)this.metricValue(suite.metrics(), "baz"));
        Assertions.assertEquals((Integer)8, (Integer)this.metricValue(suite.metrics(), "quux"));
        Assertions.assertEquals((int)4, (int)values.size());
        suite.close();
        suite.metrics().close();
    }

    @Test
    public void testCreateAndRemoveMetrics() {
        GaugeSuite<String, Integer> suite = GaugeSuiteTest.createGaugeMap();
        suite.update((Object)"foo", (Object)5);
        suite.update((Object)"bar", (Object)6);
        suite.remove((Object)"foo");
        suite.remove((Object)"bar");
        suite.update((Object)"baz", (Object)7);
        suite.update((Object)"quux", (Object)8);
        Map values = suite.values();
        Assertions.assertFalse((boolean)values.containsKey("foo"));
        Assertions.assertFalse((boolean)values.containsKey("bar"));
        Assertions.assertEquals((Integer)7, (Integer)((Integer)values.get("baz")));
        Assertions.assertEquals((Integer)8, (Integer)((Integer)values.get("quux")));
        Assertions.assertNull((Object)this.metricValue(suite.metrics(), "foo"));
        Assertions.assertNull((Object)this.metricValue(suite.metrics(), "bar"));
        Assertions.assertEquals((Integer)7, (Integer)this.metricValue(suite.metrics(), "baz"));
        Assertions.assertEquals((Integer)8, (Integer)this.metricValue(suite.metrics(), "quux"));
        Assertions.assertEquals((int)2, (int)values.size());
        suite.close();
        suite.metrics().close();
    }

    private Integer metricValue(Metrics metrics, String name) {
        MetricName metricName = metrics.metricName(name, "group", "", Collections.emptyMap());
        KafkaMetric metric = metrics.metric(metricName);
        if (metric != null) {
            return (Integer)metric.metricValue();
        }
        return null;
    }
}

