/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import org.apache.kafka.common.network.PublicCredential;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class PublicCredentialTest {
    @Test
    public void testCredentialEquals() {
        PublicCredential cred1 = PublicCredential.authenticatedCredential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN");
        Assertions.assertEquals((Object)cred1, (Object)PublicCredential.authenticatedCredential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user2", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, null));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential((String)"user1", null, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN"));
        Assertions.assertNotEquals((Object)cred1, (Object)PublicCredential.credential(null, null, null));
    }

    @Test
    public void testCredentialMatches() {
        PublicCredential cred1 = PublicCredential.authenticatedCredential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN");
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.credential((String)"user2", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, null)));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.saslCredential((String)"user1", (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.saslCredential((String)"user2", (String)"PLAIN")));
        Assertions.assertFalse((boolean)cred1.matches(PublicCredential.saslCredential((String)"user1", (String)"OAUTHBEARER")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.saslCredential((String)"user1", null)));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential((String)"user1", null, (String)"PLAIN")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN")));
        Assertions.assertTrue((boolean)cred1.matches(PublicCredential.credential(null, null, null)));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)"user2", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_PLAINTEXT, (String)"PLAIN").matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"OAUTHBEARER").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential((String)"user1", (SecurityProtocol)SecurityProtocol.SASL_SSL, null).matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.saslCredential((String)"user2", (String)"PLAIN").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.saslCredential((String)"user1", (String)"PLAIN").matches(cred1));
        Assertions.assertFalse((boolean)PublicCredential.saslCredential((String)"user1", (String)"OAUTHBEARER").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.saslCredential((String)"user1", null).matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential((String)"user1", null, (String)"PLAIN").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential(null, (SecurityProtocol)SecurityProtocol.SASL_SSL, (String)"PLAIN").matches(cred1));
        Assertions.assertTrue((boolean)PublicCredential.credential(null, null, null).matches(cred1));
    }
}

