/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Iterator;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ControlledShutdownRequestData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ControlledShutdownRequest;
import org.apache.kafka.common.requests.ControlledShutdownResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ControlledShutdownRequestTest {
    @Test
    public void testUnsupportedVersion() {
        ControlledShutdownRequest.Builder builder = new ControlledShutdownRequest.Builder(new ControlledShutdownRequestData().setBrokerId(1), (short)(ApiKeys.CONTROLLED_SHUTDOWN.latestVersion() + 1));
        Assertions.assertThrows(UnsupportedVersionException.class, () -> ((ControlledShutdownRequest.Builder)builder).build());
    }

    @Test
    public void testGetErrorResponse() {
        Iterator iterator = ApiKeys.CONTROLLED_SHUTDOWN.allVersions().iterator();
        while (iterator.hasNext()) {
            short version = (Short)iterator.next();
            ControlledShutdownRequest.Builder builder = new ControlledShutdownRequest.Builder(new ControlledShutdownRequestData().setBrokerId(1), version);
            ControlledShutdownRequest request = (ControlledShutdownRequest)builder.build();
            ControlledShutdownResponse response = request.getErrorResponse(0, (Throwable)new ClusterAuthorizationException("Not authorized"));
            Assertions.assertEquals((Object)Errors.CLUSTER_AUTHORIZATION_FAILED, (Object)response.error());
        }
    }

    @Test
    public void testDefaultReason() {
        ControlledShutdownRequest.Builder builder = new ControlledShutdownRequest.Builder(new ControlledShutdownRequestData().setBrokerId(1), ApiKeys.CONTROLLED_SHUTDOWN.latestVersion());
        ControlledShutdownRequest request = (ControlledShutdownRequest)builder.build();
        Assertions.assertEquals((byte)0, (byte)request.data().reason());
    }

    @Test
    public void testSettingReason() {
        ControlledShutdownRequest.Builder builder = new ControlledShutdownRequest.Builder(new ControlledShutdownRequestData().setBrokerId(1).setReason((byte)2), ApiKeys.CONTROLLED_SHUTDOWN.latestVersion());
        ControlledShutdownRequest request = (ControlledShutdownRequest)builder.build();
        Assertions.assertEquals((byte)2, (byte)request.data().reason());
    }
}

