/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.network.ClientInformation;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.requests.DetailedRequestAuditLogFilter;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.MockTime;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DetailedRequestAuditLogFilterTest {
    private final MockTime time = new MockTime();

    @Test
    public void testDefaultConfig() {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        HashMap configs = new HashMap();
        filter.configure(configs);
        DetailedRequestAuditLogFilter.SUPPORTED_APIS.forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, request.time).shouldLog());
        });
        Arrays.stream(ApiKeys.values()).filter(key -> !DetailedRequestAuditLogFilter.SUPPORTED_APIS.contains(key)).forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, request.time).shouldLog());
        });
    }

    @Test
    public void testWithEnableDetailedAuditLogs() {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.security.event.logger.enable.detailed.audit.logs", "true");
        filter.configure(configs);
        DetailedRequestAuditLogFilter.SUPPORTED_APIS.forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertTrue((boolean)filter.processRequest(request.context, request.time).shouldLog());
        });
        Arrays.stream(ApiKeys.values()).filter(key -> !DetailedRequestAuditLogFilter.SUPPORTED_APIS.contains(key)).forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, request.time).shouldLog());
        });
    }

    @Test
    public void testDisabledApiConfig() {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        EnumSet<ApiKeys> disabledAPIs = EnumSet.of(ApiKeys.DELETE_TOPICS, ApiKeys.CREATE_CLUSTER_LINKS, ApiKeys.ALTER_CONFIGS);
        String disabledAPIsConfig = disabledAPIs.stream().map(key -> key.name).collect(Collectors.joining(","));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("confluent.security.event.logger.enable.detailed.audit.logs", "true");
        configs.put("confluent.security.event.logger.detailed.audit.logs.disabled.apis", disabledAPIsConfig);
        filter.configure(configs);
        DetailedRequestAuditLogFilter.SUPPORTED_APIS.stream().filter(key -> !disabledAPIs.contains(key)).forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertTrue((boolean)filter.processRequest(request.context, request.time).shouldLog());
        });
        disabledAPIs.forEach(apiKey -> {
            Request request = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request.context, request.time).shouldLog());
        });
        Arrays.stream(ApiKeys.values()).filter(key -> !DetailedRequestAuditLogFilter.SUPPORTED_APIS.contains(key)).forEach(apiKey -> {
            Request request1 = new Request(this.newRequestContext((ApiKeys)apiKey), this.time.nanoseconds());
            Assertions.assertFalse((boolean)filter.processRequest(request1.context, request1.time).shouldLog());
        });
    }

    @Test
    public void testInvalidDefaultConfigs() {
        this.assertThrowsConfigException(Collections.singletonMap("confluent.security.event.logger.detailed.audit.logs.disabled.apis", "UnknownAPI"));
        this.assertThrowsConfigException(Collections.singletonMap("confluent.security.event.logger.detailed.audit.logs.disabled.apis", "CreateTopics,UnknownAPI"));
    }

    private void assertThrowsConfigException(Map<String, ?> configs) {
        DetailedRequestAuditLogFilter filter = new DetailedRequestAuditLogFilter();
        Assertions.assertThrows(ConfigException.class, () -> filter.validateReconfiguration(configs));
        Assertions.assertThrows(ConfigException.class, () -> filter.configure(configs));
        Assertions.assertThrows(ConfigException.class, () -> filter.reconfigure(configs));
    }

    private RequestContext newRequestContext(ApiKeys apiKey) {
        RequestHeader header = new RequestHeader(apiKey, apiKey.latestVersion(), "clientId", 1);
        return new RequestContext(header, "cxnId", InetAddress.getLoopbackAddress(), KafkaPrincipal.ANONYMOUS, new ListenerName("PLAINTEXT"), SecurityProtocol.PLAINTEXT, ClientInformation.EMPTY, null, false, Optional.empty());
    }

    private static class Request {
        private final RequestContext context;
        private final long time;

        private Request(RequestContext context, long time) {
            this.context = context;
            this.time = time;
        }
    }
}

