/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.record.RecordBatch;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.requests.RequestUtils;
import org.apache.kafka.common.requests.ResponseHeader;

public class RequestTestUtils {
    public static boolean hasIdempotentRecords(ProduceRequest request) {
        return RequestUtils.flag((ProduceRequest)request, RecordBatch::hasProducerId);
    }

    public static ByteBuffer serializeRequestHeader(RequestHeader header) {
        ObjectSerializationCache serializationCache = new ObjectSerializationCache();
        ByteBuffer buffer = ByteBuffer.allocate(header.size(serializationCache));
        header.write(buffer, serializationCache);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer serializeResponseWithHeader(AbstractResponse response, short version, int correlationId) {
        return response.serializeWithHeader(new ResponseHeader(correlationId, response.apiKey().responseHeaderVersion(version)), version);
    }

    public static MetadataResponse metadataResponse(Collection<Node> brokers, String clusterId, int controllerId, List<MetadataResponse.TopicMetadata> topicMetadataList) {
        return RequestTestUtils.metadataResponse(brokers, clusterId, controllerId, topicMetadataList, ApiKeys.METADATA.latestVersion());
    }

    public static MetadataResponse metadataResponse(Collection<Node> brokers, String clusterId, int controllerId, List<MetadataResponse.TopicMetadata> topicMetadataList, short responseVersion) {
        return RequestTestUtils.metadataResponse(0, brokers, clusterId, controllerId, topicMetadataList, Integer.MIN_VALUE, responseVersion);
    }

    public static MetadataResponse metadataResponse(int throttleTimeMs, Collection<Node> brokers, String clusterId, int controllerId, List<MetadataResponse.TopicMetadata> topicMetadatas, int clusterAuthorizedOperations, short responseVersion) {
        ArrayList topics = new ArrayList();
        topicMetadatas.forEach(topicMetadata -> {
            MetadataResponseData.MetadataResponseTopic metadataResponseTopic = new MetadataResponseData.MetadataResponseTopic();
            metadataResponseTopic.setErrorCode(topicMetadata.error().code()).setName(topicMetadata.topic()).setTopicId(topicMetadata.topicId()).setIsInternal(topicMetadata.isInternal()).setTopicAuthorizedOperations(topicMetadata.authorizedOperations());
            for (MetadataResponse.PartitionMetadata partitionMetadata : topicMetadata.partitionMetadata()) {
                metadataResponseTopic.partitions().add(new MetadataResponseData.MetadataResponsePartition().setErrorCode(partitionMetadata.error.code()).setPartitionIndex(partitionMetadata.partition()).setLeaderId(partitionMetadata.leaderId.orElse(-1)).setLeaderEpoch(partitionMetadata.leaderEpoch.orElse(-1)).setReplicaNodes(partitionMetadata.replicaIds).setIsrNodes(partitionMetadata.inSyncReplicaIds).setObservers(partitionMetadata.observerIds).setOfflineReplicas(partitionMetadata.offlineReplicaIds));
            }
            topics.add(metadataResponseTopic);
        });
        return MetadataResponse.prepareResponse((short)responseVersion, (int)throttleTimeMs, brokers, (String)clusterId, (int)controllerId, topics, (int)clusterAuthorizedOperations);
    }

    public static MetadataResponse metadataUpdateWith(int numNodes, Map<String, Integer> topicPartitionCounts) {
        return RequestTestUtils.metadataUpdateWith("kafka-cluster", numNodes, topicPartitionCounts);
    }

    public static MetadataResponse metadataUpdateWith(int numNodes, Map<String, Integer> topicPartitionCounts, Function<TopicPartition, Integer> epochSupplier) {
        return RequestTestUtils.metadataUpdateWith("kafka-cluster", numNodes, Collections.emptyMap(), topicPartitionCounts, epochSupplier, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
    }

    public static MetadataResponse metadataUpdateWith(String clusterId, int numNodes, Map<String, Integer> topicPartitionCounts) {
        return RequestTestUtils.metadataUpdateWith(clusterId, numNodes, Collections.emptyMap(), topicPartitionCounts, tp -> null, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
    }

    public static MetadataResponse metadataUpdateWith(String clusterId, int numNodes, Map<String, Errors> topicErrors, Map<String, Integer> topicPartitionCounts) {
        return RequestTestUtils.metadataUpdateWith(clusterId, numNodes, topicErrors, topicPartitionCounts, tp -> null, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
    }

    public static MetadataResponse metadataUpdateWith(String clusterId, int numNodes, Map<String, Errors> topicErrors, Map<String, Integer> topicPartitionCounts, short responseVersion) {
        return RequestTestUtils.metadataUpdateWith(clusterId, numNodes, topicErrors, topicPartitionCounts, tp -> null, MetadataResponse.PartitionMetadata::new, responseVersion, Collections.emptyMap());
    }

    public static MetadataResponse metadataUpdateWith(String clusterId, int numNodes, Map<String, Errors> topicErrors, Map<String, Integer> topicPartitionCounts, Function<TopicPartition, Integer> epochSupplier) {
        return RequestTestUtils.metadataUpdateWith(clusterId, numNodes, topicErrors, topicPartitionCounts, epochSupplier, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), Collections.emptyMap());
    }

    public static MetadataResponse metadataUpdateWithIds(int numNodes, Map<String, Integer> topicPartitionCounts, Map<String, Uuid> topicIds) {
        return RequestTestUtils.metadataUpdateWith("kafka-cluster", numNodes, Collections.emptyMap(), topicPartitionCounts, tp -> null, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), topicIds);
    }

    public static MetadataResponse metadataUpdateWithIds(int numNodes, Set<TopicIdPartition> partitions, Function<TopicPartition, Integer> epochSupplier) {
        HashMap<String, Integer> topicPartitionCounts = new HashMap<String, Integer>();
        HashMap<String, Uuid> topicIds = new HashMap<String, Uuid>();
        partitions.forEach(partition -> {
            topicPartitionCounts.compute(partition.topic(), (key, value) -> value == null ? 1 : value + 1);
            topicIds.putIfAbsent(partition.topic(), partition.topicId());
        });
        return RequestTestUtils.metadataUpdateWithIds(numNodes, topicPartitionCounts, epochSupplier, topicIds);
    }

    public static MetadataResponse metadataUpdateWithIds(int numNodes, Map<String, Integer> topicPartitionCounts, Function<TopicPartition, Integer> epochSupplier, Map<String, Uuid> topicIds) {
        return RequestTestUtils.metadataUpdateWith("kafka-cluster", numNodes, Collections.emptyMap(), topicPartitionCounts, epochSupplier, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), topicIds);
    }

    public static MetadataResponse metadataUpdateWithIds(int numNodes, Map<String, Integer> topicPartitionCounts, Function<TopicPartition, Integer> epochSupplier, Map<String, Uuid> topicIds, Boolean leaderOnly) {
        return RequestTestUtils.metadataUpdateWith("kafka-cluster", numNodes, Collections.emptyMap(), topicPartitionCounts, epochSupplier, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), topicIds, leaderOnly);
    }

    public static MetadataResponse metadataUpdateWithIds(String clusterId, int numNodes, Map<String, Errors> topicErrors, Map<String, Integer> topicPartitionCounts, Function<TopicPartition, Integer> epochSupplier, Map<String, Uuid> topicIds) {
        return RequestTestUtils.metadataUpdateWith(clusterId, numNodes, topicErrors, topicPartitionCounts, epochSupplier, MetadataResponse.PartitionMetadata::new, ApiKeys.METADATA.latestVersion(), topicIds);
    }

    public static MetadataResponse metadataUpdateWith(String clusterId, int numNodes, Map<String, Errors> topicErrors, Map<String, Integer> topicPartitionCounts, Function<TopicPartition, Integer> epochSupplier, PartitionMetadataSupplier partitionSupplier, short responseVersion, Map<String, Uuid> topicIds) {
        return RequestTestUtils.metadataUpdateWith(clusterId, numNodes, topicErrors, topicPartitionCounts, epochSupplier, partitionSupplier, responseVersion, topicIds, true);
    }

    public static MetadataResponse metadataUpdateWith(String clusterId, int numNodes, Map<String, Errors> topicErrors, Map<String, Integer> topicPartitionCounts, Function<TopicPartition, Integer> epochSupplier, PartitionMetadataSupplier partitionSupplier, short responseVersion, Map<String, Uuid> topicIds, Boolean leaderOnly) {
        String topic;
        ArrayList<Node> nodes = new ArrayList<Node>(numNodes);
        for (int i = 0; i < numNodes; ++i) {
            nodes.add(new Node(i, "localhost", 1969 + i));
        }
        ArrayList<MetadataResponse.TopicMetadata> topicMetadata = new ArrayList<MetadataResponse.TopicMetadata>();
        for (Map.Entry<String, Integer> entry : topicPartitionCounts.entrySet()) {
            topic = entry.getKey();
            int numPartitions = entry.getValue();
            ArrayList<MetadataResponse.PartitionMetadata> partitionMetadata = new ArrayList<MetadataResponse.PartitionMetadata>(numPartitions);
            for (int i = 0; i < numPartitions; ++i) {
                TopicPartition tp = new TopicPartition(topic, i);
                Node leader = (Node)nodes.get(i % nodes.size());
                List<Integer> replicaIds = leaderOnly != false ? Collections.singletonList(leader.id()) : nodes.stream().map(Node::id).collect(Collectors.toList());
                partitionMetadata.add(partitionSupplier.supply(Errors.NONE, tp, Optional.of(leader.id()), Optional.ofNullable(epochSupplier.apply(tp)), replicaIds, Collections.emptyList(), replicaIds, Collections.emptyList()));
            }
            topicMetadata.add(new MetadataResponse.TopicMetadata(Errors.NONE, topic, topicIds.getOrDefault(topic, Uuid.ZERO_UUID), Topic.isInternal((String)topic), partitionMetadata, Integer.MIN_VALUE));
        }
        for (Map.Entry<String, Integer> entry : topicErrors.entrySet()) {
            topic = entry.getKey();
            topicMetadata.add(new MetadataResponse.TopicMetadata((Errors)entry.getValue(), topic, Topic.isInternal((String)topic), Collections.emptyList()));
        }
        return RequestTestUtils.metadataResponse(nodes, clusterId, 0, topicMetadata, responseVersion);
    }

    public static Map<TopicIdPartition, FetchRequestData.FetchPartition> fetchPartitionMap(FetchRequestData fetchRequest, Short version, Map<Uuid, String> topicNames) {
        HashMap<TopicIdPartition, FetchRequestData.FetchPartition> result = new HashMap<TopicIdPartition, FetchRequestData.FetchPartition>();
        fetchRequest.topics().stream().forEach(topic -> {
            String name = version < 13 ? topic.topic() : (String)topicNames.get(topic.topicId());
            topic.partitions().stream().forEach(partition -> result.put(new TopicIdPartition(topic.topicId(), partition.partition(), name), (FetchRequestData.FetchPartition)partition));
        });
        return result;
    }

    @FunctionalInterface
    public static interface PartitionMetadataSupplier {
        public MetadataResponse.PartitionMetadata supply(Errors var1, TopicPartition var2, Optional<Integer> var3, Optional<Integer> var4, List<Integer> var5, List<Integer> var6, List<Integer> var7, List<Integer> var8);
    }
}

