/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import org.apache.kafka.common.message.TriggerEvenClusterLoadResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadRequest;
import org.apache.kafka.common.requests.TriggerEvenClusterLoadResponse;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TriggerEvenClusterLoadResponseTest {
    @Test
    public void testErrorCounts() {
        TriggerEvenClusterLoadRequest request = (TriggerEvenClusterLoadRequest)new TriggerEvenClusterLoadRequest.Builder().build();
        TriggerEvenClusterLoadResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assertions.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 1), (Object)response.errorCounts());
    }

    @Test
    public void testResponseFields() {
        TriggerEvenClusterLoadResponse response = new TriggerEvenClusterLoadResponse(new TriggerEvenClusterLoadResponseData().setErrorCode(Errors.BALANCER_OPERATION_OVERRIDDEN.code()).setErrorMessage(Errors.BALANCER_OPERATION_OVERRIDDEN.message()));
        Assertions.assertEquals((short)Errors.BALANCER_OPERATION_OVERRIDDEN.code(), (short)response.data().errorCode());
        Assertions.assertEquals((Object)Errors.BALANCER_OPERATION_OVERRIDDEN.message(), (Object)response.data().errorMessage());
    }
}

