/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.security.ssl;

import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.security.ssl.NettySslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.SslFactoryTest;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.test.TestSslUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class NettySslFactoryTest
extends SslFactoryTest {
    public NettySslFactoryTest(String tlsProtocol) {
        super(tlsProtocol, NettySslEngineFactory.class);
    }

    @Override
    @Test
    public void testSslFactoryConfiguration() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = this.sslConfigsBuilder(Mode.SERVER).createNewTrustStore(trustStoreFile).build();
        this.configureSslBuilderClass(serverSslConfig);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assertions.assertNotNull((Object)engine);
        Set expected = Utils.mkSet((Object[])new String[]{this.tlsProtocol});
        expected.add("SSLv2Hello");
        Assertions.assertEquals((Object)expected, (Object)Utils.mkSet((Object[])engine.getEnabledProtocols()));
        Assertions.assertEquals((Object)false, (Object)engine.getUseClientMode());
    }

    @Test
    public void testSslEngineCloser() throws Exception {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        Map<String, Object> serverSslConfig = TestSslUtils.createSslConfig(false, true, Mode.SERVER, trustStoreFile, "server");
        this.configureSslBuilderClass(serverSslConfig);
        SslFactory sslFactory = new SslFactory(Mode.SERVER);
        sslFactory.configure(serverSslConfig);
        SSLEngine engine = sslFactory.createSslEngine("localhost", 0);
        Assertions.assertNotNull((Object)engine);
        Assertions.assertTrue((boolean)(engine instanceof ReferenceCountedOpenSslEngine));
        ReferenceCountedOpenSslEngine opensslEngine = (ReferenceCountedOpenSslEngine)engine;
        Assertions.assertEquals((int)1, (int)opensslEngine.refCnt());
        sslFactory.createCloseableSslEngine((SSLEngine)opensslEngine).close();
        Assertions.assertEquals((int)0, (int)opensslEngine.refCnt());
    }
}

