/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Objects;
import java.util.Set;

public class AlterBrokerHealthSpec {
    private final String reason;
    private final Set<Integer> brokerIds;
    private final StatusEnum statusEnum;
    private final boolean force;

    public AlterBrokerHealthSpec(Set<Integer> brokerIds, StatusEnum statusEnum, String reason) {
        this(brokerIds, statusEnum, reason, false);
    }

    public AlterBrokerHealthSpec(Set<Integer> brokerIds, StatusEnum statusEnum, String reason, boolean force) {
        this.reason = reason;
        this.brokerIds = brokerIds;
        this.statusEnum = statusEnum;
        this.force = force;
    }

    public String reason() {
        return this.reason;
    }

    public Set<Integer> brokerIds() {
        return this.brokerIds;
    }

    public StatusEnum statusEnum() {
        return this.statusEnum;
    }

    public boolean force() {
        return this.force;
    }

    public String toString() {
        return "AlterBrokerHealthSpec (reason=" + this.reason + ", brokerIds=" + this.brokerIds + ", status=" + (Object)((Object)this.statusEnum) + ", force=" + this.force + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlterBrokerHealthSpec)) {
            return false;
        }
        AlterBrokerHealthSpec alterBrokerHealthSpec = (AlterBrokerHealthSpec)o;
        return Objects.equals(this.brokerIds, alterBrokerHealthSpec.brokerIds) && Objects.equals(this.reason, alterBrokerHealthSpec.reason) && Objects.equals((Object)this.statusEnum, (Object)alterBrokerHealthSpec.statusEnum) && this.force == alterBrokerHealthSpec.force;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.brokerIds, this.reason, this.statusEnum, this.force});
    }

    public static enum StatusEnum {
        DEGRADED(0),
        HEALTHY(1);

        private final byte id;

        private StatusEnum(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }
    }
}

