/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BrokerComponent {
    UNKNOWN(-1),
    UNSPECIFIED(0),
    STORAGE(1),
    NETWORK(2);

    private static final Map<Byte, BrokerComponent> BYTE_ENUM_MAP;
    private final byte id;

    private BrokerComponent(byte id) {
        this.id = id;
    }

    public byte id() {
        return this.id;
    }

    public static BrokerComponent forId(byte id) {
        return BYTE_ENUM_MAP.getOrDefault(id, UNKNOWN);
    }

    static {
        BYTE_ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(BrokerComponent.values()).collect(Collectors.toMap(BrokerComponent::id, Function.identity())));
    }
}

