/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BrokerHealthStatusResult {
    private final int brokerId;
    private final StatusEnum statusEnum;

    BrokerHealthStatusResult(int brokerId, byte statusValue) {
        this.brokerId = brokerId;
        this.statusEnum = StatusEnum.ENUM_MAP.getOrDefault(statusValue, StatusEnum.UNKNOWN);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public StatusEnum statusEnum() {
        return this.statusEnum;
    }

    public String toString() {
        return "BrokerHealthStatusResult(brokerId=" + this.brokerId + ", status=" + (Object)((Object)this.statusEnum) + ")";
    }

    public static enum StatusEnum {
        UNKNOWN(-1),
        DEGRADED(0),
        HEALTHY(1);

        private static final Map<Byte, StatusEnum> ENUM_MAP;
        private final byte id;

        private StatusEnum(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        static {
            ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(StatusEnum.values()).collect(Collectors.toMap(StatusEnum::id, Function.identity())));
        }
    }
}

