/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.ClusterLinkError;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.Uuid;

public class ClusterLinkDescription {
    private final String linkName;
    private final Uuid linkId;
    private final String remoteClusterId;
    private final String localClusterId;
    private final Collection<String> topics;
    private final LinkState linkState;
    private final LinkMode linkMode;
    private final ConnectionMode connectionMode;
    private final ClusterLinkError clusterLinkError;
    private final String linkErrorMessage;
    private final int linkCoordinatorId;
    private final String linkCoordinatorHost;
    private final int linkCoordinatorPort;

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, Node linkCoordinator) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, Objects.requireNonNull(linkCoordinator).id(), Objects.requireNonNull(linkCoordinator).host(), Objects.requireNonNull(linkCoordinator).port());
    }

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, clusterLinkError, linkErrorMessage, Node.noNode());
    }

    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode, ClusterLinkError clusterLinkError, String linkErrorMessage, int linkCoordinatorId, String linkCoordinatorHost, int linkCoordinatorPort) {
        this.linkName = Objects.requireNonNull(linkName, "linkName");
        this.linkId = Objects.requireNonNull(linkId, "linkId");
        this.remoteClusterId = remoteClusterId;
        this.localClusterId = localClusterId;
        this.topics = topics;
        this.linkState = linkState;
        this.linkMode = linkMode;
        this.connectionMode = connectionMode;
        this.clusterLinkError = clusterLinkError;
        this.linkErrorMessage = linkErrorMessage;
        this.linkCoordinatorId = linkCoordinatorId;
        this.linkCoordinatorHost = linkCoordinatorHost;
        this.linkCoordinatorPort = linkCoordinatorPort;
    }

    @Deprecated
    public ClusterLinkDescription(String linkName, Uuid linkId, String remoteClusterId, String localClusterId, Collection<String> topics, LinkState linkState, LinkMode linkMode, ConnectionMode connectionMode) {
        this(linkName, linkId, remoteClusterId, localClusterId, topics, linkState, linkMode, connectionMode, ClusterLinkError.NO_ERROR, null, Node.noNode());
    }

    public String linkName() {
        return this.linkName;
    }

    public Uuid clusterLinkId() {
        return this.linkId;
    }

    public String remoteClusterId() {
        return this.remoteClusterId;
    }

    public String localClusterId() {
        return this.localClusterId;
    }

    public Optional<Collection<String>> topics() {
        return Optional.ofNullable(this.topics);
    }

    public LinkState linkState() {
        return this.linkState;
    }

    public LinkMode linkMode() {
        return this.linkMode;
    }

    public ConnectionMode connectionMode() {
        return this.connectionMode;
    }

    public ClusterLinkError clusterLinkError() {
        return this.clusterLinkError;
    }

    public String linkErrorMessage() {
        return this.linkErrorMessage;
    }

    public int linkCoordinatorId() {
        return this.linkCoordinatorId;
    }

    public String linkCoordinatorHost() {
        return this.linkCoordinatorHost;
    }

    public int linkCoordinatorPort() {
        return this.linkCoordinatorPort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterLinkDescription that = (ClusterLinkDescription)o;
        return Objects.equals(this.linkName, that.linkName) && Objects.equals(this.linkId, that.linkId) && Objects.equals(this.remoteClusterId, that.remoteClusterId) && Objects.equals(this.localClusterId, that.localClusterId) && Objects.equals(this.topics, that.topics) && Objects.equals((Object)this.linkState, (Object)that.linkState) && Objects.equals((Object)this.linkMode, (Object)that.linkMode) && Objects.equals((Object)this.connectionMode, (Object)that.connectionMode) && Objects.equals((Object)this.clusterLinkError, (Object)that.clusterLinkError) && Objects.equals(this.linkErrorMessage, that.linkErrorMessage) && Objects.equals(this.linkCoordinatorId, that.linkCoordinatorId) && Objects.equals(this.linkCoordinatorHost, that.linkCoordinatorHost) && Objects.equals(this.linkCoordinatorPort, that.linkCoordinatorPort);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.linkName, this.linkId, this.remoteClusterId, this.localClusterId, this.topics, this.linkState, this.linkMode, this.connectionMode, this.clusterLinkError, this.linkErrorMessage, this.linkCoordinatorId, this.linkCoordinatorHost, this.linkCoordinatorPort});
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("ClusterLinkListing(linkName=").append(this.linkName).append(", linkId=").append(this.linkId).append(", remoteClusterId=").append(this.remoteClusterId).append(", localClusterId=").append(this.localClusterId).append(", linkState=").append((Object)this.linkState).append(", linkMode=").append((Object)this.linkMode).append(", connectionMode=").append((Object)this.connectionMode).append(", topics=").append(this.topics).append(", clusterLinkError=").append((Object)this.clusterLinkError).append(", linkErrorMessage=").append(this.linkErrorMessage).append(", linkCoordinatorId=").append(this.linkCoordinatorId).append(", linkCoordinatorHost=").append(this.linkCoordinatorHost).append(", linkCoordinatorPort=").append(this.linkCoordinatorPort);
        return str.toString();
    }

    public static enum ConnectionMode {
        UNKNOWN(0),
        INBOUND(1),
        OUTBOUND(2);

        private short value;

        private ConnectionMode(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static ConnectionMode fromShort(short x) {
            switch (x) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return INBOUND;
                }
                case 2: {
                    return OUTBOUND;
                }
            }
            throw new IllegalStateException("Unhandled connection mode value " + x);
        }
    }

    public static enum LinkMode {
        UNKNOWN(0),
        DESTINATION(1),
        SOURCE(2);

        private short value;

        private LinkMode(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static LinkMode fromShort(short x) {
            switch (x) {
                case 0: {
                    return UNKNOWN;
                }
                case 1: {
                    return DESTINATION;
                }
                case 2: {
                    return SOURCE;
                }
            }
            throw new IllegalStateException("Unhandled link mode value " + x);
        }
    }

    public static enum LinkState {
        UNKNOWN(-1),
        ACTIVE(0),
        FAILED(1),
        UNAVAILABLE(2),
        PAUSED(3);

        private short value;

        private LinkState(int value) {
            this.value = (short)value;
        }

        public short getValue() {
            return this.value;
        }

        public static LinkState fromShort(short x) {
            switch (x) {
                case -1: {
                    return UNKNOWN;
                }
                case 0: {
                    return ACTIVE;
                }
                case 1: {
                    return FAILED;
                }
                case 2: {
                    return UNAVAILABLE;
                }
                case 3: {
                    return PAUSED;
                }
            }
            throw new IllegalStateException("Unhandled link state value " + x);
        }

        public boolean available() {
            if (this.value == UNKNOWN.getValue()) {
                throw new IllegalStateException("Unable to determine availablility state because it's unknown " + LinkState.fromShort(this.value).name());
            }
            return this.value != FAILED.getValue() && this.value != UNAVAILABLE.getValue();
        }
    }
}

