/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Map;
import java.util.Optional;
import org.apache.kafka.clients.admin.BrokerAdditionDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.annotation.InterfaceStability;

@InterfaceStability.Evolving
public class DescribeBrokerAdditionsResult {
    private final KafkaFuture<Map<Integer, BrokerAdditionDescription>> futures;

    DescribeBrokerAdditionsResult(KafkaFuture<Map<Integer, BrokerAdditionDescription>> brokerAdditions) {
        this.futures = brokerAdditions;
    }

    public KafkaFuture<Map<Integer, BrokerAdditionDescription>> descriptions() {
        return this.futures;
    }

    public KafkaFuture<Optional<BrokerAdditionDescription>> description(int brokerId) {
        return this.futures.thenApply(desc -> Optional.ofNullable(desc.get(brokerId)));
    }
}

