/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsOverview;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsResources;

public class EvenClusterLoadPlanGoalStats {
    private final String goalName;
    private final EvenClusterLoadPlanGoalStatsResources avgResources;
    private final EvenClusterLoadPlanGoalStatsResources maxResources;
    private final EvenClusterLoadPlanGoalStatsResources minResources;
    private final EvenClusterLoadPlanGoalStatsResources stdResources;
    private final EvenClusterLoadPlanGoalStatsOverview overview;

    public EvenClusterLoadPlanGoalStats(String goalName, EvenClusterLoadPlanGoalStatsResources avgResources, EvenClusterLoadPlanGoalStatsResources maxResources, EvenClusterLoadPlanGoalStatsResources minResources, EvenClusterLoadPlanGoalStatsResources stdResources, EvenClusterLoadPlanGoalStatsOverview overview) {
        this.goalName = goalName;
        this.avgResources = avgResources;
        this.maxResources = maxResources;
        this.minResources = minResources;
        this.stdResources = stdResources;
        this.overview = overview;
    }

    public String goalName() {
        return this.goalName;
    }

    public EvenClusterLoadPlanGoalStatsResources avgResources() {
        return this.avgResources;
    }

    public EvenClusterLoadPlanGoalStatsResources maxResources() {
        return this.maxResources;
    }

    public EvenClusterLoadPlanGoalStatsResources minResources() {
        return this.minResources;
    }

    public EvenClusterLoadPlanGoalStatsResources stdResources() {
        return this.stdResources;
    }

    public EvenClusterLoadPlanGoalStatsOverview goalOverview() {
        return this.overview;
    }

    public String printableForm() {
        StringBuilder output = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        output.append(String.format("Stats for %s (%s):", this.goalName(), this.goalOverview().goalStatus()));
        output.append(lineSeparator);
        output.append(String.format("AVG: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", this.avgResources().cpuPercent(), this.avgResources().networkInboundKBps(), this.avgResources().producerInboundKBps(), this.avgResources().networkOutboundKBps(), this.avgResources().diskMB(), this.avgResources().potentialNwOutKBps(), this.avgResources().replicas(), this.avgResources().leaderReplicas(), this.avgResources().topicReplicas()));
        output.append(lineSeparator);
        output.append(String.format("MAX: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", this.maxResources().cpuPercent(), this.maxResources().networkInboundKBps(), this.maxResources().producerInboundKBps(), this.maxResources().networkOutboundKBps(), this.maxResources().diskMB(), this.maxResources().potentialNwOutKBps(), this.maxResources().replicas(), this.maxResources().leaderReplicas(), this.maxResources().topicReplicas()));
        output.append(lineSeparator);
        output.append(String.format("MIN: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", this.minResources().cpuPercent(), this.minResources().networkInboundKBps(), this.minResources().producerInboundKBps(), this.minResources().networkOutboundKBps(), this.minResources().diskMB(), this.minResources().potentialNwOutKBps(), this.minResources().replicas(), this.minResources().leaderReplicas(), this.minResources().topicReplicas()));
        output.append(lineSeparator);
        output.append(String.format("STD: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", this.stdResources().cpuPercent(), this.stdResources().networkInboundKBps(), this.stdResources().producerInboundKBps(), this.stdResources().networkOutboundKBps(), this.stdResources().diskMB(), this.stdResources().potentialNwOutKBps(), this.stdResources().replicas(), this.stdResources().leaderReplicas(), this.stdResources().topicReplicas()));
        output.append(lineSeparator);
        output.append(String.format("%d proposals generated -- %d rejected (%.2f), %d accepted (%.2f) -- %d moves, %d swaps", this.goalOverview().proposalsGenerated(), this.goalOverview().proposalsRejected(), this.goalOverview().proposalsRejectedPercent(), this.goalOverview().proposalsAccepted(), this.goalOverview().proposalsAcceptedPercent(), this.goalOverview().moves(), this.goalOverview().swaps()));
        output.append(lineSeparator);
        if (!this.goalOverview().rejectingGoals().isEmpty()) {
            output.append("Proposal rejections by rejecting goal:");
            output.append(lineSeparator);
            this.goalOverview().rejectingGoals().forEach(rejectingGoal -> {
                output.append(String.format("\t%s: %d", rejectingGoal.goalName(), rejectingGoal.proposalsRejected()));
                output.append(lineSeparator);
            });
        }
        output.append(lineSeparator);
        return output.toString();
    }

    public String toString() {
        return "EvenClusterLoadPlanGoalStats{goalName=" + this.goalName + ", avgResources=" + this.avgResources + ", minResources=" + this.minResources + ", maxResources=" + this.maxResources + ", stdResources=" + this.stdResources + ", overview=" + this.overview + "}";
    }
}

