/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin.internals;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.admin.AdminClientConfig;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.AlterConfigsOptions;
import org.apache.kafka.clients.admin.AlterConfigsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.KafkaAdminClient;
import org.apache.kafka.clients.admin.internals.AdminMetadataManager;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.InitiateReverseConnectionsRequestData;
import org.apache.kafka.common.network.RequestCallback;
import org.apache.kafka.common.utils.Time;

public class ConfluentAdminUtils {
    private static final Map<String, MethodHandle> ADMIN_METHODS;

    public static ConfluentAdmin createConfluentAdmin(AdminClientConfig config, RequestCallback requestCallback) {
        return (ConfluentAdmin)ConfluentAdminUtils.invokeAdminMethod("createInternalWithCallback", config, requestCallback);
    }

    public static ConfluentAdmin createConfluentAdmin(AdminClientConfig config, AdminMetadataManager metadataManager, KafkaClient client, Time time) {
        return (ConfluentAdmin)ConfluentAdminUtils.invokeAdminMethod("createInternal", config, metadataManager, client, time);
    }

    public static Map<Integer, KafkaFutureImpl<Void>> initiateReverseConnections(ConfluentAdmin admin, InitiateReverseConnectionsRequestData requestData, Integer brokerId) {
        return (Map)ConfluentAdminUtils.invokeAdminMethod("initiateReverseConnections", admin, requestData, brokerId);
    }

    public static AlterConfigsResult incrementalAlterMirrorTopicConfigs(ConfluentAdmin admin, Map<ConfigResource, Collection<AlterConfigOp>> configs, AlterConfigsOptions options) {
        return (AlterConfigsResult)ConfluentAdminUtils.invokeAdminMethod("incrementalAlterMirrorTopicConfigs", admin, configs, options);
    }

    private static void addAdminMethod(MethodHandles.Lookup lookup, String methodName, Class<?> ... argTypes) {
        try {
            Method method = KafkaAdminClient.class.getDeclaredMethod(methodName, argTypes);
            method.setAccessible(true);
            MethodHandle methodHandle = lookup.unreflect(method);
            ADMIN_METHODS.put(methodName, methodHandle);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new KafkaException("Failed to add method " + methodName, e);
        }
    }

    private static <T> T invokeAdminMethod(String methodName, Object ... args) {
        try {
            MethodHandle methodHandle = ADMIN_METHODS.get(methodName);
            if (methodHandle == null) {
                throw new IllegalArgumentException("Admin method not found: " + methodName);
            }
            return (T)methodHandle.invokeWithArguments(args);
        }
        catch (Throwable t) {
            throw new KafkaException("Admin method invocation failed: " + methodName, t);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        ADMIN_METHODS = new HashMap<String, MethodHandle>();
        ConfluentAdminUtils.addAdminMethod(lookup, "createInternal", AdminClientConfig.class, AdminMetadataManager.class, KafkaClient.class, Time.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "createInternalWithCallback", AdminClientConfig.class, RequestCallback.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "initiateReverseConnections", InitiateReverseConnectionsRequestData.class, Integer.class);
        ConfluentAdminUtils.addAdminMethod(lookup, "incrementalAlterMirrorTopicConfigs", Map.class, AlterConfigsOptions.class);
    }
}

