/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.InvalidRequestException;

public enum CellState {
    READY(0),
    QUARANTINED(1),
    EXCLUDED(2);

    private static final Map<Byte, CellState> CODE_TO_CELL_STATE;
    private final byte code;

    public byte code() {
        return this.code;
    }

    private CellState(byte code) {
        this.code = code;
    }

    public static CellState toEnum(byte code) {
        CellState state = CODE_TO_CELL_STATE.get(code);
        if (state == null) {
            throw new InvalidRequestException("Cell state code " + code + " is not valid");
        }
        return state;
    }

    static {
        CODE_TO_CELL_STATE = Arrays.stream(CellState.values()).collect(Collectors.toMap(CellState::code, Function.identity()));
    }
}

