/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.config.internals;

import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.errors.BalancerMisconfigurationException;

public class BalancerConfigs {
    public static final String CONFLUENT_BALANCER_PREFIX = "confluent.balancer.";
    public static final String BALANCER_CLASS_CONFIG = "confluent.balancer.class";
    public static final String BALANCER_CLASS_DOC = "The class providing DataBalancer services for the Kafka controller.";
    public static final String BALANCER_CLASS_DEFAULT = "io.confluent.databalancer.SbcDataBalanceManager";
    public static final String BALANCER_ENABLE_SBK_CONFIG = "enable";
    public static final String BALANCER_ENABLE_CONFIG = "confluent.balancer.enable";
    public static final boolean BALANCER_ENABLE_DEFAULT = false;
    public static final String BALANCER_ENABLE_DOC = "This config controls whether the balancer is enabled";
    public static final String BALANCER_AUTO_HEAL_MODE_SBK_CONFIG = "heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_CONFIG = "confluent.balancer.heal.uneven.load.trigger";
    public static final String BALANCER_AUTO_HEAL_MODE_DEFAULT = BalancerSelfHealMode.EMPTY_BROKER.toString();
    public static final String BALANCER_AUTO_HEAL_MODE_DOC = "Controls what causes the Confluent DataBalancer to start rebalance operations. Acceptable values are " + (Object)((Object)BalancerSelfHealMode.ANY_UNEVEN_LOAD) + " and " + (Object)((Object)BalancerSelfHealMode.EMPTY_BROKER);
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_SBK_CONFIG = "heal.broker.failure.threshold.ms";
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG = "confluent.balancer.heal.broker.failure.threshold.ms";
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT = Duration.ofHours(1L).toMillis();
    public static final Long BALANCER_BROKER_FAILURE_THRESHOLD_DISABLED = -1L;
    public static final String BALANCER_BROKER_FAILURE_THRESHOLD_DOC = "This config specifies how long the balancer will wait after detecting a broker failure before triggering a balancing action. -1 means that broker failures will not trigger balancing actions";
    public static final String BALANCER_THROTTLE_SBK_CONFIG = "throttle.bytes.per.second";
    public static final String BALANCER_THROTTLE_CONFIG = "confluent.balancer.throttle.bytes.per.second";
    public static final Long BALANCER_THROTTLE_NO_THROTTLE = -1L;
    public static final Long BALANCER_THROTTLE_AUTO_THROTTLE;
    public static final Long BALANCER_THROTTLE_MIN;
    public static final Long BALANCER_THROTTLE_DEFAULT;
    public static final String BALANCER_THROTTLE_DOC = "This config specifies the upper bound for bandwidth in bytes to move replicas around for replica reassignment. A value of -1 disables throttling entirely.";
    public static final String BALANCER_REPLICA_CAPACITY_SBK_CONFIG = "max.replicas";
    public static final String BALANCER_REPLICA_CAPACITY_CONFIG = "confluent.balancer.max.replicas";
    public static final Long BALANCER_REPLICA_CAPACITY_DEFAULT;
    public static final String BALANCER_REPLICA_CAPACITY_DOC = "The replica capacity is the maximum number of replicas the balancer will place on a single broker.";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_SBK_CONFIG = "disk.max.load";
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG = "confluent.balancer.disk.max.load";
    public static final Double BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT;
    public static final String BALANCER_DISK_CAPACITY_THRESHOLD_DOC = "This config specifies the maximum load for disk usage as a proportion of disk capacity. Valid values are between 0 and 1.";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_SBK_CONFIG = "disk.min.free.space.gb";
    public static final String BALANCER_DISK_MIN_FREE_SPACE_CONFIG = "confluent.balancer.disk.min.free.space.gb";
    public static final Integer BALANCER_DISK_MIN_FREE_SPACE_DEFAULT;
    public static final String BALANCER_DISK_MIN_FREE_SPACE_DOC = "The minimum amount of disk space, in GB, that needs to remain unused on a broker. Valid values are between 0 and disk size. The balancer will enforce the stricter bound between this config and 'confluent.balancer.disk.max.load'.";
    public static final String BALANCER_NETWORK_IN_CAPACITY_SBK_CONFIG = "network.in.max.bytes.per.second";
    public static final String BALANCER_NETWORK_IN_CAPACITY_CONFIG = "confluent.balancer.network.in.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_IN_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_IN_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_IN_CAPACITY_DOC = "This config specifies the upper capacity limit for network incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String BALANCER_PRODUCER_IN_CAPACITY_SBK_CONFIG = "producer.in.max.bytes.per.second";
    public static final String BALANCER_PRODUCER_IN_CAPACITY_CONFIG = "confluent.balancer.producer.in.max.bytes.per.second";
    public static final Long BALANCER_PRODUCER_IN_CAPACITY_DEFAULT;
    public static final Long BALANCER_PRODUCER_IN_CAPACITY_MIN;
    public static final String BALANCER_PRODUCER_IN_CAPACITY_DOC = "This config specifies the upper capacity limit for producer incoming bytes per second per broker. The Confluent DataBalancer will attempt to keep incoming data throughput below this limit.";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_SBK_CONFIG = "network.out.max.bytes.per.second";
    public static final String BALANCER_NETWORK_OUT_CAPACITY_CONFIG = "confluent.balancer.network.out.max.bytes.per.second";
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_DEFAULT;
    public static final Long BALANCER_NETWORK_OUT_CAPACITY_MIN;
    public static final String BALANCER_NETWORK_OUT_CAPACITY_DOC = "This config specifies the upper capacity limit for network outgoing bytes per second per broker. The Confluent DataBalancer will attempt to keep outgoing data throughput below this limit.";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_SBK_CONFIG = "exclude.topic.names";
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG = "confluent.balancer.exclude.topic.names";
    public static final List<?> BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_NAMES_DOC = "This config accepts a list of topic names that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.names=[topic1, topic2]' ";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_BASE_CONFIG = "exclude.topic.prefixes";
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG = "confluent.balancer.exclude.topic.prefixes";
    public static final List<?> BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT;
    public static final String BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC = "This config accepts a list of topic prefixes that will be excluded from rebalancing. For example, 'confluent.balancer.exclude.topic.prefixes=[prefix1, prefix2]' would exclude topics 'prefix1-suffix1', 'prefix1-suffix2', 'prefix2-suffix3', but not 'abc-prefix1-xyz' and 'def-prefix2'";
    public static final String BALANCER_API_STATE_TOPIC_SBK_CONFIG = "api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_CONFIG = "confluent.balancer.api.state.topic";
    public static final String BALANCER_API_STATE_TOPIC_DEFAULT = "_confluent_balancer_api_state";
    public static final String BALANCER_API_STATE_TOPIC_DOC = "Name of topic to use to store state of Confluent DataBalancer API. The topic will be used to store progress/failure of the api and will be used in case of recovery to resume long running operations like remove or add broker.";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_SBK_CONFIG = "topic.replication.factor";
    public static final String BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG = "confluent.balancer.topic.replication.factor";
    public static final Short BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT;
    public static final String BALANCER_TOPIC_REPLICATION_FACTOR_DOC = "Replication factor for all topics that are created and needed by the Confluent DataBalancer. This includes Sample Store and API state topics.";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_SBK_CONFIG = "task.history.retention.days";
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG = "confluent.balancer.task.history.retention.days";
    public static final Integer BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT;
    public static final String BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC = "Number of days for which self balancing cluster's task history will be retained.";
    public static final String BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_SBC_CONFIG = "max.capacity.balancing.delta.percentage";
    public static final String BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG = "confluent.balancer.max.capacity.balancing.delta.percentage";
    public static final Double BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT;
    public static final String BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DOC = "The extra percentage of total capacity that SBC will attempt to balance below the allowed capacity once it gets triggered to fix a broker hitting its maximum allowed capacity for a given resource.";
    public static final String BALANCER_REBALANCING_GOALS_SBC_CONFIG = "rebalancing.goals";
    public static final String BALANCER_REBALANCING_GOALS_CONFIG = "confluent.balancer.rebalancing.goals";
    public static final String BALANCER_REBALANCING_GOALS_CONFIG_DEFAULT = "";
    public static final String BALANCER_REBALANCING_GOALS_DOC = "A list of goals that the balancer tries to satisfy when rebalancing, in order of priority. The high priority goals are executed first. e.g \"io.confluent.cruisecontrol.analyzer.goals.MaxReplicaMovementParallelismGoal,io.confluent.cruisecontrol.analyzer.goals.ReplicaPlacementGoal\"";
    public static final String BALANCER_TRIGGERING_GOALS_SBC_CONFIG = "triggering.goals";
    public static final String BALANCER_TRIGGERING_GOALS_CONFIG = "confluent.balancer.triggering.goals";
    public static final String BALANCER_TRIGGERING_GOALS_CONFIG_DEFAULT = "";
    public static final String BALANCER_TRIGGERING_GOALS_DOC = "A list of goals that the balancer checks whether they're violated in order to know if a even cluster load task should be triggered. e.g \"io.confluent.cruisecontrol.analyzer.goals.MaxReplicaMovementParallelismGoal,io.confluent.cruisecontrol.analyzer.goals.ReplicaPlacementGoal\"";
    public static final String BALANCER_INCREMENTAL_BALANCING_ENABLED_SBC_CONFIG = "incremental.balancing.enabled";
    public static final String BALANCER_INCREMENTAL_BALANCING_ENABLED_CONFIG = "confluent.balancer.incremental.balancing.enabled";
    public static final String BALANCER_INCREMENTAL_BALANCING_ENABLED_DOC = "A boolean value controlling whether to use incremental balancing strategy or not.";
    public static final Boolean BALANCER_INCREMENTAL_BALANCING_ENABLED_DEFAULT;
    public static final String BALANCER_INCREMENTAL_BALANCING_GOALS_SBC_CONFIG = "incremental.balancing.goals";
    public static final String BALANCER_INCREMENTAL_BALANCING_GOALS_CONFIG = "confluent.balancer.incremental.balancing.goals";
    public static final String BALANCER_INCREMENTAL_BALANCING_GOALS_DOC = "A list of case insensitive goals in the order of priority. The high priority goals will be executed first. This list of goals will be used for anomaly detection and balancing if incremental.balancing.enabled is set to true.";
    public static final String BALANCER_INCREMENTAL_BALANCING_DEFAULT_GOALS_LIST = "";
    public static final String BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_SBC_CONFIG = "incremental.balancing.step.ratio";
    public static final String BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_CONFIG = "confluent.balancer.incremental.balancing.step.ratio";
    public static final String BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_DOC = "A value in the interval [0, 1] representing the step size of each incremental balancing round. For example, if an overloaded broker has 70% CPU usage and the mean CPU usage across the cluster is 50%, setting incremental.balancing.step.ratio to 0.2 will generate incremental balancing proposals that moves enough replicas off from the overloaded broker so that its CPU usage drops by 20% of the delta: (70% - 50%) * 0.2 = 4%.";
    public static final Double BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_DEFAULT;
    public static final String BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_SBC_CONFIG = "incremental.balancing.cpu.top.proposal.tracking.num.proposals";
    public static final String BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_CONFIG = "confluent.balancer.incremental.balancing.cpu.top.proposal.tracking.num.proposals";
    public static final String BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_DOC = "An integer denoting the number of proposals to track per broker with relation to the top proposal tracking functionality.";
    public static final Integer BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_DEFAULT;
    public static final String BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_SBC_CONFIG = "incremental.balancing.cpu.top.proposal.tracking.enabled";
    public static final String BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_CONFIG = "confluent.balancer.incremental.balancing.cpu.top.proposal.tracking.enabled";
    public static final Boolean BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_DEFAULT;
    public static final String BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_DOC = "A boolean denoting whether top proposal tracking is enabled for the incremental CPU balancing strategy. Top proposal tracking is a functionality which keeps track of the largest 'incremental.balancing.cpu.top.proposal.tracking.num.proposals' proposals per broker, ranked by the amount of CPU they're expected to move, that have been generated by the incremental CPU balancing strategy and logs them after each optimization. It is useful for observability purposes in order to understand what proposals the balancing algorithm is generating.";
    public static final String BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_SBC_CONFIG = "incremental.balancing.lower.bound";
    public static final String BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_CONFIG = "confluent.balancer.incremental.balancing.lower.bound";
    public static final String BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_DOC = "A value in the interval [0, 1] representing the lower bound of replica movements from each incremental balancing round to prevent the long tail effect of incremental balancing. Take CPU usage for example, setting incremental.balancing.lower.bound to 0.02 will cause each incremental balancing round generates enough movements so that the change in CPU usage is at least 0.02 * 100% (Capacity of CPU usage) = 2% of the capacity. Combining with incremental.balancing.step.ratio, these two configurations facilitate the success criteria of an incremental balancing round.";
    public static final Double BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_DEFAULT;
    public static final String BALANCER_RESOURCE_UTILIZATION_DETECTOR_ENABLED_SBC_CONFIG = "resource.utilization.detector.enabled";
    public static final String BALANCER_RESOURCE_UTILIZATION_DETECTOR_ENABLED_CONFIG = "confluent.balancer.resource.utilization.detector.enabled";
    public static final boolean BALANCER_DEFAULT_RESOURCE_UTILIZATION_DETECTOR_ENABLED = false;
    public static final String BALANCER_RESOURCE_UTILIZATION_DETECTOR_ENABLED_DOC = "Specify if resource optimization detector is enabled";
    public static final String BALANCER_RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_SBC_CONFIG = "resource.utilization.detector.interval.ms";
    public static final String BALANCER_RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_CONFIG = "confluent.balancer.resource.utilization.detector.interval.ms";
    public static final int BALANCER_DEFAULT_RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS = 60000;
    public static final String BALANCER_RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_DOC = "The interval in milliseconds that the resource optimization detector will run.";
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_DURATION_MS_SBC_CONFIG = "cpu.utilization.detector.duration.ms";
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_DURATION_MS_CONFIG = "confluent.balancer.cpu.utilization.detector.duration.ms";
    public static final int BALANCER_DEFAULT_CPU_UTILIZATION_DETECTOR_DURATION_MS = 600000;
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_DURATION_MS_DOC = "The duration in milliseconds for which resource utilization values will be accumulated before the decision to raise an alert is made.";
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_SBC_CONFIG = "cpu.utilization.detector.overutilization.threshold";
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG = "confluent.balancer.cpu.utilization.detector.overutilization.threshold";
    public static final double BALANCER_DEFAULT_CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD = 80.0;
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC = "CPU usage percentage representing overutilization.";
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_SBC_CONFIG = "cpu.utilization.detector.underutilization.threshold";
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG = "confluent.balancer.cpu.utilization.detector.underutilization.threshold";
    public static final double BALANCER_DEFAULT_CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD = 50.0;
    public static final String BALANCER_CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC = "CPU usage percentage representing underutilization.";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_DURATION_MS_SBC_CONFIG = "disk.utilization.detector.duration.ms";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_DURATION_MS_CONFIG = "confluent.balancer.disk.utilization.detector.duration.ms";
    public static final int BALANCER_DEFAULT_DISK_UTILIZATION_DETECTOR_DURATION_MS = 600000;
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_DURATION_MS_DOC = "The duration in milliseconds for which disk utilization values will be accumulated before the decision to raise an alert is made.";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_SBC_CONFIG = "disk.utilization.detector.overutilization.threshold";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG = "confluent.balancer.disk.utilization.detector.overutilization.threshold";
    public static final double BALANCER_DEFAULT_DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD = 80.0;
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC = "Disk usage percentage representing overutilization.";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_SBC_CONFIG = "disk.utilization.detector.underutilization.threshold";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG = "confluent.balancer.disk.utilization.detector.underutilization.threshold";
    public static final double BALANCER_DEFAULT_DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD = 35.0;
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC = "Disk usage percentage representing underutilization.";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_SBC_CONFIG = "disk.utilization.detector.reserved.capacity";
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_CONFIG = "confluent.balancer.disk.utilization.detector.reserved.capacity";
    public static final double BALANCER_DEFAULT_DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY = 150000.0;
    public static final String BALANCER_DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_DOC = "Minimum disk space beyond which we don't shrink the cluster even if it is underutilized.";
    public static final String BALANCER_TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_SBC_CONFIG = "topic.partition.movement.expiration.ms";
    public static final String BALANCER_TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_CONFIG = "confluent.balancer.topic.partition.movement.expiration.ms";
    public static final long BALANCER_DEFAULT_TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS = 3600000L;
    public static final String BALANCER_TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_DOC = "The duration in milliseconds for which a topic partition movement will be kept for observability and oscillation prevention. Effectively, SBC maintains a rolling window of topic partition movements whose length is defined by this configuration.";
    public static final String BALANCER_TOPIC_PARTITION_MAXIMUM_MOVEMENTS_SBC_CONFIG = "topic.partition.maximum.movements";
    public static final String BALANCER_TOPIC_PARTITION_MAXIMUM_MOVEMENTS_CONFIG = "confluent.balancer.topic.partition.maximum.movements";
    public static final int BALANCER_DEFAULT_TOPIC_PARTITION_MAXIMUM_MOVEMENTS = 5;
    public static final String BALANCER_TOPIC_PARTITION_MAXIMUM_MOVEMENTS_DOC = "Maximum number of repeated movements allowed for one TopicPartition in the rolling window whose length is defined by topic.partition.movement.expiration.ms";
    public static final String BALANCER_TOPIC_PARTITION_SUSPENSION_MS_SBC_CONFIG = "topic.partition.suspension.ms";
    public static final String BALANCER_TOPIC_PARTITION_SUSPENSION_MS_CONFIG = "confluent.balancer.topic.partition.suspension.ms";
    public static final long BALANCER_DEFAULT_TOPIC_PARTITION_SUSPENSION_MS = 10800000L;
    public static final String BALANCER_TOPIC_PARTITION_SUSPENSION_MS_DOC = "The duration in milliseconds for which a topic partition will be suspended for goal optimization if number of repeated movements within the rolling window defined by topic.partition.movement.expiration.ms exceeds the maximum allowed number defined by topic.partition.maximum.movements.";
    public static final String BALANCER_DEMOTION_SUPPORT_ENABLED_SBC_CONFIG = "demotion.support.enabled";
    public static final String BALANCER_DEMOTION_SUPPORT_ENABLED_CONFIG = "confluent.balancer.demotion.support.enabled";
    public static final boolean BALANCER_DEFAULT_DEMOTION_SUPPORT_ENABLED = false;
    public static final String BALANCER_DEMOTION_SUPPORT_ENABLED_DOC = "This config controls whether the Balancer supports demoted brokers. If disabled, the Balancer will shut down at the presence of demoted brokers.";

    public static void validateGoalsConfig(List<String> rebalancingGoals, List<String> triggeringGoals) throws BalancerMisconfigurationException {
        if (rebalancingGoals.isEmpty() || triggeringGoals.isEmpty()) {
            throw new BalancerMisconfigurationException(String.format("Neither %s nor %s should be empty", BALANCER_REBALANCING_GOALS_CONFIG, BALANCER_TRIGGERING_GOALS_CONFIG));
        }
        if (!new HashSet<String>(rebalancingGoals).containsAll(triggeringGoals)) {
            throw new BalancerMisconfigurationException(String.format("%s (%s) do not contain all %s (%s)", BALANCER_REBALANCING_GOALS_CONFIG, rebalancingGoals, BALANCER_TRIGGERING_GOALS_CONFIG, triggeringGoals));
        }
    }

    public static ConfigDef defineConfigs(ConfigDef config) {
        config.defineInternal(BALANCER_CLASS_CONFIG, ConfigDef.Type.STRING, BALANCER_CLASS_DEFAULT, ConfigDef.Importance.LOW, BALANCER_CLASS_DOC).define(BALANCER_ENABLE_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.HIGH, BALANCER_ENABLE_DOC).define(BALANCER_AUTO_HEAL_MODE_CONFIG, ConfigDef.Type.STRING, BALANCER_AUTO_HEAL_MODE_DEFAULT, ConfigDef.ValidString.in(BalancerSelfHealMode.ANY_UNEVEN_LOAD.toString(), BalancerSelfHealMode.EMPTY_BROKER.toString()), ConfigDef.Importance.HIGH, BALANCER_AUTO_HEAL_MODE_DOC).define(BALANCER_THROTTLE_CONFIG, ConfigDef.Type.LONG, BALANCER_THROTTLE_DEFAULT, ConfigDef.Range.atLeast(BALANCER_THROTTLE_MIN), ConfigDef.Importance.HIGH, BALANCER_THROTTLE_DOC).define(BALANCER_REPLICA_CAPACITY_CONFIG, ConfigDef.Type.LONG, BALANCER_REPLICA_CAPACITY_DEFAULT, ConfigDef.Range.atLeast(0), ConfigDef.Importance.HIGH, BALANCER_REPLICA_CAPACITY_DOC).define(BALANCER_DISK_CAPACITY_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT, ConfigDef.Range.between(0.0, 1.0), ConfigDef.Importance.HIGH, BALANCER_DISK_CAPACITY_THRESHOLD_DOC).define(BALANCER_DISK_MIN_FREE_SPACE_CONFIG, ConfigDef.Type.INT, BALANCER_DISK_MIN_FREE_SPACE_DEFAULT, ConfigDef.Range.atLeast(0), ConfigDef.Importance.MEDIUM, BALANCER_DISK_MIN_FREE_SPACE_DOC).define(BALANCER_NETWORK_IN_CAPACITY_CONFIG, ConfigDef.Type.LONG, BALANCER_NETWORK_IN_CAPACITY_DEFAULT, ConfigDef.Range.atLeast(BALANCER_NETWORK_IN_CAPACITY_MIN), ConfigDef.Importance.HIGH, BALANCER_NETWORK_IN_CAPACITY_DOC).define(BALANCER_PRODUCER_IN_CAPACITY_CONFIG, ConfigDef.Type.LONG, BALANCER_PRODUCER_IN_CAPACITY_DEFAULT, ConfigDef.Range.atLeast(BALANCER_PRODUCER_IN_CAPACITY_MIN), ConfigDef.Importance.HIGH, BALANCER_PRODUCER_IN_CAPACITY_DOC).define(BALANCER_NETWORK_OUT_CAPACITY_CONFIG, ConfigDef.Type.LONG, BALANCER_NETWORK_OUT_CAPACITY_DEFAULT, ConfigDef.Range.atLeast(BALANCER_NETWORK_OUT_CAPACITY_MIN), ConfigDef.Importance.HIGH, BALANCER_NETWORK_OUT_CAPACITY_DOC).define(BALANCER_BROKER_FAILURE_THRESHOLD_CONFIG, ConfigDef.Type.LONG, BALANCER_BROKER_FAILURE_THRESHOLD_DEFAULT, ConfigDef.Range.atLeast(-1), ConfigDef.Importance.HIGH, BALANCER_BROKER_FAILURE_THRESHOLD_DOC).define(BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG, ConfigDef.Type.LIST, BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT, ConfigDef.Importance.MEDIUM, BALANCER_EXCLUDE_TOPIC_NAMES_DOC).define(BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG, ConfigDef.Type.LIST, BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT, ConfigDef.Importance.MEDIUM, BALANCER_EXCLUDE_TOPIC_PREFIXES_DOC).define(BALANCER_DEMOTION_SUPPORT_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.MEDIUM, BALANCER_DEMOTION_SUPPORT_ENABLED_DOC).defineInternal(BALANCER_API_STATE_TOPIC_CONFIG, ConfigDef.Type.STRING, BALANCER_API_STATE_TOPIC_DEFAULT, ConfigDef.Importance.LOW, BALANCER_API_STATE_TOPIC_DOC).defineInternal(BALANCER_TOPICS_REPLICATION_FACTOR_CONFIG, ConfigDef.Type.SHORT, BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT, ConfigDef.Importance.LOW, BALANCER_TOPIC_REPLICATION_FACTOR_DOC).defineInternal(BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_CONFIG, ConfigDef.Type.INT, BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT, ConfigDef.Importance.LOW, BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DOC).defineInternal(BALANCER_REBALANCING_GOALS_CONFIG, ConfigDef.Type.LIST, "", new GoalsInitializationValidator(), ConfigDef.Importance.MEDIUM, BALANCER_REBALANCING_GOALS_DOC).defineInternal(BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG, ConfigDef.Type.DOUBLE, BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT, ConfigDef.Range.between(0.0, 1.0), ConfigDef.Importance.MEDIUM, BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DOC).defineInternal(BALANCER_TRIGGERING_GOALS_CONFIG, ConfigDef.Type.LIST, "", new GoalsInitializationValidator(), ConfigDef.Importance.MEDIUM, BALANCER_TRIGGERING_GOALS_DOC).define(BALANCER_INCREMENTAL_BALANCING_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, BALANCER_INCREMENTAL_BALANCING_ENABLED_DEFAULT, ConfigDef.Importance.HIGH, BALANCER_INCREMENTAL_BALANCING_ENABLED_DOC).defineInternal(BALANCER_INCREMENTAL_BALANCING_GOALS_CONFIG, ConfigDef.Type.LIST, "", new GoalsInitializationValidator(), ConfigDef.Importance.HIGH, BALANCER_INCREMENTAL_BALANCING_GOALS_DOC).defineInternal(BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_CONFIG, ConfigDef.Type.DOUBLE, BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_DEFAULT, ConfigDef.Range.between(0, 1), ConfigDef.Importance.HIGH, BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_DOC).defineInternal(BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_CONFIG, ConfigDef.Type.DOUBLE, BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_DEFAULT, ConfigDef.Range.between(0, 1), ConfigDef.Importance.HIGH, BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_DOC).defineInternal(BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_CONFIG, ConfigDef.Type.INT, BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_DEFAULT, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_DOC).defineInternal(BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_DEFAULT, ConfigDef.Importance.LOW, BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_DOC).define(BALANCER_RESOURCE_UTILIZATION_DETECTOR_ENABLED_CONFIG, ConfigDef.Type.BOOLEAN, false, ConfigDef.Importance.LOW, BALANCER_RESOURCE_UTILIZATION_DETECTOR_ENABLED_DOC).defineInternal(BALANCER_RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_CONFIG, ConfigDef.Type.INT, 60000, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, BALANCER_RESOURCE_UTILIZATION_DETECTOR_INTERVAL_MS_DOC).defineInternal(BALANCER_CPU_UTILIZATION_DETECTOR_DURATION_MS_CONFIG, ConfigDef.Type.INT, 600000, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, BALANCER_CPU_UTILIZATION_DETECTOR_DURATION_MS_DOC).defineInternal(BALANCER_CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, 80.0, ConfigDef.Range.between(0.0, 100.0), ConfigDef.Importance.LOW, BALANCER_CPU_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC).defineInternal(BALANCER_CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, 50.0, ConfigDef.Range.between(0.0, 100.0), ConfigDef.Importance.LOW, BALANCER_CPU_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC).defineInternal(BALANCER_DISK_UTILIZATION_DETECTOR_DURATION_MS_CONFIG, ConfigDef.Type.INT, 600000, ConfigDef.Range.atLeast(1), ConfigDef.Importance.LOW, BALANCER_DISK_UTILIZATION_DETECTOR_DURATION_MS_DOC).defineInternal(BALANCER_DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, 80.0, ConfigDef.Range.between(0.0, 100.0), ConfigDef.Importance.LOW, BALANCER_DISK_UTILIZATION_DETECTOR_OVERUTILIZATION_THRESHOLD_DOC).defineInternal(BALANCER_DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_CONFIG, ConfigDef.Type.DOUBLE, 35.0, ConfigDef.Range.between(0.0, 100.0), ConfigDef.Importance.LOW, BALANCER_DISK_UTILIZATION_DETECTOR_UNDERUTILIZATION_THRESHOLD_DOC).defineInternal(BALANCER_DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_CONFIG, ConfigDef.Type.DOUBLE, 150000.0, ConfigDef.Range.atLeast(0), ConfigDef.Importance.LOW, BALANCER_DISK_UTILIZATION_DETECTOR_RESERVED_CAPACITY_DOC).defineInternal(BALANCER_TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_CONFIG, ConfigDef.Type.LONG, 3600000L, ConfigDef.Range.atLeast(600000), ConfigDef.Importance.MEDIUM, BALANCER_TOPIC_PARTITION_MOVEMENT_EXPIRATION_MS_DOC).defineInternal(BALANCER_TOPIC_PARTITION_MAXIMUM_MOVEMENTS_CONFIG, ConfigDef.Type.INT, 5, ConfigDef.Range.atLeast(1), ConfigDef.Importance.MEDIUM, BALANCER_TOPIC_PARTITION_MAXIMUM_MOVEMENTS_DOC).defineInternal(BALANCER_TOPIC_PARTITION_SUSPENSION_MS_CONFIG, ConfigDef.Type.LONG, 10800000L, ConfigDef.Range.atLeast(600000), ConfigDef.Importance.MEDIUM, BALANCER_TOPIC_PARTITION_SUSPENSION_MS_DOC);
        return config;
    }

    public static Set<String> reconfigurableConfigs() {
        HashSet<String> configs = new HashSet<String>();
        configs.add(BALANCER_ENABLE_CONFIG);
        configs.add(BALANCER_AUTO_HEAL_MODE_CONFIG);
        configs.add(BALANCER_THROTTLE_CONFIG);
        configs.add(BALANCER_EXCLUDE_TOPIC_NAMES_CONFIG);
        configs.add(BALANCER_EXCLUDE_TOPIC_PREFIXES_CONFIG);
        configs.add(BALANCER_REBALANCING_GOALS_CONFIG);
        configs.add(BALANCER_TRIGGERING_GOALS_CONFIG);
        configs.add(BALANCER_INCREMENTAL_BALANCING_ENABLED_CONFIG);
        configs.add(BALANCER_INCREMENTAL_BALANCING_GOALS_CONFIG);
        return configs;
    }

    static {
        BALANCER_THROTTLE_MIN = BALANCER_THROTTLE_AUTO_THROTTLE = Long.valueOf(-2L);
        BALANCER_THROTTLE_DEFAULT = 0xA00000L;
        BALANCER_REPLICA_CAPACITY_DEFAULT = Integer.MAX_VALUE;
        BALANCER_DISK_CAPACITY_THRESHOLD_DEFAULT = 0.85;
        BALANCER_DISK_MIN_FREE_SPACE_DEFAULT = 0;
        BALANCER_NETWORK_IN_CAPACITY_DEFAULT = Long.MAX_VALUE;
        BALANCER_NETWORK_IN_CAPACITY_MIN = 1L;
        BALANCER_PRODUCER_IN_CAPACITY_DEFAULT = Long.MAX_VALUE;
        BALANCER_PRODUCER_IN_CAPACITY_MIN = 1L;
        BALANCER_NETWORK_OUT_CAPACITY_DEFAULT = Long.MAX_VALUE;
        BALANCER_NETWORK_OUT_CAPACITY_MIN = 1L;
        BALANCER_EXCLUDE_TOPIC_NAMES_DEFAULT = Collections.EMPTY_LIST;
        BALANCER_EXCLUDE_TOPIC_PREFIXES_DEFAULT = Collections.EMPTY_LIST;
        BALANCER_TOPICS_REPLICATION_FACTOR_DEFAULT = 3;
        BALANCER_TASK_HISTORY_RETENTION_PERIOD_DAYS_DEFAULT = 30;
        BALANCER_CAPACITY_BALANCING_DELTA_PERCENTAGE_CONFIG_DEFAULT = 0.0;
        BALANCER_INCREMENTAL_BALANCING_ENABLED_DEFAULT = false;
        BALANCER_INCREMENTAL_BALANCING_STEP_RATIO_DEFAULT = 0.2;
        BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_NUM_PROPOSALS_DEFAULT = 15;
        BALANCER_INCREMENTAL_CPU_BALANCING_TOP_PROPOSAL_TRACKING_ENABLED_DEFAULT = false;
        BALANCER_INCREMENTAL_BALANCING_LOWER_BOUND_DEFAULT = 0.02;
    }

    private static class GoalsInitializationValidator
    implements ConfigDef.Validator {
        private final ConfigDef.InstantiableClassValidator instantiableClass = new ConfigDef.InstantiableClassValidator();

        private GoalsInitializationValidator() {
        }

        @Override
        public void ensureValid(String name, Object value) {
            List goalNames = (List)value;
            for (String goalName : goalNames) {
                try {
                    Class<?> goalClass = Class.forName(goalName);
                    this.instantiableClass.ensureValid(name, goalClass);
                }
                catch (ClassNotFoundException e) {
                    throw new BalancerMisconfigurationException(String.format("Cannot find the goal with name %s", goalName), e);
                }
            }
        }

        public String toString() {
            return this.instantiableClass.toString();
        }
    }

    public static enum BalancerSelfHealMode {
        EMPTY_BROKER,
        ANY_UNEVEN_LOAD;

    }
}

