/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.Tlv;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;

public abstract class AbstractProxyProtocolEngine
implements ProxyProtocolEngine {
    protected final Mode mode;
    protected final Logger log;
    protected boolean proxyProtocolFallbackEnabled = false;
    protected boolean proxyHeaderProcessed = false;
    protected InetAddress sourceAddress;
    protected int sourcePort = -1;

    protected AbstractProxyProtocolEngine(Mode mode, LogContext logContext) {
        this.mode = mode;
        this.log = logContext.logger(this.getClass());
    }

    @Override
    public boolean hasClientInformation() {
        return this.sourceAddress != null;
    }

    @Override
    public InetAddress clientAddress() {
        return this.sourceAddress;
    }

    @Override
    public int clientPort() {
        return this.sourcePort;
    }

    @Override
    public boolean ready() {
        return this.proxyHeaderProcessed;
    }

    @Override
    public Tlv getTlv(int type) {
        return null;
    }

    @Override
    public Mode mode() {
        return this.mode;
    }

    @Override
    public void configure(Map<String, ?> configs) {
        Map<String, ?> configMap = Collections.unmodifiableMap(configs);
        if (this.mode == Mode.SERVER) {
            this.proxyProtocolFallbackEnabled = configMap.getOrDefault("confluent.proxy.protocol.fallback.enabled", ConfluentConfigs.PROXY_PROTOCOL_FALLBACK_ENABLED_DEFAULT);
            this.log.debug("The proxy protocol engine was configured with proxyProtocolFallbackEnabled: {}", (Object)this.proxyProtocolFallbackEnabled);
        } else if (this.mode == Mode.CLIENT) {
            String configuredClientAddress = (String)configMap.get("confluent.proxy.protocol.client.address");
            if (Utils.isBlank(configuredClientAddress)) {
                throw new ConfigException("The proxy source address (confluent.proxy.protocol.client.address) was not configured");
            }
            try {
                this.sourceAddress = InetAddress.getByName(configuredClientAddress);
            }
            catch (UnknownHostException e) {
                throw new ConfigException("The proxy source address \"" + configuredClientAddress + "\" (" + "confluent.proxy.protocol.client.address" + ") was invalid", (Object)e);
            }
            if (configMap.get("confluent.proxy.protocol.client.port") == null) {
                throw new ConfigException("The proxy source port (confluent.proxy.protocol.client.port) was not configured");
            }
            Integer configuredClientPort = (Integer)configMap.get("confluent.proxy.protocol.client.port");
            if (AbstractProxyProtocolEngine.isPortInvalid(configuredClientPort)) {
                throw new ConfigException("The proxy source port (" + configuredClientPort + ") was invalid");
            }
            this.sourcePort = configuredClientPort;
            this.log.debug("The proxy protocol engine was configured with sourceAddress: {}, sourcePort: {}", (Object)this.sourceAddress, (Object)this.sourcePort);
        } else {
            this.log.warn("The proxy protocol engine was not configured because mode: {}", (Object)this.mode);
        }
    }

    protected abstract IOException invalidProtocolHeaderException(String var1);

    protected void validateAddressesAndPorts(InetAddress destinationAddress, int destinationPort) throws IOException {
        if (this.sourceAddress == null) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source address was not configured");
        }
        if (destinationAddress == null) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy destination address was null");
        }
        if (!destinationAddress.getClass().equals(this.sourceAddress.getClass())) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source address type (" + this.sourceAddress.getClass().getName() + ") and the destination address type (" + destinationAddress.getClass().getName() + ") did not match");
        }
        if (this.sourcePort == -1) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source port was not configured");
        }
        if (AbstractProxyProtocolEngine.isPortInvalid(this.sourcePort)) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy source port (" + this.sourcePort + ") was invalid");
        }
        if (AbstractProxyProtocolEngine.isPortInvalid(destinationPort)) {
            throw this.invalidProtocolHeaderException("The PROXY header could not be formatted because the proxy destination port (" + destinationPort + ") was invalid");
        }
    }

    protected static boolean isPortInvalid(Integer port) {
        return port == null || port < 0 || port > 65535;
    }
}

