/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.util.HashSet;
import org.apache.kafka.common.TopicIdPartition;

public class ProduceConsumeAuditLogTracker {
    private HashSet<TopicIdPartition> produceAuditLogTracker;
    private HashSet<TopicIdPartition> consumeAuditLogTracker;

    public Boolean hasProduceTopicIdPartition(TopicIdPartition topicIdPartition) {
        this.initializeProduceAuditLogTracker();
        return this.produceAuditLogTracker.contains(topicIdPartition);
    }

    public int produceAuditLogTrackerSize() {
        this.initializeProduceAuditLogTracker();
        return this.produceAuditLogTracker.size();
    }

    public Boolean hasConsumeTopicIdPartition(TopicIdPartition topicIdPartition) {
        this.initializeConsumeAuditLogTracker();
        return this.consumeAuditLogTracker.contains(topicIdPartition);
    }

    public int consumeAuditLogTrackerSize() {
        this.initializeConsumeAuditLogTracker();
        return this.consumeAuditLogTracker.size();
    }

    public void addProduceTopicIdPartition(TopicIdPartition topicIdPartition) {
        this.initializeProduceAuditLogTracker();
        this.produceAuditLogTracker.add(topicIdPartition);
    }

    public void addConsumeTopicIdPartition(TopicIdPartition topicIdPartition) {
        this.initializeConsumeAuditLogTracker();
        this.consumeAuditLogTracker.add(topicIdPartition);
    }

    private void initializeProduceAuditLogTracker() {
        if (this.produceAuditLogTracker == null) {
            this.produceAuditLogTracker = new HashSet();
        }
    }

    private void initializeConsumeAuditLogTracker() {
        if (this.consumeAuditLogTracker == null) {
            this.consumeAuditLogTracker = new HashSet();
        }
    }
}

