/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.kafka.common.network.AbstractProxyProtocolEngine;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.utils.LogContext;

public class ProxyProtocolV2Engine
extends AbstractProxyProtocolEngine {
    private static final String INVALID_PROTOCOL_V2_HEADER = "Invalid Proxy Protocol V2 Header.";
    private static final byte[] PROTOCOL_SIGNATURE = new byte[]{13, 10, 13, 10, 0, 13, 10, 81, 85, 73, 84, 10};
    private static final int MAX_LENGTH = 52;
    private boolean protocolSignatureDetected = false;
    private final StringBuilder stringBuilder = new StringBuilder();
    private boolean isLocalConnection = false;
    private byte protocolByte;
    private int bytesRead;
    private int addressLength;
    private byte[] addressBytes;

    public ProxyProtocolV2Engine(Mode mode, LogContext logContext) {
        super(mode, logContext);
    }

    @Override
    public void processHeaders(ByteBuffer buf) throws IOException {
        if (!this.protocolSignatureDetected) {
            if (buf.remaining() < PROTOCOL_SIGNATURE.length) {
                return;
            }
            for (byte signatureByte : PROTOCOL_SIGNATURE) {
                byte bufferByte = buf.get();
                ++this.bytesRead;
                if (bufferByte != signatureByte) {
                    if (this.proxyProtocolFallbackEnabled) {
                        buf.position(0);
                        this.proxyHeaderProcessed = true;
                        this.bytesRead = 0;
                        return;
                    }
                    throw new IOException(INVALID_PROTOCOL_V2_HEADER);
                }
                this.stringBuilder.append((char)bufferByte);
            }
            this.protocolSignatureDetected = true;
        }
        this.parseConnectionInformation(buf);
        while (buf.hasRemaining() && this.bytesRead - 16 < this.addressLength) {
            int currentAddressIndex = this.bytesRead - 16;
            this.addressBytes[currentAddressIndex] = buf.get();
            ++this.bytesRead;
        }
        if (this.bytesRead == 16 + this.addressLength && !this.proxyHeaderProcessed) {
            this.decodeProxyProtocol();
        }
    }

    private void parseConnectionInformation(ByteBuffer buf) throws IOException {
        while (buf.hasRemaining() && this.bytesRead < 16) {
            byte currentByte = buf.get();
            ++this.bytesRead;
            switch (this.bytesRead) {
                case 13: {
                    int command = currentByte & 0xF;
                    int version = currentByte >> 4;
                    if (version != 2) {
                        throw new IOException(INVALID_PROTOCOL_V2_HEADER);
                    }
                    if (command == 0) {
                        this.isLocalConnection = true;
                        break;
                    }
                    if (command == 1) {
                        this.isLocalConnection = false;
                        break;
                    }
                    throw new IOException(INVALID_PROTOCOL_V2_HEADER);
                }
                case 14: {
                    this.protocolByte = currentByte;
                    break;
                }
                case 15: {
                    byte byte16 = buf.get();
                    ++this.bytesRead;
                    this.addressLength = (currentByte & 0xFF) << 8 | byte16 & 0xFF;
                    this.addressBytes = new byte[this.addressLength];
                }
            }
        }
    }

    private void decodeProxyProtocol() throws IOException {
        switch (this.protocolByte) {
            case 17: {
                this.sourceAddress = Inet4Address.getByAddress(Arrays.copyOfRange(this.addressBytes, 0, 4));
                this.sourcePort = (this.addressBytes[8] & 0xFF) << 8 | this.addressBytes[9] & 0xFF;
                break;
            }
            case 33: {
                this.sourceAddress = Inet6Address.getByAddress(Arrays.copyOfRange(this.addressBytes, 0, 16));
                this.sourcePort = (this.addressBytes[32] & 0xFF) << 8 | this.addressBytes[33] & 0xFF;
                break;
            }
            default: {
                if (this.isLocalConnection) break;
                throw new IOException(INVALID_PROTOCOL_V2_HEADER);
            }
        }
        this.proxyHeaderProcessed = true;
    }

    @Override
    protected IOException invalidProtocolHeaderException(String s) {
        return new IOException("Invalid Proxy Protocol V2 Header. " + s);
    }

    @Override
    public void emitHeaders(ByteBuffer buf, InetAddress destinationAddress, int destinationPort) throws IOException {
        this.validateAddressesAndPorts(destinationAddress, destinationPort);
        byte transportProtocolAndFamily = (byte)(destinationAddress instanceof Inet4Address ? 17 : 33);
        byte addressByteLength = (byte)(destinationAddress instanceof Inet4Address ? 12 : 36);
        byte protocolVersionAndCommand = 33;
        buf.put(PROTOCOL_SIGNATURE);
        buf.put(protocolVersionAndCommand);
        buf.put(transportProtocolAndFamily);
        buf.putShort(addressByteLength);
        buf.put(this.sourceAddress.getAddress());
        buf.put(destinationAddress.getAddress());
        buf.put(ProxyProtocolV2Engine.portBytes(this.sourcePort));
        buf.put(ProxyProtocolV2Engine.portBytes(destinationPort));
        this.proxyHeaderProcessed = true;
    }

    @Override
    public int maxHeaderSize() {
        return 52;
    }

    private static byte[] portBytes(int port) {
        byte[] buf = new byte[]{(byte)(port >> 8 & 0xFF), (byte)(port & 0xFF)};
        return buf;
    }
}

