/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.SSLEngine;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.SslConfigs;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.network.AsyncAuthExecutor;
import org.apache.kafka.common.network.Authenticator;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.ChannelBuilders;
import org.apache.kafka.common.network.ChannelMetadataRegistry;
import org.apache.kafka.common.network.KafkaChannel;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.ListenerReconfigurable;
import org.apache.kafka.common.network.Mode;
import org.apache.kafka.common.network.ProxyProtocolEngine;
import org.apache.kafka.common.network.ProxyProtocolEngineFactory;
import org.apache.kafka.common.network.SslTransportLayer;
import org.apache.kafka.common.security.auth.AuthenticationContext;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipalBuilder;
import org.apache.kafka.common.security.auth.KafkaPrincipalSerde;
import org.apache.kafka.common.security.auth.SslAuthenticationContext;
import org.apache.kafka.common.security.auth.SslEngineFactory;
import org.apache.kafka.common.security.ssl.SslFactory;
import org.apache.kafka.common.security.ssl.SslPrincipalMapper;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.interceptor.BrokerInterceptor;
import org.slf4j.Logger;

public class SslChannelBuilder
implements ChannelBuilder,
ListenerReconfigurable {
    private static final String SECURITY_MECHANISM = "SSL";
    private final ListenerName listenerName;
    private final boolean isInterBrokerListener;
    private SslFactory sslFactory;
    private final Mode mode;
    private Map<String, ?> configs;
    private SslPrincipalMapper sslPrincipalMapper;
    private final Logger log;
    private final ProxyProtocolEngineFactory proxyProtocolEngineFactory;

    public SslChannelBuilder(Mode mode, ListenerName listenerName, boolean isInterBrokerListener, LogContext logContext, ProxyProtocolEngineFactory proxyProtocolEngineFactory) {
        this.mode = mode;
        this.listenerName = listenerName;
        this.isInterBrokerListener = isInterBrokerListener;
        this.log = logContext.logger(this.getClass());
        this.proxyProtocolEngineFactory = proxyProtocolEngineFactory;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            String sslPrincipalMappingRules = (String)configs.get("ssl.principal.mapping.rules");
            if (sslPrincipalMappingRules != null) {
                this.sslPrincipalMapper = SslPrincipalMapper.fromRules(sslPrincipalMappingRules);
            }
            this.sslFactory = new SslFactory(this.mode, null, this.isInterBrokerListener);
            this.sslFactory.configure(this.configs);
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return SslConfigs.RECONFIGURABLE_CONFIGS;
    }

    @Override
    public void validateReconfiguration(Map<String, ?> configs) {
        this.sslFactory.validateReconfiguration(configs);
    }

    @Override
    public void reconfigure(Map<String, ?> configs) {
        this.sslFactory.reconfigure(configs);
    }

    @Override
    public ListenerName listenerName() {
        return this.listenerName;
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize, AsyncAuthExecutor asyncAuthExecutor, MemoryPool memoryPool, ChannelMetadataRegistry metadataRegistry, Time time) throws KafkaException {
        try {
            SslTransportLayer transportLayer = this.buildTransportLayer(this.sslFactory, id, key, metadataRegistry, this.proxyProtocolEngineFactory.createProxyProtocolEngine());
            BrokerInterceptor interceptor = ConfluentConfigs.buildBrokerInterceptor(this.mode, this.configs);
            Supplier<Authenticator> authenticatorCreator = () -> new SslAuthenticator(this.configs, transportLayer, this.listenerName, this.sslPrincipalMapper);
            return new KafkaChannel(id, transportLayer, authenticatorCreator, maxReceiveSize, asyncAuthExecutor, memoryPool != null ? memoryPool : MemoryPool.NONE, metadataRegistry, interceptor, time);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public Set<String> securityMechanisms() {
        return Collections.singleton(SECURITY_MECHANISM);
    }

    @Override
    public void close() {
        if (this.sslFactory != null) {
            this.sslFactory.close();
        }
    }

    SslEngineFactory sslEngineFactory() {
        return this.sslFactory.sslEngineFactory();
    }

    protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key, ChannelMetadataRegistry metadataRegistry, ProxyProtocolEngine proxyProtocolEngine) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        SSLEngine engine = sslFactory.createSslEngine(socketChannel.socket());
        return SslTransportLayer.create(id, key, engine, metadataRegistry, sslFactory.createCloseableSslEngine(engine), this.mode, false, proxyProtocolEngine);
    }

    private static class SslAuthenticator
    implements Authenticator {
        private final SslTransportLayer transportLayer;
        private final KafkaPrincipalBuilder principalBuilder;
        private final ListenerName listenerName;

        private SslAuthenticator(Map<String, ?> configs, SslTransportLayer transportLayer, ListenerName listenerName, SslPrincipalMapper sslPrincipalMapper) {
            this.transportLayer = transportLayer;
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs, null, sslPrincipalMapper);
            this.listenerName = listenerName;
        }

        @Override
        public void authenticate() {
        }

        @Override
        public KafkaPrincipal principal() {
            return this.principalBuilder.build(this.authenticationContext());
        }

        @Override
        public Optional<KafkaPrincipalSerde> principalSerde() {
            return this.principalBuilder instanceof KafkaPrincipalSerde ? Optional.of((KafkaPrincipalSerde)((Object)this.principalBuilder)) : Optional.empty();
        }

        @Override
        public void close() throws IOException {
            if (this.principalBuilder instanceof Closeable) {
                Utils.closeQuietly((Closeable)((Object)this.principalBuilder), "principal builder");
            }
        }

        @Override
        public boolean complete() {
            return true;
        }

        @Override
        public AuthenticationContext authenticationContext() {
            InetAddress clientAddress = this.transportLayer.socketChannel().socket().getInetAddress();
            if (this.listenerName == null) {
                throw new IllegalStateException("Unexpected call to principal()/authenticationContext() when listenerName is null");
            }
            return new SslAuthenticationContext(this.transportLayer.sslSession(), clientAddress, this.listenerName.value());
        }

        @Override
        public String securityMechanism() {
            return SslChannelBuilder.SECURITY_MECHANISM;
        }
    }
}

