/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.internals.ExclusionRequestUtils;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterBrokerHealthRequestData;
import org.apache.kafka.common.message.AlterBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AlterBrokerHealthResponse;
import org.apache.kafka.common.requests.ApiError;

public class AlterBrokerHealthRequest
extends AbstractRequest {
    private final AlterBrokerHealthRequestData data;

    public AlterBrokerHealthRequest(AlterBrokerHealthRequestData data, short apiVersion) {
        super(ApiKeys.ALTER_BROKER_HEALTH, apiVersion);
        this.data = data;
    }

    @Override
    public AlterBrokerHealthRequestData data() {
        return this.data;
    }

    @Override
    public AlterBrokerHealthResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        List<AlterBrokerHealthResponseData.BrokerHealthStatusResult> resultList = this.data.brokerIds().stream().map(brokerId -> new AlterBrokerHealthResponseData.BrokerHealthStatusResult().setBrokerId((int)brokerId).setErrorCode(apiError.error().code()).setErrorMessage(apiError.error().message()).setStatusCode(this.data.statusCode())).collect(Collectors.toList());
        AlterBrokerHealthResponseData responseData = new AlterBrokerHealthResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs).setBrokerHealthStatusResults(resultList);
        return new AlterBrokerHealthResponse(responseData);
    }

    public static AlterBrokerHealthRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AlterBrokerHealthRequest(new AlterBrokerHealthRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    private boolean hasValidBrokerIds() {
        if (this.data.brokerIds().isEmpty()) {
            return false;
        }
        for (Integer brokerId : this.data.brokerIds()) {
            if (brokerId >= 0) continue;
            return false;
        }
        return true;
    }

    public void validate() throws InvalidRequestException {
        if (!this.hasValidBrokerIds()) {
            throw Errors.INVALID_REQUEST.exception("Invalid brokerIds: " + this.data.brokerIds() + " must be a non-empty list where every brokerId is a non-negative integer.");
        }
        if (!this.hasValidStatusCode()) {
            throw Errors.INVALID_REQUEST.exception("Invalid statusCode: " + this.data.statusCode() + ". Valid values for statusCode are degraded (0) or healthy (1).");
        }
        try {
            ExclusionRequestUtils.validateNonEmptyReason(this.data.reason());
        }
        catch (IllegalArgumentException e) {
            throw Errors.INVALID_REQUEST.exception(e.getMessage());
        }
    }

    private boolean hasValidReason() {
        return this.data.reason().matches("^[a-zA-Z_-][\\.a-zA-Z0-9_-]{0,31}$");
    }

    private boolean hasValidStatusCode() {
        return this.data.statusCode() == 0 || this.data.statusCode() == 1;
    }

    public static class Builder
    extends AbstractRequest.Builder<AlterBrokerHealthRequest> {
        private final AlterBrokerHealthRequestData data;

        public Builder(AlterBrokerHealthRequestData data) {
            super(ApiKeys.ALTER_BROKER_HEALTH);
            this.data = data;
        }

        public Builder(short oldestAllowedVersion, AlterBrokerHealthRequestData data) {
            super(ApiKeys.ALTER_BROKER_HEALTH, oldestAllowedVersion, ApiKeys.ALTER_BROKER_HEALTH.latestVersion());
            this.data = data;
        }

        public Builder(short oldestAllowedVersion, short newestAllowedVersion, AlterBrokerHealthRequestData data) {
            super(ApiKeys.ALTER_BROKER_HEALTH, oldestAllowedVersion, newestAllowedVersion);
            this.data = data;
        }

        @Override
        public AlterBrokerHealthRequest build(short version) {
            return new AlterBrokerHealthRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

