/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.kafka.clients.NodeApiVersions;
import org.apache.kafka.common.feature.Features;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.message.ApiMessageType;
import org.apache.kafka.common.message.ApiVersionsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.record.RecordVersion;
import org.apache.kafka.common.requests.AbstractResponse;

public class ApiVersionsResponse
extends AbstractResponse {
    public static final long UNKNOWN_FINALIZED_FEATURES_EPOCH = -1L;
    private final ApiVersionsResponseData data;

    public ApiVersionsResponse(ApiVersionsResponseData data) {
        super(ApiKeys.API_VERSIONS);
        this.data = data;
    }

    @Override
    public ApiVersionsResponseData data() {
        return this.data;
    }

    public ApiVersionsResponseData.ApiVersion apiVersion(short apiKey) {
        return this.data.apiKeys().find(apiKey);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    public boolean zkMigrationReady() {
        return this.data.zkMigrationReady();
    }

    public static ApiVersionsResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        int prev = buffer.position();
        try {
            return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), version, context));
        }
        catch (RuntimeException e) {
            buffer.position(prev);
            if (version != 0) {
                return new ApiVersionsResponse(new ApiVersionsResponseData(new ByteBufferAccessor(buffer), 0, context));
            }
            throw e;
        }
    }

    public static ApiVersionsResponse defaultApiVersionsResponse(ApiMessageType.ListenerType listenerType) {
        return ApiVersionsResponse.defaultApiVersionsResponse(0, listenerType);
    }

    public static ApiVersionsResponse defaultApiVersionsResponse(int throttleTimeMs, ApiMessageType.ListenerType listenerType) {
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, ApiVersionsResponse.filterApis(RecordVersion.current(), listenerType), Features.emptySupportedFeatures());
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, ApiVersionsResponseData.ApiVersionCollection apiVersions) {
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, apiVersions, Features.emptySupportedFeatures());
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, ApiVersionsResponseData.ApiVersionCollection apiVersions, Features<SupportedVersionRange> latestSupportedFeatures) {
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, apiVersions, latestSupportedFeatures, Collections.emptyMap(), -1L);
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, RecordVersion minRecordVersion, Features<SupportedVersionRange> latestSupportedFeatures, Map<String, Short> finalizedFeatures, long finalizedFeaturesEpoch, NodeApiVersions controllerApiVersions, ApiMessageType.ListenerType listenerType) {
        ApiVersionsResponseData.ApiVersionCollection apiKeys = controllerApiVersions != null ? ApiVersionsResponse.intersectForwardableApis(listenerType, minRecordVersion, controllerApiVersions.allSupportedApiVersions()) : ApiVersionsResponse.filterApis(minRecordVersion, listenerType);
        return ApiVersionsResponse.createApiVersionsResponse(throttleTimeMs, apiKeys, latestSupportedFeatures, finalizedFeatures, finalizedFeaturesEpoch);
    }

    public static ApiVersionsResponse createApiVersionsResponse(int throttleTimeMs, ApiVersionsResponseData.ApiVersionCollection apiVersions, Features<SupportedVersionRange> latestSupportedFeatures, Map<String, Short> finalizedFeatures, long finalizedFeaturesEpoch) {
        return new ApiVersionsResponse(ApiVersionsResponse.createApiVersionsResponseData(throttleTimeMs, Errors.NONE, apiVersions, latestSupportedFeatures, finalizedFeatures, finalizedFeaturesEpoch));
    }

    public static ApiVersionsResponseData.ApiVersionCollection filterApis(RecordVersion minRecordVersion, ApiMessageType.ListenerType listenerType) {
        ApiVersionsResponseData.ApiVersionCollection apiKeys = new ApiVersionsResponseData.ApiVersionCollection();
        for (ApiKeys apiKey : ApiKeys.apisForListener(listenerType)) {
            if (apiKey.minRequiredInterBrokerMagic > minRecordVersion.value) continue;
            apiKeys.add(ApiVersionsResponse.toApiVersion(apiKey));
        }
        return apiKeys;
    }

    public static ApiVersionsResponseData.ApiVersionCollection collectApis(Set<ApiKeys> apiKeys) {
        ApiVersionsResponseData.ApiVersionCollection res = new ApiVersionsResponseData.ApiVersionCollection();
        for (ApiKeys apiKey : apiKeys) {
            res.add(ApiVersionsResponse.toApiVersion(apiKey));
        }
        return res;
    }

    public static ApiVersionsResponseData.ApiVersionCollection intersectForwardableApis(ApiMessageType.ListenerType listenerType, RecordVersion minRecordVersion, Map<ApiKeys, ApiVersionsResponseData.ApiVersion> activeControllerApiVersions) {
        ApiVersionsResponseData.ApiVersionCollection apiKeys = new ApiVersionsResponseData.ApiVersionCollection();
        for (ApiKeys apiKey : ApiKeys.apisForListener(listenerType)) {
            ApiVersionsResponseData.ApiVersion finalApiVersion;
            if (apiKey.minRequiredInterBrokerMagic > minRecordVersion.value) continue;
            ApiVersionsResponseData.ApiVersion brokerApiVersion = ApiVersionsResponse.toApiVersion(apiKey);
            if (!apiKey.forwardable) {
                finalApiVersion = brokerApiVersion;
            } else {
                Optional<ApiVersionsResponseData.ApiVersion> intersectVersion = ApiVersionsResponse.intersect(brokerApiVersion, activeControllerApiVersions.getOrDefault((Object)apiKey, null));
                if (!intersectVersion.isPresent()) continue;
                finalApiVersion = intersectVersion.get();
            }
            apiKeys.add(finalApiVersion.duplicate());
        }
        return apiKeys;
    }

    private static ApiVersionsResponseData createApiVersionsResponseData(int throttleTimeMs, Errors error, ApiVersionsResponseData.ApiVersionCollection apiKeys, Features<SupportedVersionRange> latestSupportedFeatures, Map<String, Short> finalizedFeatures, long finalizedFeaturesEpoch) {
        ApiVersionsResponseData data = new ApiVersionsResponseData();
        data.setThrottleTimeMs(throttleTimeMs);
        data.setErrorCode(error.code());
        data.setApiKeys(apiKeys);
        data.setSupportedFeatures(ApiVersionsResponse.createSupportedFeatureKeys(latestSupportedFeatures));
        data.setFinalizedFeatures(ApiVersionsResponse.createFinalizedFeatureKeys(finalizedFeatures));
        data.setFinalizedFeaturesEpoch(finalizedFeaturesEpoch);
        return data;
    }

    public Collection<ApiVersionsResponseData.ApiVersion> apiVersions() {
        return this.data.apiKeys();
    }

    private static ApiVersionsResponseData.SupportedFeatureKeyCollection createSupportedFeatureKeys(Features<SupportedVersionRange> latestSupportedFeatures) {
        ApiVersionsResponseData.SupportedFeatureKeyCollection converted = new ApiVersionsResponseData.SupportedFeatureKeyCollection();
        for (Map.Entry<String, SupportedVersionRange> feature : latestSupportedFeatures.features().entrySet()) {
            ApiVersionsResponseData.SupportedFeatureKey key = new ApiVersionsResponseData.SupportedFeatureKey();
            SupportedVersionRange versionRange = feature.getValue();
            key.setName(feature.getKey());
            key.setMinVersion(versionRange.min());
            key.setMaxVersion(versionRange.max());
            converted.add(key);
        }
        return converted;
    }

    private static ApiVersionsResponseData.FinalizedFeatureKeyCollection createFinalizedFeatureKeys(Map<String, Short> finalizedFeatures) {
        ApiVersionsResponseData.FinalizedFeatureKeyCollection converted = new ApiVersionsResponseData.FinalizedFeatureKeyCollection();
        for (Map.Entry<String, Short> feature : finalizedFeatures.entrySet()) {
            ApiVersionsResponseData.FinalizedFeatureKey key = new ApiVersionsResponseData.FinalizedFeatureKey();
            short versionLevel = feature.getValue();
            key.setName(feature.getKey());
            key.setMinVersionLevel(versionLevel);
            key.setMaxVersionLevel(versionLevel);
            converted.add(key);
        }
        return converted;
    }

    public static Optional<ApiVersionsResponseData.ApiVersion> intersect(ApiVersionsResponseData.ApiVersion thisVersion, ApiVersionsResponseData.ApiVersion other) {
        short maxVersion;
        if (thisVersion == null || other == null) {
            return Optional.empty();
        }
        if (thisVersion.apiKey() != other.apiKey()) {
            throw new IllegalArgumentException("thisVersion.apiKey: " + thisVersion.apiKey() + " must be equal to other.apiKey: " + other.apiKey());
        }
        short minVersion = (short)Math.max(thisVersion.minVersion(), other.minVersion());
        return minVersion > (maxVersion = (short)Math.min(thisVersion.maxVersion(), other.maxVersion())) ? Optional.empty() : Optional.of(new ApiVersionsResponseData.ApiVersion().setApiKey(thisVersion.apiKey()).setMinVersion(minVersion).setMaxVersion(maxVersion));
    }

    public static ApiVersionsResponseData.ApiVersion toApiVersion(ApiKeys apiKey) {
        return new ApiVersionsResponseData.ApiVersion().setApiKey(apiKey.id).setMinVersion(apiKey.oldestVersion()).setMaxVersion(apiKey.latestVersion());
    }
}

