/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.message.AssignBrokersToCellRequestData;
import org.apache.kafka.common.message.AssignBrokersToCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AssignBrokersToCellResponse;

public class AssignBrokersToCellRequest
extends AbstractRequest {
    private final AssignBrokersToCellRequestData data;

    AssignBrokersToCellRequest(AssignBrokersToCellRequestData data, short version) {
        super(ApiKeys.ASSIGN_BROKERS_TO_CELL, version);
        this.data = data;
    }

    @Override
    public AssignBrokersToCellRequestData data() {
        return this.data;
    }

    public List<Integer> brokers() {
        return this.data.brokerIds();
    }

    public int cellId() {
        return this.data.cellId();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        return new AssignBrokersToCellResponse(new AssignBrokersToCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(t).code()));
    }

    public static AssignBrokersToCellRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AssignBrokersToCellRequest(new AssignBrokersToCellRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AssignBrokersToCellRequest> {
        private final AssignBrokersToCellRequestData data;

        public Builder() {
            super(ApiKeys.ASSIGN_BROKERS_TO_CELL);
            this.data = new AssignBrokersToCellRequestData();
        }

        public Builder(AssignBrokersToCellRequestData data) {
            super(ApiKeys.ASSIGN_BROKERS_TO_CELL);
            this.data = data;
        }

        public Builder setBrokers(List<Integer> brokers) {
            this.data.setBrokerIds(brokers);
            return this;
        }

        public Builder setCellId(int cellId) {
            this.data.setCellId(cellId);
            return this;
        }

        @Override
        public AssignBrokersToCellRequest build(short version) {
            return new AssignBrokersToCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

