/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.message.AssignTenantsToCellRequestData;
import org.apache.kafka.common.message.AssignTenantsToCellResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.AssignTenantsToCellResponse;

public class AssignTenantsToCellRequest
extends AbstractRequest {
    private final AssignTenantsToCellRequestData data;

    AssignTenantsToCellRequest(AssignTenantsToCellRequestData data, short version) {
        super(ApiKeys.ASSIGN_TENANTS_TO_CELL, version);
        this.data = data;
    }

    @Override
    public AssignTenantsToCellRequestData data() {
        return this.data;
    }

    public List<AssignTenantsToCellRequestData.TenantToCellAssignment> tenantToAssign() {
        return this.data.tenantsToAssign();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        return new AssignTenantsToCellResponse(new AssignTenantsToCellResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(t).code()));
    }

    public static AssignTenantsToCellRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new AssignTenantsToCellRequest(new AssignTenantsToCellRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<AssignTenantsToCellRequest> {
        private final AssignTenantsToCellRequestData data;

        public Builder() {
            super(ApiKeys.ASSIGN_TENANTS_TO_CELL);
            this.data = new AssignTenantsToCellRequestData();
        }

        public Builder(AssignTenantsToCellRequestData data) {
            super(ApiKeys.ASSIGN_TENANTS_TO_CELL);
            this.data = data;
        }

        public Builder setTenants(List<AssignTenantsToCellRequestData.TenantToCellAssignment> assignments) {
            this.data.setTenantsToAssign(assignments);
            return this;
        }

        @Override
        public AssignTenantsToCellRequest build(short version) {
            return new AssignTenantsToCellRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

