/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.DegradedBroker;
import org.apache.kafka.clients.admin.DemotedBroker;
import org.apache.kafka.common.internals.KafkaFutureImpl;
import org.apache.kafka.common.message.DescribeBrokerHealthResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractResponse;

public class DescribeBrokerHealthResponse
extends AbstractResponse {
    private final DescribeBrokerHealthResponseData data;

    public DescribeBrokerHealthResponse(DescribeBrokerHealthResponseData data) {
        super(ApiKeys.DESCRIBE_BROKER_HEALTH);
        this.data = data;
    }

    public void complete(KafkaFutureImpl<Collection<DegradedBroker>> result) {
        Collection degradedBrokers = this.data.degradedBrokers().stream().map(broker -> new DegradedBroker(broker.brokerId(), broker.reasons().stream().map(DescribeBrokerHealthResponseData.Reason::reason).collect(Collectors.toList()))).collect(Collectors.toList());
        result.complete(degradedBrokers);
    }

    public void completeV0(KafkaFutureImpl<Collection<DemotedBroker>> result) {
        Collection demotedBrokers = this.data.degradedBrokers().stream().map(broker -> new DemotedBroker(broker.brokerId(), broker.reasons().stream().map(DescribeBrokerHealthResponseData.Reason::reason).collect(Collectors.toList()))).collect(Collectors.toList());
        result.complete(demotedBrokers);
    }

    @Override
    public DescribeBrokerHealthResponseData data() {
        return this.data;
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return Collections.singletonMap(Errors.forCode(this.data.errorCode()), 1);
    }

    @Override
    public String toString() {
        return this.data.toString();
    }

    public static DescribeBrokerHealthResponse parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeBrokerHealthResponse(new DescribeBrokerHealthResponseData(new ByteBufferAccessor(buffer), version, context));
    }
}

