/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.message.DescribeCellLoadRequestData;
import org.apache.kafka.common.message.DescribeCellLoadResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeCellLoadResponse;

public class DescribeCellLoadRequest
extends AbstractRequest {
    private final DescribeCellLoadRequestData data;

    DescribeCellLoadRequest(DescribeCellLoadRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CELL_LOAD, version);
        this.data = data;
    }

    @Override
    public DescribeCellLoadRequestData data() {
        return this.data;
    }

    public List<Integer> cellIds() {
        return this.data.cellIds();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        return new DescribeCellLoadResponse(new DescribeCellLoadResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(t).code()));
    }

    public static DescribeCellLoadRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeCellLoadRequest(new DescribeCellLoadRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeCellLoadRequest> {
        private final DescribeCellLoadRequestData data;

        public Builder() {
            super(ApiKeys.DESCRIBE_CELL_LOAD);
            this.data = new DescribeCellLoadRequestData();
        }

        public Builder(DescribeCellLoadRequestData data) {
            super(ApiKeys.DESCRIBE_CELL_LOAD);
            this.data = data;
        }

        public Builder setCellId(List<Integer> cellIds) {
            this.data.setCellIds(cellIds);
            return this;
        }

        @Override
        public DescribeCellLoadRequest build(short version) {
            return new DescribeCellLoadRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

