/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kafka.common.message.DescribeCellsRequestData;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.DescribeCellsResponse;

public class DescribeCellsRequest
extends AbstractRequest {
    private final DescribeCellsRequestData data;

    DescribeCellsRequest(DescribeCellsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_CELLS, version);
        this.data = data;
    }

    @Override
    public DescribeCellsRequestData data() {
        return this.data;
    }

    public List<Integer> cellIds() {
        return this.data.cellIds();
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable t) {
        return new DescribeCellsResponse(new DescribeCellsResponseData().setThrottleTimeMs(throttleTimeMs).setErrorCode(Errors.forException(t).code()));
    }

    public static DescribeCellsRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new DescribeCellsRequest(new DescribeCellsRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeCellsRequest> {
        private final DescribeCellsRequestData data;

        public Builder() {
            super(ApiKeys.DESCRIBE_CELLS);
            this.data = new DescribeCellsRequestData();
        }

        public Builder(DescribeCellsRequestData data) {
            super(ApiKeys.DESCRIBE_CELLS);
            this.data = data;
        }

        public Builder setCellId(List<Integer> cellIds) {
            this.data.setCellIds(cellIds);
            return this;
        }

        @Override
        public DescribeCellsRequest build(short version) {
            return new DescribeCellsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

