/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.link;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Value;

public class ClusterLinkMetricsUtils {
    public static final String CLUSTER_LINK_METRICS_GROUP = "cluster-link-metrics";
    public static final String LINK_NAME_TAG = "link-name";
    public static final String LINK_ID_TAG = "link-id";
    public static final String LINK_MODE_TAG = "mode";
    public static final String STATE_TAG = "state";
    public static final String TENANT_TAG = "tenant";
    public static final String TOPIC_TAG = "topic";
    public static final String PARTITION_TAG = "partition";
    public static final String REASON_TAG = "reason";
    public static final String DEPLOYED_LINK_TYPE = "deployed-link-type";
    public static final String CONNECTION_MODE_TAG = "connection-mode";

    public static Sensor createActiveLinkCountSensor(Metrics metrics, UUID linkId, String linkMode, Map<String, String> additionalTags, String additionalSensorSuffix, long expirySeconds) {
        HashMap<String, String> tags = new HashMap<String, String>(additionalTags.size() + 2);
        tags.put(LINK_MODE_TAG, linkMode);
        tags.put(LINK_ID_TAG, linkId.toString());
        tags.putAll(additionalTags);
        MetricName metricName = metrics.metricName("active-link-count", CLUSTER_LINK_METRICS_GROUP, String.format("Number of unique %s cluster links in this cluster", linkMode), tags);
        String sensorName = String.format("%s-cluster-link-count-%s%s", linkMode, linkId, additionalSensorSuffix);
        Sensor sensor = metrics.sensor(sensorName, metrics.config(), expirySeconds, new Sensor[0]);
        sensor.add(metricName, new Value());
        return sensor;
    }
}

