/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.EntityType;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.ImplicitLinkedHashMultiCollection;

public class ProduceResponseData
implements ApiMessage {
    TopicProduceResponseCollection responses;
    int throttleTimeMs;
    NodeEndpointCollection nodeEndpoints;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_0), "Each produce response"));
    public static final Schema SCHEMA_1 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_0), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
    public static final Schema SCHEMA_2;
    public static final Schema SCHEMA_3;
    public static final Schema SCHEMA_4;
    public static final Schema SCHEMA_5;
    public static final Schema SCHEMA_6;
    public static final Schema SCHEMA_7;
    public static final Schema SCHEMA_8;
    public static final Schema SCHEMA_9;
    public static final Schema SCHEMA_10;
    public static final Schema SCHEMA_11;
    public static final Schema[] SCHEMAS;
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 11;

    public ProduceResponseData(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public ProduceResponseData() {
        this.responses = new TopicProduceResponseCollection(0);
        this.throttleTimeMs = 0;
        this.nodeEndpoints = new NodeEndpointCollection(0);
    }

    @Override
    public short apiKey() {
        return 0;
    }

    @Override
    public short lowestSupportedVersion() {
        return 0;
    }

    @Override
    public short highestSupportedVersion() {
        return 11;
    }

    @Override
    public final void read(Readable _readable, short _version, MessageContext _context) {
        int i;
        TopicProduceResponseCollection newCollection;
        int arrayLength;
        if (_version >= 9) {
            arrayLength = _readable.readUnsignedVarint() - 1;
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new TopicProduceResponseCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicProduceResponse(_readable, _version, _context));
            }
            this.responses = newCollection;
        } else {
            arrayLength = _readable.readInt();
            if (arrayLength < 0) {
                throw new RuntimeException("non-nullable field responses was serialized as null");
            }
            if (arrayLength > _readable.remaining()) {
                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
            }
            newCollection = new TopicProduceResponseCollection(arrayLength);
            for (i = 0; i < arrayLength; ++i) {
                newCollection.add(new TopicProduceResponse(_readable, _version, _context));
            }
            this.responses = newCollection;
        }
        this.throttleTimeMs = _version >= 1 ? _readable.readInt() : 0;
        this.nodeEndpoints = new NodeEndpointCollection(0);
        this._unknownTaggedFields = null;
        if (_version >= 9) {
            int _numTaggedFields = _readable.readUnsignedVarint();
            block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    case 0: {
                        if (_version >= 10) {
                            int arrayLength2 = _readable.readUnsignedVarint() - 1;
                            if (arrayLength2 < 0) {
                                throw new RuntimeException("non-nullable field nodeEndpoints was serialized as null");
                            }
                            if (arrayLength2 > _readable.remaining()) {
                                throw new RuntimeException("Tried to allocate a collection of size " + arrayLength2 + ", but there are only " + _readable.remaining() + " bytes remaining.");
                            }
                            NodeEndpointCollection newCollection2 = new NodeEndpointCollection(arrayLength2);
                            for (int i2 = 0; i2 < arrayLength2; ++i2) {
                                newCollection2.add(new NodeEndpoint(_readable, _version, _context));
                            }
                            this.nodeEndpoints = newCollection2;
                            continue block5;
                        }
                        throw new RuntimeException("Tag 0 is not valid for version " + _version);
                    }
                    default: {
                        this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                    }
                }
            }
        }
    }

    @Override
    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 9) {
            _writable.writeUnsignedVarint(this.responses.size() + 1);
            for (TopicProduceResponse responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version, _context);
            }
        } else {
            _writable.writeInt(this.responses.size());
            for (TopicProduceResponse responsesElement : this.responses) {
                responsesElement.write(_writable, _cache, _version, _context);
            }
        }
        if (_version >= 1) {
            _writable.writeInt(this.throttleTimeMs);
        }
        if (_version >= 10) {
            if (!this.nodeEndpoints.isEmpty()) {
                ++_numTaggedFields;
            }
        } else if (!this.nodeEndpoints.isEmpty()) {
            throw new UnsupportedVersionException("Attempted to write a non-default nodeEndpoints at version " + _version);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _numTaggedFields += _rawWriter.numFields();
        if (_version >= 9) {
            _writable.writeUnsignedVarint(_numTaggedFields);
            if (_version >= 10 && !this.nodeEndpoints.isEmpty()) {
                _writable.writeUnsignedVarint(0);
                _writable.writeUnsignedVarint(_cache.getArraySizeInBytes(this.nodeEndpoints));
                _writable.writeUnsignedVarint(this.nodeEndpoints.size() + 1);
                for (NodeEndpoint nodeEndpointsElement : this.nodeEndpoints) {
                    nodeEndpointsElement.write(_writable, _cache, _version, _context);
                }
            }
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    @Override
    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        int _numTaggedFields = 0;
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.responses.size() + 1));
        } else {
            _size.addBytes(4);
        }
        for (Object responsesElement : this.responses) {
            ((TopicProduceResponse)responsesElement).addSize(_size, _cache, _version, _context);
        }
        if (_version >= 1) {
            _size.addBytes(4);
        }
        if (_version >= 10 && !this.nodeEndpoints.isEmpty()) {
            ++_numTaggedFields;
            _size.addBytes(1);
            int _sizeBeforeArray = _size.totalSize();
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.nodeEndpoints.size() + 1));
            for (NodeEndpoint nodeEndpointsElement : this.nodeEndpoints) {
                nodeEndpointsElement.addSize(_size, _cache, _version, _context);
            }
            int _arraySize = _size.totalSize() - _sizeBeforeArray;
            _cache.setArraySizeInBytes(this.nodeEndpoints, _arraySize);
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_arraySize));
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                _size.addBytes(_field.size());
            }
        }
        if (_version >= 9) {
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        } else if (_numTaggedFields > 0) {
            throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ProduceResponseData)) {
            return false;
        }
        ProduceResponseData other = (ProduceResponseData)obj;
        if (this.responses == null ? other.responses != null : !this.responses.equals(other.responses)) {
            return false;
        }
        if (this.throttleTimeMs != other.throttleTimeMs) {
            return false;
        }
        if (this.nodeEndpoints == null ? other.nodeEndpoints != null : !this.nodeEndpoints.equals(other.nodeEndpoints)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.responses == null ? 0 : this.responses.hashCode());
        hashCode = 31 * hashCode + this.throttleTimeMs;
        hashCode = 31 * hashCode + (this.nodeEndpoints == null ? 0 : this.nodeEndpoints.hashCode());
        return hashCode;
    }

    @Override
    public ProduceResponseData duplicate() {
        ProduceResponseData _duplicate = new ProduceResponseData();
        TopicProduceResponseCollection newResponses = new TopicProduceResponseCollection(this.responses.size());
        for (TopicProduceResponse _element : this.responses) {
            newResponses.add(_element.duplicate());
        }
        _duplicate.responses = newResponses;
        _duplicate.throttleTimeMs = this.throttleTimeMs;
        NodeEndpointCollection newNodeEndpoints = new NodeEndpointCollection(this.nodeEndpoints.size());
        for (NodeEndpoint _element : this.nodeEndpoints) {
            newNodeEndpoints.add(_element.duplicate());
        }
        _duplicate.nodeEndpoints = newNodeEndpoints;
        return _duplicate;
    }

    public String toString() {
        return "ProduceResponseData(responses=" + MessageUtil.deepToString(this.responses.iterator()) + ", throttleTimeMs=" + this.throttleTimeMs + ", nodeEndpoints=" + MessageUtil.deepToString(this.nodeEndpoints.iterator()) + ")";
    }

    public TopicProduceResponseCollection responses() {
        return this.responses;
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public NodeEndpointCollection nodeEndpoints() {
        return this.nodeEndpoints;
    }

    @Override
    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public ProduceResponseData setResponses(TopicProduceResponseCollection v) {
        this.responses = v;
        return this;
    }

    public ProduceResponseData setThrottleTimeMs(int v) {
        this.throttleTimeMs = v;
        return this;
    }

    public ProduceResponseData setNodeEndpoints(NodeEndpointCollection v) {
        this.nodeEndpoints = v;
        return this;
    }

    static {
        SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_2), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")));
        SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_5), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota.")));
        SCHEMA_8 = new Schema(new Field("responses", new ArrayOf(TopicProduceResponse.SCHEMA_8), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."));
        SCHEMA_9 = new Schema(new Field("responses", new CompactArrayOf(TopicProduceResponse.SCHEMA_9), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(new Object[0]));
        SCHEMA_11 = SCHEMA_10 = new Schema(new Field("responses", new CompactArrayOf(TopicProduceResponse.SCHEMA_10), "Each produce response"), new Field("throttle_time_ms", Type.INT32, "The duration in milliseconds for which the request was throttled due to a quota violation, or zero if the request did not violate any quota."), Field.TaggedFieldsSection.of(0, new Field("node_endpoints", new CompactArrayOf(NodeEndpoint.SCHEMA_10), "Endpoints for all current-leaders enumerated in PartitionProduceResponses, with errors NOT_LEADER_OR_FOLLOWER.")));
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
    }

    public static class NodeEndpointCollection
    extends ImplicitLinkedHashMultiCollection<NodeEndpoint> {
        public NodeEndpointCollection() {
        }

        public NodeEndpointCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public NodeEndpointCollection(Iterator<NodeEndpoint> iterator) {
            super(iterator);
        }

        @Override
        public NodeEndpoint find(int nodeId) {
            NodeEndpoint _key = new NodeEndpoint();
            _key.setNodeId(nodeId);
            return this.find(_key);
        }

        @Override
        public List<NodeEndpoint> findAll(int nodeId) {
            NodeEndpoint _key = new NodeEndpoint();
            _key.setNodeId(nodeId);
            return this.findAll(_key);
        }

        public NodeEndpointCollection duplicate() {
            NodeEndpointCollection _duplicate = new NodeEndpointCollection(this.size());
            for (NodeEndpoint _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class NodeEndpoint
    implements Message,
    ImplicitLinkedHashCollection.Element {
        int nodeId;
        String host;
        int port;
        String rack;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 10;
        public static final short HIGHEST_SUPPORTED_VERSION = 11;

        public NodeEndpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public NodeEndpoint() {
            this.nodeId = 0;
            this.host = "";
            this.port = 0;
            this.rack = null;
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of NodeEndpoint");
            }
            this.nodeId = _readable.readInt();
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readInt();
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                this.rack = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field rack had invalid length " + length);
                }
                this.rack = _readable.readString(length);
            }
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 10) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of NodeEndpoint");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.nodeId);
            byte[] _stringBytes = _cache.getSerializedValue(this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeInt(this.port);
            if (this.rack == null) {
                _writable.writeUnsignedVarint(0);
            } else {
                _stringBytes = _cache.getSerializedValue(this.rack);
                _writable.writeUnsignedVarint(_stringBytes.length + 1);
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of NodeEndpoint");
            }
            _size.addBytes(4);
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            _size.addBytes(4);
            if (this.rack == null) {
                _size.addBytes(1);
            } else {
                _stringBytes = this.rack.getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'rack' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.rack, _stringBytes);
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof NodeEndpoint)) {
                return false;
            }
            NodeEndpoint other = (NodeEndpoint)obj;
            return this.nodeId == other.nodeId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeEndpoint)) {
                return false;
            }
            NodeEndpoint other = (NodeEndpoint)obj;
            if (this.nodeId != other.nodeId) {
                return false;
            }
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            if (this.rack == null ? other.rack != null : !this.rack.equals(other.rack)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.nodeId;
            return hashCode;
        }

        @Override
        public NodeEndpoint duplicate() {
            NodeEndpoint _duplicate = new NodeEndpoint();
            _duplicate.nodeId = this.nodeId;
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            _duplicate.rack = this.rack == null ? null : this.rack;
            return _duplicate;
        }

        public String toString() {
            return "NodeEndpoint(nodeId=" + this.nodeId + ", host=" + (this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ", rack=" + (this.rack == null ? "null" : "'" + this.rack.toString() + "'") + ")";
        }

        public int nodeId() {
            return this.nodeId;
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public String rack() {
            return this.rack;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public NodeEndpoint setNodeId(int v) {
            this.nodeId = v;
            return this;
        }

        public NodeEndpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public NodeEndpoint setPort(int v) {
            this.port = v;
            return this;
        }

        public NodeEndpoint setRack(String v) {
            this.rack = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_11 = SCHEMA_10 = new Schema(new Field("node_id", Type.INT32, "The ID of the associated node."), new Field("host", Type.COMPACT_STRING, "The node's hostname."), new Field("port", Type.INT32, "The node's port."), new Field("rack", Type.COMPACT_NULLABLE_STRING, "The rack of the node, or null if it has not been assigned to a rack."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, null, null, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class TopicProduceResponseCollection
    extends ImplicitLinkedHashMultiCollection<TopicProduceResponse> {
        public TopicProduceResponseCollection() {
        }

        public TopicProduceResponseCollection(int expectedNumElements) {
            super(expectedNumElements);
        }

        public TopicProduceResponseCollection(Iterator<TopicProduceResponse> iterator) {
            super(iterator);
        }

        @Override
        public TopicProduceResponse find(String name) {
            TopicProduceResponse _key = new TopicProduceResponse();
            _key.setName(name);
            return this.find(_key);
        }

        @Override
        public List<TopicProduceResponse> findAll(String name) {
            TopicProduceResponse _key = new TopicProduceResponse();
            _key.setName(name);
            return this.findAll(_key);
        }

        public TopicProduceResponseCollection duplicate() {
            TopicProduceResponseCollection _duplicate = new TopicProduceResponseCollection(this.size());
            for (TopicProduceResponse _element : this) {
                _duplicate.add(_element.duplicate());
            }
            return _duplicate;
        }
    }

    public static class LeaderIdAndEpoch
    implements Message {
        int leaderId;
        int leaderEpoch;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 10;
        public static final short HIGHEST_SUPPORTED_VERSION = 11;

        public LeaderIdAndEpoch(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public LeaderIdAndEpoch() {
            this.leaderId = -1;
            this.leaderEpoch = -1;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of LeaderIdAndEpoch");
            }
            this.leaderId = _readable.readInt();
            this.leaderEpoch = _readable.readInt();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 10) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of LeaderIdAndEpoch");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.leaderId);
            _writable.writeInt(this.leaderEpoch);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of LeaderIdAndEpoch");
            }
            _size.addBytes(4);
            _size.addBytes(4);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof LeaderIdAndEpoch)) {
                return false;
            }
            LeaderIdAndEpoch other = (LeaderIdAndEpoch)obj;
            if (this.leaderId != other.leaderId) {
                return false;
            }
            if (this.leaderEpoch != other.leaderEpoch) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.leaderId;
            hashCode = 31 * hashCode + this.leaderEpoch;
            return hashCode;
        }

        @Override
        public LeaderIdAndEpoch duplicate() {
            LeaderIdAndEpoch _duplicate = new LeaderIdAndEpoch();
            _duplicate.leaderId = this.leaderId;
            _duplicate.leaderEpoch = this.leaderEpoch;
            return _duplicate;
        }

        public String toString() {
            return "LeaderIdAndEpoch(leaderId=" + this.leaderId + ", leaderEpoch=" + this.leaderEpoch + ")";
        }

        public int leaderId() {
            return this.leaderId;
        }

        public int leaderEpoch() {
            return this.leaderEpoch;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public LeaderIdAndEpoch setLeaderId(int v) {
            this.leaderId = v;
            return this;
        }

        public LeaderIdAndEpoch setLeaderEpoch(int v) {
            this.leaderEpoch = v;
            return this;
        }

        static {
            SCHEMA_11 = SCHEMA_10 = new Schema(new Field("leader_id", Type.INT32, "The ID of the current leader or -1 if the leader is unknown."), new Field("leader_epoch", Type.INT32, "The latest known leader epoch"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, null, null, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class BatchIndexAndErrorMessage
    implements Message {
        int batchIndex;
        String batchIndexErrorMessage;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_8 = new Schema(new Field("batch_index", Type.INT32, "The batch index of the record that cause the batch to be dropped"), new Field("batch_index_error_message", Type.NULLABLE_STRING, "The error message of the record that caused the batch to be dropped"));
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 8;
        public static final short HIGHEST_SUPPORTED_VERSION = 11;

        public BatchIndexAndErrorMessage(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public BatchIndexAndErrorMessage() {
            this.batchIndex = 0;
            this.batchIndexErrorMessage = null;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of BatchIndexAndErrorMessage");
            }
            this.batchIndex = _readable.readInt();
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                this.batchIndexErrorMessage = null;
            } else {
                if (length > Short.MAX_VALUE) {
                    throw new RuntimeException("string field batchIndexErrorMessage had invalid length " + length);
                }
                this.batchIndexErrorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
            }
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            if (_version < 8) {
                throw new UnsupportedVersionException("Can't write version " + _version + " of BatchIndexAndErrorMessage");
            }
            int _numTaggedFields = 0;
            _writable.writeInt(this.batchIndex);
            if (this.batchIndexErrorMessage == null) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(0);
                } else {
                    _writable.writeShort((short)-1);
                }
            } else {
                byte[] _stringBytes = _cache.getSerializedValue(this.batchIndexErrorMessage);
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(_stringBytes.length + 1);
                } else {
                    _writable.writeShort((short)_stringBytes.length);
                }
                _writable.writeByteArray(_stringBytes);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of BatchIndexAndErrorMessage");
            }
            _size.addBytes(4);
            if (this.batchIndexErrorMessage == null) {
                if (_version >= 9) {
                    _size.addBytes(1);
                } else {
                    _size.addBytes(2);
                }
            } else {
                byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.batchIndexErrorMessage).getBytes(StandardCharsets.UTF_8);
                if (_stringBytes.length > Short.MAX_VALUE) {
                    throw new RuntimeException("'batchIndexErrorMessage' field is too long to be serialized");
                }
                _cache.cacheSerializedValue(this.batchIndexErrorMessage, _stringBytes);
                if (_version >= 9) {
                    _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                } else {
                    _size.addBytes(_stringBytes.length + 2);
                }
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BatchIndexAndErrorMessage)) {
                return false;
            }
            BatchIndexAndErrorMessage other = (BatchIndexAndErrorMessage)obj;
            if (this.batchIndex != other.batchIndex) {
                return false;
            }
            if (this.batchIndexErrorMessage == null ? other.batchIndexErrorMessage != null : !this.batchIndexErrorMessage.equals(other.batchIndexErrorMessage)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.batchIndex;
            hashCode = 31 * hashCode + (this.batchIndexErrorMessage == null ? 0 : this.batchIndexErrorMessage.hashCode());
            return hashCode;
        }

        @Override
        public BatchIndexAndErrorMessage duplicate() {
            BatchIndexAndErrorMessage _duplicate = new BatchIndexAndErrorMessage();
            _duplicate.batchIndex = this.batchIndex;
            _duplicate.batchIndexErrorMessage = this.batchIndexErrorMessage == null ? null : this.batchIndexErrorMessage;
            return _duplicate;
        }

        public String toString() {
            return "BatchIndexAndErrorMessage(batchIndex=" + this.batchIndex + ", batchIndexErrorMessage=" + (this.batchIndexErrorMessage == null ? "null" : "'" + this.batchIndexErrorMessage.toString() + "'") + ")";
        }

        public int batchIndex() {
            return this.batchIndex;
        }

        public String batchIndexErrorMessage() {
            return this.batchIndexErrorMessage;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public BatchIndexAndErrorMessage setBatchIndex(int v) {
            this.batchIndex = v;
            return this;
        }

        public BatchIndexAndErrorMessage setBatchIndexErrorMessage(String v) {
            this.batchIndexErrorMessage = v;
            return this;
        }

        static {
            SCHEMA_11 = SCHEMA_10 = (SCHEMA_9 = new Schema(new Field("batch_index", Type.INT32, "The batch index of the record that cause the batch to be dropped"), new Field("batch_index_error_message", Type.COMPACT_NULLABLE_STRING, "The error message of the record that caused the batch to be dropped"), Field.TaggedFieldsSection.of(new Object[0])));
            SCHEMAS = new Schema[]{null, null, null, null, null, null, null, null, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class PartitionProduceResponse
    implements Message {
        int index;
        short errorCode;
        long baseOffset;
        long logAppendTimeMs;
        long logStartOffset;
        List<BatchIndexAndErrorMessage> recordErrors;
        String errorMessage;
        LeaderIdAndEpoch currentLeader;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 11;

        public PartitionProduceResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public PartitionProduceResponse() {
            this.index = 0;
            this.errorCode = 0;
            this.baseOffset = 0L;
            this.logAppendTimeMs = -1L;
            this.logStartOffset = -1L;
            this.recordErrors = new ArrayList<BatchIndexAndErrorMessage>(0);
            this.errorMessage = null;
            this.currentLeader = new LeaderIdAndEpoch();
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of PartitionProduceResponse");
            }
            this.index = _readable.readInt();
            this.errorCode = _readable.readShort();
            this.baseOffset = _readable.readLong();
            this.logAppendTimeMs = _version >= 2 ? _readable.readLong() : -1L;
            this.logStartOffset = _version >= 5 ? _readable.readLong() : -1L;
            if (_version >= 8) {
                int i;
                ArrayList<BatchIndexAndErrorMessage> newCollection;
                int arrayLength;
                if (_version >= 9) {
                    arrayLength = _readable.readUnsignedVarint() - 1;
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field recordErrors was serialized as null");
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new BatchIndexAndErrorMessage(_readable, _version, _context));
                    }
                    this.recordErrors = newCollection;
                } else {
                    arrayLength = _readable.readInt();
                    if (arrayLength < 0) {
                        throw new RuntimeException("non-nullable field recordErrors was serialized as null");
                    }
                    if (arrayLength > _readable.remaining()) {
                        throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                    }
                    newCollection = new ArrayList<BatchIndexAndErrorMessage>(arrayLength);
                    for (i = 0; i < arrayLength; ++i) {
                        newCollection.add(new BatchIndexAndErrorMessage(_readable, _version, _context));
                    }
                    this.recordErrors = newCollection;
                }
            } else {
                this.recordErrors = new ArrayList<BatchIndexAndErrorMessage>(0);
            }
            if (_version >= 8) {
                int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
                if (length < 0) {
                    this.errorMessage = null;
                } else {
                    if (length > Short.MAX_VALUE) {
                        throw new RuntimeException("string field errorMessage had invalid length " + length);
                    }
                    this.errorMessage = _context.read(EntityType.ERROR_MESSAGE, _readable.readString(length));
                }
            } else {
                this.errorMessage = null;
            }
            this.currentLeader = new LeaderIdAndEpoch();
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                block5: for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        case 0: {
                            if (_version >= 10) {
                                this.currentLeader = new LeaderIdAndEpoch(_readable, _version, _context);
                                continue block5;
                            }
                            throw new RuntimeException("Tag 0 is not valid for version " + _version);
                        }
                        default: {
                            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                        }
                    }
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            _writable.writeInt(this.index);
            _writable.writeShort(this.errorCode);
            _writable.writeLong(this.baseOffset);
            if (_version >= 2) {
                _writable.writeLong(this.logAppendTimeMs);
            }
            if (_version >= 5) {
                _writable.writeLong(this.logStartOffset);
            }
            if (_version >= 8) {
                if (_version >= 9) {
                    _writable.writeUnsignedVarint(this.recordErrors.size() + 1);
                    for (BatchIndexAndErrorMessage recordErrorsElement : this.recordErrors) {
                        recordErrorsElement.write(_writable, _cache, _version, _context);
                    }
                } else {
                    _writable.writeInt(this.recordErrors.size());
                    for (BatchIndexAndErrorMessage recordErrorsElement : this.recordErrors) {
                        recordErrorsElement.write(_writable, _cache, _version, _context);
                    }
                }
            }
            if (_version >= 8) {
                if (this.errorMessage == null) {
                    if (_version >= 9) {
                        _writable.writeUnsignedVarint(0);
                    } else {
                        _writable.writeShort((short)-1);
                    }
                } else {
                    byte[] _stringBytes = _cache.getSerializedValue(this.errorMessage);
                    if (_version >= 9) {
                        _writable.writeUnsignedVarint(_stringBytes.length + 1);
                    } else {
                        _writable.writeShort((short)_stringBytes.length);
                    }
                    _writable.writeByteArray(_stringBytes);
                }
            }
            if (_version >= 10) {
                if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                    ++_numTaggedFields;
                }
            } else if (!this.currentLeader.equals(new LeaderIdAndEpoch())) {
                throw new UnsupportedVersionException("Attempted to write a non-default currentLeader at version " + _version);
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                if (_version >= 10 && !this.currentLeader.equals(new LeaderIdAndEpoch())) {
                    _writable.writeUnsignedVarint(0);
                    _writable.writeUnsignedVarint(this.currentLeader.size(_cache, _version, _context));
                    this.currentLeader.write(_writable, _cache, _version, _context);
                }
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of PartitionProduceResponse");
            }
            _size.addBytes(4);
            _size.addBytes(2);
            _size.addBytes(8);
            if (_version >= 2) {
                _size.addBytes(8);
            }
            if (_version >= 5) {
                _size.addBytes(8);
            }
            if (_version >= 8) {
                if (_version >= 9) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.recordErrors.size() + 1));
                } else {
                    _size.addBytes(4);
                }
                for (BatchIndexAndErrorMessage recordErrorsElement : this.recordErrors) {
                    recordErrorsElement.addSize(_size, _cache, _version, _context);
                }
            }
            if (_version >= 8) {
                if (this.errorMessage == null) {
                    if (_version >= 9) {
                        _size.addBytes(1);
                    } else {
                        _size.addBytes(2);
                    }
                } else {
                    byte[] _stringBytes = _context.write(EntityType.ERROR_MESSAGE, this.errorMessage).getBytes(StandardCharsets.UTF_8);
                    if (_stringBytes.length > Short.MAX_VALUE) {
                        throw new RuntimeException("'errorMessage' field is too long to be serialized");
                    }
                    _cache.cacheSerializedValue(this.errorMessage, _stringBytes);
                    if (_version >= 9) {
                        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
                    } else {
                        _size.addBytes(_stringBytes.length + 2);
                    }
                }
            }
            if (_version >= 10 && !this.currentLeader.equals(new LeaderIdAndEpoch())) {
                ++_numTaggedFields;
                _size.addBytes(1);
                int _sizeBeforeStruct = _size.totalSize();
                this.currentLeader.addSize(_size, _cache, _version, _context);
                int _structSize = _size.totalSize() - _sizeBeforeStruct;
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_structSize));
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PartitionProduceResponse)) {
                return false;
            }
            PartitionProduceResponse other = (PartitionProduceResponse)obj;
            if (this.index != other.index) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.baseOffset != other.baseOffset) {
                return false;
            }
            if (this.logAppendTimeMs != other.logAppendTimeMs) {
                return false;
            }
            if (this.logStartOffset != other.logStartOffset) {
                return false;
            }
            if (this.recordErrors == null ? other.recordErrors != null : !this.recordErrors.equals(other.recordErrors)) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.currentLeader == null ? other.currentLeader != null : !this.currentLeader.equals(other.currentLeader)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.index;
            hashCode = 31 * hashCode + this.errorCode;
            hashCode = 31 * hashCode + ((int)(this.baseOffset >> 32) ^ (int)this.baseOffset);
            hashCode = 31 * hashCode + ((int)(this.logAppendTimeMs >> 32) ^ (int)this.logAppendTimeMs);
            hashCode = 31 * hashCode + ((int)(this.logStartOffset >> 32) ^ (int)this.logStartOffset);
            hashCode = 31 * hashCode + (this.recordErrors == null ? 0 : this.recordErrors.hashCode());
            hashCode = 31 * hashCode + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            hashCode = 31 * hashCode + (this.currentLeader == null ? 0 : this.currentLeader.hashCode());
            return hashCode;
        }

        @Override
        public PartitionProduceResponse duplicate() {
            PartitionProduceResponse _duplicate = new PartitionProduceResponse();
            _duplicate.index = this.index;
            _duplicate.errorCode = this.errorCode;
            _duplicate.baseOffset = this.baseOffset;
            _duplicate.logAppendTimeMs = this.logAppendTimeMs;
            _duplicate.logStartOffset = this.logStartOffset;
            ArrayList<BatchIndexAndErrorMessage> newRecordErrors = new ArrayList<BatchIndexAndErrorMessage>(this.recordErrors.size());
            for (BatchIndexAndErrorMessage _element : this.recordErrors) {
                newRecordErrors.add(_element.duplicate());
            }
            _duplicate.recordErrors = newRecordErrors;
            _duplicate.errorMessage = this.errorMessage == null ? null : this.errorMessage;
            _duplicate.currentLeader = this.currentLeader.duplicate();
            return _duplicate;
        }

        public String toString() {
            return "PartitionProduceResponse(index=" + this.index + ", errorCode=" + this.errorCode + ", baseOffset=" + this.baseOffset + ", logAppendTimeMs=" + this.logAppendTimeMs + ", logStartOffset=" + this.logStartOffset + ", recordErrors=" + MessageUtil.deepToString(this.recordErrors.iterator()) + ", errorMessage=" + (this.errorMessage == null ? "null" : "'" + this.errorMessage.toString() + "'") + ", currentLeader=" + this.currentLeader.toString() + ")";
        }

        public int index() {
            return this.index;
        }

        public short errorCode() {
            return this.errorCode;
        }

        public long baseOffset() {
            return this.baseOffset;
        }

        public long logAppendTimeMs() {
            return this.logAppendTimeMs;
        }

        public long logStartOffset() {
            return this.logStartOffset;
        }

        public List<BatchIndexAndErrorMessage> recordErrors() {
            return this.recordErrors;
        }

        public String errorMessage() {
            return this.errorMessage;
        }

        public LeaderIdAndEpoch currentLeader() {
            return this.currentLeader;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public PartitionProduceResponse setIndex(int v) {
            this.index = v;
            return this;
        }

        public PartitionProduceResponse setErrorCode(short v) {
            this.errorCode = v;
            return this;
        }

        public PartitionProduceResponse setBaseOffset(long v) {
            this.baseOffset = v;
            return this;
        }

        public PartitionProduceResponse setLogAppendTimeMs(long v) {
            this.logAppendTimeMs = v;
            return this;
        }

        public PartitionProduceResponse setLogStartOffset(long v) {
            this.logStartOffset = v;
            return this;
        }

        public PartitionProduceResponse setRecordErrors(List<BatchIndexAndErrorMessage> v) {
            this.recordErrors = v;
            return this;
        }

        public PartitionProduceResponse setErrorMessage(String v) {
            this.errorMessage = v;
            return this;
        }

        public PartitionProduceResponse setCurrentLeader(LeaderIdAndEpoch v) {
            this.currentLeader = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."));
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."), new Field("log_append_time_ms", Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended.")));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."), new Field("log_append_time_ms", Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), new Field("log_start_offset", Type.INT64, "The log start offset.")));
            SCHEMA_8 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."), new Field("log_append_time_ms", Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), new Field("log_start_offset", Type.INT64, "The log start offset."), new Field("record_errors", new ArrayOf(BatchIndexAndErrorMessage.SCHEMA_8), "The batch indices of records that caused the batch to be dropped"), new Field("error_message", Type.NULLABLE_STRING, "The global error message summarizing the common root cause of the records that caused the batch to be dropped"));
            SCHEMA_9 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."), new Field("log_append_time_ms", Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), new Field("log_start_offset", Type.INT64, "The log start offset."), new Field("record_errors", new CompactArrayOf(BatchIndexAndErrorMessage.SCHEMA_9), "The batch indices of records that caused the batch to be dropped"), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The global error message summarizing the common root cause of the records that caused the batch to be dropped"), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_11 = SCHEMA_10 = new Schema(new Field("index", Type.INT32, "The partition index."), new Field("error_code", Type.INT16, "The error code, or 0 if there was no error."), new Field("base_offset", Type.INT64, "The base offset."), new Field("log_append_time_ms", Type.INT64, "The timestamp returned by broker after appending the messages. If CreateTime is used for the topic, the timestamp will be -1.  If LogAppendTime is used for the topic, the timestamp will be the broker local time when the messages are appended."), new Field("log_start_offset", Type.INT64, "The log start offset."), new Field("record_errors", new CompactArrayOf(BatchIndexAndErrorMessage.SCHEMA_9), "The batch indices of records that caused the batch to be dropped"), new Field("error_message", Type.COMPACT_NULLABLE_STRING, "The global error message summarizing the common root cause of the records that caused the batch to be dropped"), Field.TaggedFieldsSection.of(0, new Field("current_leader", LeaderIdAndEpoch.SCHEMA_10, "")));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }

    public static class TopicProduceResponse
    implements Message,
    ImplicitLinkedHashCollection.Element {
        String name;
        List<PartitionProduceResponse> partitionResponses;
        private List<RawTaggedField> _unknownTaggedFields;
        private int next;
        private int prev;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema SCHEMA_2;
        public static final Schema SCHEMA_3;
        public static final Schema SCHEMA_4;
        public static final Schema SCHEMA_5;
        public static final Schema SCHEMA_6;
        public static final Schema SCHEMA_7;
        public static final Schema SCHEMA_8;
        public static final Schema SCHEMA_9;
        public static final Schema SCHEMA_10;
        public static final Schema SCHEMA_11;
        public static final Schema[] SCHEMAS;
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 11;

        public TopicProduceResponse(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
            this.prev = -2;
            this.next = -2;
        }

        public TopicProduceResponse() {
            this.name = "";
            this.partitionResponses = new ArrayList<PartitionProduceResponse>(0);
            this.prev = -2;
            this.next = -2;
        }

        @Override
        public short lowestSupportedVersion() {
            return 0;
        }

        @Override
        public short highestSupportedVersion() {
            return 11;
        }

        @Override
        public final void read(Readable _readable, short _version, MessageContext _context) {
            int i;
            ArrayList<PartitionProduceResponse> newCollection;
            int arrayLength;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't read version " + _version + " of TopicProduceResponse");
            }
            int length = _version >= 9 ? _readable.readUnsignedVarint() - 1 : _readable.readShort();
            if (length < 0) {
                throw new RuntimeException("non-nullable field name was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field name had invalid length " + length);
            }
            this.name = _context.read(EntityType.TOPIC_NAME, _readable.readString(length));
            if (_version >= 9) {
                arrayLength = _readable.readUnsignedVarint() - 1;
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionResponses was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionProduceResponse(_readable, _version, _context));
                }
                this.partitionResponses = newCollection;
            } else {
                arrayLength = _readable.readInt();
                if (arrayLength < 0) {
                    throw new RuntimeException("non-nullable field partitionResponses was serialized as null");
                }
                if (arrayLength > _readable.remaining()) {
                    throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
                }
                newCollection = new ArrayList<PartitionProduceResponse>(arrayLength);
                for (i = 0; i < arrayLength; ++i) {
                    newCollection.add(new PartitionProduceResponse(_readable, _version, _context));
                }
                this.partitionResponses = newCollection;
            }
            this._unknownTaggedFields = null;
            if (_version >= 9) {
                int _numTaggedFields = _readable.readUnsignedVarint();
                for (int _i = 0; _i < _numTaggedFields; ++_i) {
                    int _tag = _readable.readUnsignedVarint();
                    int _size = _readable.readUnsignedVarint();
                    switch (_tag) {
                        default: 
                    }
                    this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
                }
            }
        }

        @Override
        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            Object _stringBytes = _cache.getSerializedValue(this.name);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            } else {
                _writable.writeShort((short)((byte[])_stringBytes).length);
            }
            _writable.writeByteArray((byte[])_stringBytes);
            if (_version >= 9) {
                _writable.writeUnsignedVarint(this.partitionResponses.size() + 1);
                _stringBytes = this.partitionResponses.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionProduceResponse partitionResponsesElement = (PartitionProduceResponse)_stringBytes.next();
                    partitionResponsesElement.write(_writable, _cache, _version, _context);
                }
            } else {
                _writable.writeInt(this.partitionResponses.size());
                _stringBytes = this.partitionResponses.iterator();
                while (_stringBytes.hasNext()) {
                    PartitionProduceResponse partitionResponsesElement = (PartitionProduceResponse)_stringBytes.next();
                    partitionResponsesElement.write(_writable, _cache, _version, _context);
                }
            }
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _numTaggedFields += _rawWriter.numFields();
            if (_version >= 9) {
                _writable.writeUnsignedVarint(_numTaggedFields);
                _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            if (_version > 11) {
                throw new UnsupportedVersionException("Can't size version " + _version + " of TopicProduceResponse");
            }
            byte[] _stringBytes = _context.write(EntityType.TOPIC_NAME, this.name).getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'name' field is too long to be serialized");
            }
            _cache.cacheSerializedValue(this.name, _stringBytes);
            if (_version >= 9) {
                _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint(_stringBytes.length + 1));
            } else {
                _size.addBytes(_stringBytes.length + 2);
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(this.partitionResponses.size() + 1));
            } else {
                _size.addBytes(4);
            }
            for (PartitionProduceResponse partitionResponsesElement : this.partitionResponses) {
                partitionResponsesElement.addSize(_size, _cache, _version, _context);
            }
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            if (_version >= 9) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint(_numTaggedFields));
            } else if (_numTaggedFields > 0) {
                throw new UnsupportedVersionException("Tagged fields were set, but version " + _version + " of this message does not support them.");
            }
        }

        @Override
        public boolean elementKeysAreEqual(Object obj) {
            if (!(obj instanceof TopicProduceResponse)) {
                return false;
            }
            TopicProduceResponse other = (TopicProduceResponse)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TopicProduceResponse)) {
                return false;
            }
            TopicProduceResponse other = (TopicProduceResponse)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            if (this.partitionResponses == null ? other.partitionResponses != null : !this.partitionResponses.equals(other.partitionResponses)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            return hashCode;
        }

        @Override
        public TopicProduceResponse duplicate() {
            TopicProduceResponse _duplicate = new TopicProduceResponse();
            _duplicate.name = this.name;
            ArrayList<PartitionProduceResponse> newPartitionResponses = new ArrayList<PartitionProduceResponse>(this.partitionResponses.size());
            for (PartitionProduceResponse _element : this.partitionResponses) {
                newPartitionResponses.add(_element.duplicate());
            }
            _duplicate.partitionResponses = newPartitionResponses;
            return _duplicate;
        }

        public String toString() {
            return "TopicProduceResponse(name=" + (this.name == null ? "null" : "'" + this.name.toString() + "'") + ", partitionResponses=" + MessageUtil.deepToString(this.partitionResponses.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<PartitionProduceResponse> partitionResponses() {
            return this.partitionResponses;
        }

        @Override
        public int next() {
            return this.next;
        }

        @Override
        public int prev() {
            return this.prev;
        }

        @Override
        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public TopicProduceResponse setName(String v) {
            this.name = v;
            return this;
        }

        public TopicProduceResponse setPartitionResponses(List<PartitionProduceResponse> v) {
            this.partitionResponses = v;
            return this;
        }

        @Override
        public void setNext(int v) {
            this.next = v;
        }

        @Override
        public void setPrev(int v) {
            this.prev = v;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partition_responses", new ArrayOf(PartitionProduceResponse.SCHEMA_0), "Each partition that we produced to within the topic."));
            SCHEMA_4 = SCHEMA_3 = (SCHEMA_2 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partition_responses", new ArrayOf(PartitionProduceResponse.SCHEMA_2), "Each partition that we produced to within the topic.")));
            SCHEMA_7 = SCHEMA_6 = (SCHEMA_5 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partition_responses", new ArrayOf(PartitionProduceResponse.SCHEMA_5), "Each partition that we produced to within the topic.")));
            SCHEMA_8 = new Schema(new Field("name", Type.STRING, "The topic name"), new Field("partition_responses", new ArrayOf(PartitionProduceResponse.SCHEMA_8), "Each partition that we produced to within the topic."));
            SCHEMA_9 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name"), new Field("partition_responses", new CompactArrayOf(PartitionProduceResponse.SCHEMA_9), "Each partition that we produced to within the topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMA_11 = SCHEMA_10 = new Schema(new Field("name", Type.COMPACT_STRING, "The topic name"), new Field("partition_responses", new CompactArrayOf(PartitionProduceResponse.SCHEMA_10), "Each partition that we produced to within the topic."), Field.TaggedFieldsSection.of(new Object[0]));
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1, SCHEMA_2, SCHEMA_3, SCHEMA_4, SCHEMA_5, SCHEMA_6, SCHEMA_7, SCHEMA_8, SCHEMA_9, SCHEMA_10, SCHEMA_11};
        }
    }
}

