/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.message.ReverseConnectionRequestData;
import org.apache.kafka.common.message.ReverseConnectionResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.requests.ReverseConnectionResponse;

public class ReverseConnectionRequest
extends AbstractRequest {
    private final ReverseConnectionRequestData data;

    public ReverseConnectionRequest(ReverseConnectionRequestData data, short apiVersion) {
        super(ApiKeys.REVERSE_CONNECTION, apiVersion);
        this.data = data;
    }

    public static ReverseConnectionRequest parse(ByteBuffer buffer, short version, MessageContext context) {
        return new ReverseConnectionRequest(new ReverseConnectionRequestData(new ByteBufferAccessor(buffer), version, context), version);
    }

    @Override
    public ReverseConnectionRequestData data() {
        return this.data;
    }

    @Override
    public ReverseConnectionResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ApiError apiError = ApiError.fromThrowable(e);
        ReverseConnectionResponseData responseData = new ReverseConnectionResponseData().setErrorCode(apiError.error().code()).setErrorMessage(apiError.message()).setThrottleTimeMs(throttleTimeMs);
        return new ReverseConnectionResponse(responseData);
    }

    public static class Builder
    extends AbstractRequest.Builder<ReverseConnectionRequest> {
        private final ReverseConnectionRequestData data;

        public Builder(ReverseConnectionRequestData data) {
            super(ApiKeys.REVERSE_CONNECTION);
            this.data = data;
        }

        @Override
        public ReverseConnectionRequest build(short version) {
            return new ReverseConnectionRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

