/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.kafka.clients.admin.EvenClusterLoadPlan;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanBrokerRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanBrokerStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanClusterRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanDetailedClusterBalanceStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalRelatedStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStats;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsOverview;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsOverviewRejectingGoal;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanGoalStatsResources;
import org.apache.kafka.clients.admin.EvenClusterLoadPlanReplicaMovementStats;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EvenClusterLoadPlanTest {
    @Test
    public void testEvenClusterLoadPlanPrintableForm() {
        int interBrokerMoves = 10;
        double interBrokerMovesMB = 15.5;
        double avgNetworkInboundKbps = 28240.951;
        double avgProduceInboundKbps = avgNetworkInboundKbps / 3.0;
        double maxNetworkInboundKbps = 29985.133;
        double maxProduceInboundKbps = maxNetworkInboundKbps / 3.0;
        double minNetworkInboundKbps = 25717.08;
        double minProduceInboundKbps = minNetworkInboundKbps / 3.0;
        double stdNetworkInboundKbps = 1286.804;
        double stdProduceInboundKbps = stdNetworkInboundKbps / 3.0;
        double avgNetworkOutboundKbps = 27849.211;
        double avgConsumeOutboundKbps = avgNetworkOutboundKbps / 3.0;
        double maxNetworkOutboundKbps = 29369.832;
        double maxConsumeOutboundKbps = maxNetworkOutboundKbps / 3.0;
        double minNetworkOutboundKbps = 25808.67;
        double minConsumeOutboundKbps = minNetworkOutboundKbps / 3.0;
        double stdNetworkOutboundKbps = 1440.964;
        double stdConsumeOutboundKbps = stdNetworkOutboundKbps / 3.0;
        int leadershipMoves = 19;
        List<Integer> brokersExcludedForLeadership = Arrays.asList(7, 8);
        ArrayList brokersExcludedForReplicaMove = new ArrayList();
        List<Integer> newBrokers = Arrays.asList(3, 7);
        List<Integer> deadOrRemovedBrokers = Arrays.asList(2, 4);
        int recentWindows = 1;
        double partitionCoveragePercent = 90.5;
        List<String> excludedTopics = Arrays.asList("topic1", "topic2");
        int totalBrokers = 10;
        int totalReplicas = 500;
        int totalTopics = 20;
        EvenClusterLoadPlanBrokerStats brokerStats01 = new EvenClusterLoadPlanBrokerStats(0, "host0", 35209.719, 14.03, 23.649, 9833.179, 13814.7, 29368.961, 75145.148, 47, 71);
        EvenClusterLoadPlanBrokerStats brokerStats02 = new EvenClusterLoadPlanBrokerStats(1, "host1", 35209.719, 14.03, 23.649, 9833.179, 13814.7, 29368.961, 75145.148, 47, 71);
        EvenClusterLoadPlanBrokerStats brokerStats03 = new EvenClusterLoadPlanBrokerStats(2, "host2", 35209.719, 14.03, 23.649, 9833.179, 13814.7, 29368.961, 75145.148, 47, 71);
        EvenClusterLoadPlanBrokerStats brokerStats04 = new EvenClusterLoadPlanBrokerStats(3, "host3", 35209.719, 14.03, 23.649, 9833.179, 13814.7, 29368.961, 75145.148, 47, 71);
        EvenClusterLoadPlanBrokerStats brokerStats05 = new EvenClusterLoadPlanBrokerStats(4, "host4", 35209.719, 14.03, 23.649, 9833.179, 13814.7, 29368.961, 75145.148, 47, 71);
        double balancednessScorePreRebalance = 80.7;
        double balancednessScorePostRebalance = 99.7;
        List<String> movementGeneratingGoals = Arrays.asList("ReplicaDistributionGoal", "RackAwareGoal");
        EvenClusterLoadPlanGoalStatsResources avgResourcesCpu = new EvenClusterLoadPlanGoalStatsResources(28.835, avgNetworkInboundKbps, avgProduceInboundKbps, avgNetworkOutboundKbps, avgConsumeOutboundKbps, 45366.01, 87839.004, 157, 52, 8);
        EvenClusterLoadPlanGoalStatsResources maxResourcesCpu = new EvenClusterLoadPlanGoalStatsResources(31.273, maxNetworkInboundKbps, maxProduceInboundKbps, maxNetworkOutboundKbps, maxConsumeOutboundKbps, 48095.633, 91267.646, 172, 58, 50);
        EvenClusterLoadPlanGoalStatsResources minResourcesCpu = new EvenClusterLoadPlanGoalStatsResources(24.939, minNetworkInboundKbps, minProduceInboundKbps, minNetworkOutboundKbps, minConsumeOutboundKbps, 43224.656, 79481.926, 143, 47, 0);
        EvenClusterLoadPlanGoalStatsResources stdResourcesCpu = new EvenClusterLoadPlanGoalStatsResources(1.965, stdNetworkInboundKbps, stdProduceInboundKbps, stdNetworkOutboundKbps, stdConsumeOutboundKbps, 1927.479, 4050.075, 14, 5, 6);
        String goalStatusCpu = "VIOLATED";
        int generatedProposalsCpu = 467;
        int rejectedProposalsCpu = 455;
        double rejectedProposalsPercentCpu = 0.97;
        int acceptedProposalsCpu = 12;
        double acceptedProposalsPercentCpu = 0.026;
        int movesCpu = 1;
        int swapsCpu = 0;
        EvenClusterLoadPlanGoalStatsOverviewRejectingGoal rejectingGoal01 = new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("ReplicaDistributionGoal", 60);
        EvenClusterLoadPlanGoalStatsOverview overviewCpu = new EvenClusterLoadPlanGoalStatsOverview(goalStatusCpu, Arrays.asList(rejectingGoal01, new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("NetworkInboundUsageDistributionGoal", 37), new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("RackAwareGoal", 172), new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("NetworkOutboundUsageDistributionGoal", 4)), generatedProposalsCpu, rejectedProposalsCpu, rejectedProposalsPercentCpu, acceptedProposalsCpu, acceptedProposalsPercentCpu, movesCpu, swapsCpu);
        String cpuUsageDistributionGoal = "CpuUsageDistributionGoal";
        String networkInboundUsageDistributionGoal = "NetworkInboundUsageDistributionGoal";
        EvenClusterLoadPlanGoalStatsResources avgResourcesLeaderBytesIn = new EvenClusterLoadPlanGoalStatsResources(28.835, avgNetworkInboundKbps, avgProduceInboundKbps, avgNetworkOutboundKbps, avgConsumeOutboundKbps, 45366.01, 87839.004, 157, 52, 8);
        EvenClusterLoadPlanGoalStatsResources maxResourcesLeaderBytesIn = new EvenClusterLoadPlanGoalStatsResources(31.273, maxNetworkInboundKbps, maxProduceInboundKbps, maxNetworkOutboundKbps, maxConsumeOutboundKbps, 48095.633, 91267.646, 172, 58, 50);
        EvenClusterLoadPlanGoalStatsResources minResourcesLeaderBytesIn = new EvenClusterLoadPlanGoalStatsResources(24.939, minNetworkInboundKbps, minProduceInboundKbps, minNetworkOutboundKbps, minConsumeOutboundKbps, 43224.656, 79481.926, 143, 47, 0);
        EvenClusterLoadPlanGoalStatsResources stdResourcesLeaderBytesIn = new EvenClusterLoadPlanGoalStatsResources(1.965, stdNetworkInboundKbps, stdProduceInboundKbps, stdNetworkOutboundKbps, stdConsumeOutboundKbps, 1927.479, 4050.075, 14, 5, 6);
        String leaderBytesInStatus = "FIXED";
        List<EvenClusterLoadPlanGoalStatsOverviewRejectingGoal> cpuUsageDistributionGoal1 = Arrays.asList(new EvenClusterLoadPlanGoalStatsOverviewRejectingGoal("CpuUsageDistributionGoal", 1));
        int generatedProposalsLeaderBytesIn = 2;
        int rejectedProposalsLeaderBytesIn = 1;
        double rejectedProposalsPercentLeaderBytesIn = 0.5;
        int acceptedProposalsLeaderBytesIn = 1;
        double acceptedProposalsPercentLeaderBytesIn = 0.5;
        int movesLeaderBytesIn = 0;
        int swapsLeaderBytesIn = 0;
        EvenClusterLoadPlanGoalStatsOverview overviewLeaderBytesIn = new EvenClusterLoadPlanGoalStatsOverview(leaderBytesInStatus, cpuUsageDistributionGoal1, generatedProposalsLeaderBytesIn, rejectedProposalsLeaderBytesIn, rejectedProposalsPercentLeaderBytesIn, acceptedProposalsLeaderBytesIn, acceptedProposalsPercentLeaderBytesIn, movesLeaderBytesIn, swapsLeaderBytesIn);
        List<String> violatedGoalsBeforeOptimization = Arrays.asList("ReplicaDistributionGoal", "RackAwareGoal");
        ArrayList violatedGoalsAfterOptimization = new ArrayList();
        EvenClusterLoadPlan plan = new EvenClusterLoadPlan(new EvenClusterLoadPlanReplicaMovementStats(interBrokerMoves, interBrokerMovesMB, leadershipMoves), new EvenClusterLoadPlanBrokerRelatedStats(brokersExcludedForLeadership, brokersExcludedForReplicaMove, newBrokers, deadOrRemovedBrokers), new EvenClusterLoadPlanClusterRelatedStats(recentWindows, partitionCoveragePercent, excludedTopics, totalBrokers, totalReplicas, totalTopics), new EvenClusterLoadPlanDetailedClusterBalanceStats(balancednessScorePreRebalance, balancednessScorePostRebalance, Arrays.asList(brokerStats01, brokerStats02, brokerStats03, brokerStats04, brokerStats05), Arrays.asList(brokerStats01, brokerStats02, brokerStats03, brokerStats04, brokerStats05)), new EvenClusterLoadPlanGoalRelatedStats(movementGeneratingGoals, Arrays.asList(new EvenClusterLoadPlanGoalStats(cpuUsageDistributionGoal, avgResourcesCpu, maxResourcesCpu, minResourcesCpu, stdResourcesCpu, overviewCpu), new EvenClusterLoadPlanGoalStats(networkInboundUsageDistributionGoal, avgResourcesLeaderBytesIn, maxResourcesLeaderBytesIn, minResourcesLeaderBytesIn, stdResourcesLeaderBytesIn, overviewLeaderBytesIn)), violatedGoalsBeforeOptimization, violatedGoalsAfterOptimization));
        String planPrintableForm = plan.printableForm();
        Assertions.assertNotNull((Object)planPrintableForm);
        Assertions.assertFalse((boolean)planPrintableForm.isEmpty());
        this.assertStringContains(newBrokers.toString(), planPrintableForm);
        this.assertStringContains(deadOrRemovedBrokers.toString(), planPrintableForm);
        this.assertStringContains(excludedTopics.toString(), planPrintableForm);
        this.assertStringContains(brokersExcludedForLeadership.toString(), planPrintableForm);
        this.assertStringContains(brokersExcludedForReplicaMove.toString(), planPrintableForm);
        this.assertStringContains(String.format("%d brokers %d replicas %d topics", totalBrokers, totalReplicas, totalTopics), planPrintableForm);
        this.assertStringContains(String.format("%s (%s)", cpuUsageDistributionGoal, goalStatusCpu), planPrintableForm);
        this.assertStringContains(String.format("AVG: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", avgResourcesCpu.cpuPercent(), avgResourcesCpu.networkInboundKBps(), avgResourcesCpu.producerInboundKBps(), avgResourcesCpu.networkOutboundKBps(), avgResourcesCpu.consumerOutboundKBps(), avgResourcesCpu.diskMB(), avgResourcesCpu.potentialNwOutKBps(), avgResourcesCpu.replicas(), avgResourcesCpu.leaderReplicas(), avgResourcesCpu.topicReplicas()), planPrintableForm);
        this.assertStringContains(String.format("MAX: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", maxResourcesCpu.cpuPercent(), maxResourcesCpu.networkInboundKBps(), maxResourcesCpu.producerInboundKBps(), maxResourcesCpu.networkOutboundKBps(), maxResourcesCpu.consumerOutboundKBps(), maxResourcesCpu.diskMB(), maxResourcesCpu.potentialNwOutKBps(), maxResourcesCpu.replicas(), maxResourcesCpu.leaderReplicas(), maxResourcesCpu.topicReplicas()), planPrintableForm);
        this.assertStringContains(String.format("MIN: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", minResourcesCpu.cpuPercent(), minResourcesCpu.networkInboundKBps(), minResourcesCpu.producerInboundKBps(), minResourcesCpu.networkOutboundKBps(), minResourcesCpu.consumerOutboundKBps(), minResourcesCpu.diskMB(), minResourcesCpu.potentialNwOutKBps(), minResourcesCpu.replicas(), minResourcesCpu.leaderReplicas(), minResourcesCpu.topicReplicas()), planPrintableForm);
        this.assertStringContains(String.format("STD: {cpu:\t%.2f%% networkInbound:\t%.2fKBps producerInbound:\t%.2fKBps networkOutbound:\t%.2fKBps consumerOutbound:\t%.2fKBps disk:\t%.2fMB potentialNwOut:\t%.2fKBps replicas:\t%d leaderReplicas:\t%d topicReplicas:\t%d}", stdResourcesCpu.cpuPercent(), stdResourcesCpu.networkInboundKBps(), stdResourcesCpu.producerInboundKBps(), stdResourcesCpu.networkOutboundKBps(), stdResourcesCpu.consumerOutboundKBps(), stdResourcesCpu.diskMB(), stdResourcesCpu.potentialNwOutKBps(), stdResourcesCpu.replicas(), stdResourcesCpu.leaderReplicas(), stdResourcesCpu.topicReplicas()), planPrintableForm);
        this.assertStringContains(generatedProposalsCpu + " proposals generated", planPrintableForm);
        this.assertStringContains(rejectedProposalsCpu + " rejected", planPrintableForm);
        this.assertStringContains(acceptedProposalsCpu + " accepted", planPrintableForm);
        this.assertStringContains(movesCpu + " moves", planPrintableForm);
        this.assertStringContains(swapsCpu + " swaps", planPrintableForm);
        this.assertStringContains(String.format("%s: %d", rejectingGoal01.goalName(), rejectingGoal01.proposalsRejected()), planPrintableForm);
        this.assertStringContains(String.format("%s (%s)", networkInboundUsageDistributionGoal, leaderBytesInStatus), planPrintableForm);
        this.assertStringContains(brokerStats01.getPrintableForm(), planPrintableForm);
        this.assertStringContains(brokerStats02.getPrintableForm(), planPrintableForm);
        this.assertStringContains(brokerStats03.getPrintableForm(), planPrintableForm);
        this.assertStringContains(brokerStats04.getPrintableForm(), planPrintableForm);
        this.assertStringContains(brokerStats05.getPrintableForm(), planPrintableForm);
    }

    private void assertStringContains(String substring, String value) {
        Assertions.assertTrue((boolean)value.contains(substring), (String)("Expected string to contain '" + substring + "', but it was " + value));
    }
}

